/*
 * Decompiled with CFR 0.152.
 */
package cool.furry.mc.forge.projectexpansion.item;

import cool.furry.mc.forge.projectexpansion.Main;
import cool.furry.mc.forge.projectexpansion.tile.TileCollector;
import cool.furry.mc.forge.projectexpansion.tile.TileEMCLink;
import cool.furry.mc.forge.projectexpansion.tile.TileNBTFilterable;
import cool.furry.mc.forge.projectexpansion.tile.TileOwnable;
import cool.furry.mc.forge.projectexpansion.tile.TilePowerFlower;
import cool.furry.mc.forge.projectexpansion.tile.TileRelay;
import cool.furry.mc.forge.projectexpansion.util.EMCFormat;
import cool.furry.mc.forge.projectexpansion.util.IHasMatter;
import cool.furry.mc.forge.projectexpansion.util.Lang;
import cool.furry.mc.forge.projectexpansion.util.Matter;
import cool.furry.mc.forge.projectexpansion.util.Util;
import java.math.BigInteger;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import moze_intel.projecte.api.ProjectEAPI;
import moze_intel.projecte.api.capabilities.IKnowledgeProvider;
import moze_intel.projecte.api.proxy.IEMCProxy;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemMatterUpgrader
extends Item {
    public ItemMatterUpgrader() {
        super(new Item.Properties().func_200916_a(Main.tab));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> list, ITooltipFlag flag) {
        super.func_77624_a(stack, world, list, flag);
        list.add((ITextComponent)Lang.Items.MATTER_UPGRADER_TOOLTIP.translateColored(TextFormatting.GRAY, new Object[0]));
        list.add((ITextComponent)Lang.Items.MATTER_UPGRADER_TOOLTIP2.translateColored(TextFormatting.GREEN, new Object[0]));
        list.add((ITextComponent)Lang.Items.MATTER_UPGRADER_TOOLTIP_CREATIVE.translateColored(TextFormatting.RED, new Object[0]));
    }

    public ActionResultType onItemUseFirst(ItemStack stack, ItemUseContext context) {
        BigInteger newEmc;
        TileOwnable intBlockEntity;
        TileOwnable be;
        PlayerEntity player = context.func_195999_j();
        BlockPos pos = context.func_195995_a();
        World world = context.func_195991_k();
        if (world.field_72995_K || player == null) {
            return ActionResultType.PASS;
        }
        TileEntity blockEntity = world.func_175625_s(pos);
        Block block = world.func_180495_p(pos).func_177230_c();
        if (!(block instanceof IHasMatter)) {
            return ActionResultType.PASS;
        }
        Matter matter = ((IHasMatter)block).getMatter();
        Matter upgradeTo = matter.next();
        if (matter == Matter.FINAL) {
            player.func_146105_b((ITextComponent)Lang.Items.MATTER_UPGRADER_MAX_UPGRADE.translateColored(TextFormatting.RED, new Object[0]), true);
            return ActionResultType.FAIL;
        }
        IKnowledgeProvider provider = Util.getKnowledgeProvider(player);
        if (provider == null) {
            player.func_146105_b((ITextComponent)Lang.FAILED_TO_GET_KNOWLEDGE_PROVIDER.translateColored(TextFormatting.RED, new Object[]{player.func_145748_c_()}), true);
            return ActionResultType.FAIL;
        }
        IEMCProxy proxy = ProjectEAPI.getEMCProxy();
        BlockItem upgrade = null;
        Block upgradeBlock = null;
        TileOwnable newBlockEntity = null;
        BlockState newBlockState = null;
        if (blockEntity instanceof TileCollector) {
            upgrade = Objects.requireNonNull(upgradeTo.getCollectorItem());
            upgradeBlock = Objects.requireNonNull(upgradeTo.getCollector());
        }
        if (blockEntity instanceof TilePowerFlower) {
            be = (TilePowerFlower)blockEntity;
            upgrade = Objects.requireNonNull(upgradeTo.getPowerFlowerItem());
            upgradeBlock = Objects.requireNonNull(upgradeTo.getPowerFlower());
            if (be.owner == null) {
                return ActionResultType.FAIL;
            }
            if (!be.owner.equals(player.func_110124_au())) {
                player.func_146105_b((ITextComponent)Lang.Items.MATTER_UPGRADER_NOT_OWNER.translateColored(TextFormatting.RED, new Object[0]), true);
                return ActionResultType.FAIL;
            }
            intBlockEntity = new TilePowerFlower();
            ((TilePowerFlower)intBlockEntity).owner = be.owner;
            ((TilePowerFlower)intBlockEntity).ownerName = be.ownerName;
            ((TilePowerFlower)intBlockEntity).emc = be.emc;
            ((TilePowerFlower)intBlockEntity).func_189515_b(new CompoundNBT());
            newBlockEntity = intBlockEntity;
        }
        if (blockEntity instanceof TileEMCLink) {
            be = (TileEMCLink)blockEntity;
            upgrade = Objects.requireNonNull(upgradeTo.getEMCLinkItem());
            upgradeBlock = Objects.requireNonNull(upgradeTo.getEMCLink());
            if (((TileEMCLink)be).owner == null) {
                return ActionResultType.FAIL;
            }
            if (!((TileEMCLink)be).owner.equals(player.func_110124_au())) {
                player.func_146105_b((ITextComponent)Lang.Items.MATTER_UPGRADER_NOT_OWNER.translateColored(TextFormatting.RED, new Object[0]), true);
                return ActionResultType.FAIL;
            }
            newBlockState = (BlockState)upgradeBlock.func_176223_P().func_206870_a((Property)TileNBTFilterable.FILTER, be.func_195044_w().func_177229_b((Property)TileNBTFilterable.FILTER));
            intBlockEntity = new TileEMCLink();
            ((TileEMCLink)intBlockEntity).owner = ((TileEMCLink)be).owner;
            ((TileEMCLink)intBlockEntity).ownerName = ((TileEMCLink)be).ownerName;
            ((TileEMCLink)intBlockEntity).emc = ((TileEMCLink)be).emc;
            ((TileEMCLink)intBlockEntity).itemStack = ((TileEMCLink)be).itemStack;
            ((TileEMCLink)intBlockEntity).remainingEMC = ((TileEMCLink)be).remainingEMC;
            ((TileEMCLink)intBlockEntity).remainingImport = ((TileEMCLink)be).remainingImport;
            ((TileEMCLink)intBlockEntity).remainingExport = ((TileEMCLink)be).remainingExport;
            ((TileEMCLink)intBlockEntity).remainingFluid = ((TileEMCLink)be).remainingFluid;
            ((TileEMCLink)intBlockEntity).func_189515_b(new CompoundNBT());
            newBlockEntity = intBlockEntity;
        }
        if (blockEntity instanceof TileRelay) {
            upgrade = Objects.requireNonNull(upgradeTo.getRelayItem());
            upgradeBlock = Objects.requireNonNull(upgradeTo.getRelay());
        }
        if (!provider.hasKnowledge(new ItemStack((IItemProvider)upgrade)) && !player.func_184812_l_()) {
            player.func_146105_b((ITextComponent)Lang.Items.MATTER_UPGRADER_NOT_LEARNED.translateColored(TextFormatting.RED, new Object[]{new TranslationTextComponent(Objects.requireNonNull(upgrade).toString())}), true);
            return ActionResultType.FAIL;
        }
        long prevValue = proxy.getValue(block);
        long emcValue = proxy.getValue((Item)Objects.requireNonNull(upgrade));
        long diff = emcValue - prevValue;
        if (player.func_184812_l_()) {
            diff = 0L;
        }
        if ((newEmc = provider.getEmc().subtract(BigInteger.valueOf(diff))).compareTo(BigInteger.ZERO) < 0) {
            player.func_146105_b((ITextComponent)Lang.Items.MATTER_UPGRADER_NOT_ENOUGH_EMC.translateColored(TextFormatting.RED, new Object[]{EMCFormat.format(BigInteger.valueOf(diff))}), true);
            return ActionResultType.FAIL;
        }
        if (newBlockState == null) {
            newBlockState = upgradeBlock.func_176223_P();
        }
        world.func_217377_a(pos, false);
        world.func_175656_a(pos, newBlockState);
        if (newBlockEntity != null) {
            world.func_175713_t(pos);
            world.func_175690_a(pos, (TileEntity)newBlockEntity);
            Util.markDirty(world, pos);
        }
        provider.setEmc(newEmc);
        player.func_146105_b((ITextComponent)Lang.Items.MATTER_UPGRADER_DONE.translateColored(TextFormatting.WHITE, new Object[]{EMCFormat.format(BigInteger.valueOf(diff))}), true);
        return ActionResultType.SUCCESS;
    }
}

