/*
 * Decompiled with CFR 0.152.
 */
package cool.furry.mc.forge.projectexpansion.item;

import cool.furry.mc.forge.projectexpansion.Main;
import cool.furry.mc.forge.projectexpansion.util.Star;
import javax.annotation.Nonnull;
import moze_intel.projecte.api.capabilities.item.IItemEmcHolder;
import moze_intel.projecte.api.capabilities.tile.IEmcStorage;
import moze_intel.projecte.capability.EmcHolderItemCapabilityWrapper;
import moze_intel.projecte.gameObjs.items.ItemPE;
import moze_intel.projecte.integration.IntegrationHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;

public class ItemMagnumStar
extends ItemPE
implements IItemEmcHolder {
    public static final long[] STAR_EMC = new long[12];
    public final Star tier;

    public ItemMagnumStar(Star tier) {
        this(tier, 1);
    }

    public ItemMagnumStar(Star tier, int type) {
        super(new Item.Properties().func_200917_a(1).func_200916_a(Main.tab).func_208103_a(tier == Star.OMEGA ? Rarity.EPIC : (type == 1 ? Rarity.UNCOMMON : Rarity.RARE)));
        this.tier = tier;
        this.addItemCapability(EmcHolderItemCapabilityWrapper::new);
        this.addItemCapability("curios", IntegrationHelper.CURIO_CAP_SUPPLIER);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return stack.func_77942_o();
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        long starEmc = this.getStoredEmc(stack);
        return starEmc == 0L ? 1.0 : 1.0 - (double)starEmc / (double)this.getMaximumEmc(stack);
    }

    public long insertEmc(@Nonnull ItemStack stack, long toInsert, IEmcStorage.EmcAction action) {
        if (toInsert < 0L) {
            return this.extractEmc(stack, -toInsert, action);
        }
        long toAdd = Math.min(this.getNeededEmc(stack), toInsert);
        if (action.execute()) {
            ItemMagnumStar.addEmcToStack((ItemStack)stack, (long)toAdd);
        }
        return toAdd;
    }

    public long extractEmc(@Nonnull ItemStack stack, long toExtract, IEmcStorage.EmcAction action) {
        if (toExtract < 0L) {
            return this.insertEmc(stack, -toExtract, action);
        }
        long storedEmc = this.getStoredEmc(stack);
        long toRemove = Math.min(storedEmc, toExtract);
        if (action.execute()) {
            ItemMagnumStar.setEmc((ItemStack)stack, (long)(storedEmc - toRemove));
        }
        return toRemove;
    }

    public long getStoredEmc(@Nonnull ItemStack stack) {
        return ItemMagnumStar.getEmc((ItemStack)stack);
    }

    public long getMaximumEmc(@Nonnull ItemStack stack) {
        return STAR_EMC[this.tier.ordinal()];
    }

    static {
        long emc = 204800000L;
        for (int i = 0; i < STAR_EMC.length; ++i) {
            ItemMagnumStar.STAR_EMC[i] = emc;
            emc *= 4L;
        }
    }
}

