/*
 * Decompiled with CFR 0.152.
 */
package cool.furry.mc.forge.projectexpansion.item;

import cool.furry.mc.forge.projectexpansion.Main;
import cool.furry.mc.forge.projectexpansion.config.Config;
import cool.furry.mc.forge.projectexpansion.registries.SoundEvents;
import cool.furry.mc.forge.projectexpansion.util.ColorStyle;
import cool.furry.mc.forge.projectexpansion.util.Lang;
import cool.furry.mc.forge.projectexpansion.util.NBTNames;
import cool.furry.mc.forge.projectexpansion.util.Util;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import moze_intel.projecte.api.ItemInfo;
import moze_intel.projecte.api.capabilities.IKnowledgeProvider;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemKnowledgeSharingBook
extends Item {
    public ItemKnowledgeSharingBook() {
        super(new Item.Properties().func_200917_a(1).func_208103_a(Rarity.RARE).func_200916_a(Main.tab));
    }

    public ActionResult<ItemStack> func_77659_a(World level, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_213453_ef()) {
            if (!level.field_72995_K) {
                CompoundNBT nbt = stack.func_196082_o();
                nbt.func_186854_a(NBTNames.OWNER, player.func_110124_au());
                nbt.func_74778_a(NBTNames.OWNER_NAME, player.func_195047_I_());
                level.func_184148_a(null, player.func_213303_ch().field_72450_a, player.func_213303_ch().field_72448_b, player.func_213303_ch().field_72449_c, (SoundEvent)SoundEvents.KNOWLEDGE_SHARING_BOOK_STORE.get(), SoundCategory.PLAYERS, 0.8f, 0.8f + level.field_73012_v.nextFloat() * 0.4f);
                player.func_146105_b((ITextComponent)Lang.Items.KNOWLEDGE_SHARING_BOOK_STORED.translateColored(TextFormatting.GREEN, new Object[0]), true);
            }
            return ActionResult.func_233538_a_((Object)stack, (boolean)level.field_72995_K);
        }
        CompoundNBT nbt = stack.func_196082_o();
        if (nbt.func_186855_b(NBTNames.OWNER)) {
            UUID owner = nbt.func_186857_a(NBTNames.OWNER);
            if (player.func_110124_au().equals(nbt.func_186857_a(NBTNames.OWNER))) {
                player.func_146105_b((ITextComponent)Lang.Items.KNOWLEDGE_SHARING_BOOK_SELF.translateColored(TextFormatting.RED, new Object[0]), true);
                return ActionResult.func_226251_d_((Object)stack);
            }
            if (!level.field_72995_K) {
                IKnowledgeProvider ownerProvider = Util.getKnowledgeProvider(owner);
                IKnowledgeProvider learnerProvider = Util.getKnowledgeProvider(player);
                if (ownerProvider == null) {
                    player.func_146105_b((ITextComponent)Lang.FAILED_TO_GET_KNOWLEDGE_PROVIDER.translateColored(TextFormatting.RED, new Object[]{Util.getPlayer(owner) == null ? owner : Objects.requireNonNull(Util.getPlayer(owner)).func_145748_c_()}), true);
                    return ActionResult.func_226251_d_((Object)stack);
                }
                if (learnerProvider == null) {
                    player.func_146105_b((ITextComponent)Lang.FAILED_TO_GET_KNOWLEDGE_PROVIDER.translateColored(TextFormatting.RED, new Object[]{player.func_145748_c_()}), true);
                    return ActionResult.func_226251_d_((Object)stack);
                }
                long learned = 0L;
                for (ItemInfo info : ownerProvider.getKnowledge()) {
                    if (learnerProvider.hasKnowledge(info)) continue;
                    if (((Boolean)Config.notifyKnowledgeBookGains.get()).booleanValue() && learned < 100L) {
                        player.func_145747_a((ITextComponent)Lang.Items.KNOWLEDGE_SHARING_BOOK_LEARNED.translateColored(TextFormatting.GREEN, new Object[]{info.createStack().func_151000_E()}), Util.DUMMY_UUID);
                    }
                    learnerProvider.addKnowledge(info);
                    ++learned;
                }
                nbt.func_74772_a(NBTNames.LAST_USED, level.func_82737_E());
                nbt.func_74772_a(NBTNames.KNOWLEDGE_GAINED, learned);
                if (learned > 0L) {
                    learnerProvider.sync((ServerPlayerEntity)player);
                    if (learned > 100L) {
                        player.func_145747_a((ITextComponent)Lang.Items.KNOWLEDGE_SHARING_BOOK_LEARNED_OVER_100.translateColored(TextFormatting.GREEN, new Object[]{learned - 100L}), Util.DUMMY_UUID);
                    }
                    player.func_146105_b((ITextComponent)Lang.Items.KNOWLEDGE_SHARING_BOOK_LEARNED_TOTAL.translateColored(TextFormatting.GREEN, new Object[]{learned, new StringTextComponent(nbt.func_74779_i(NBTNames.OWNER_NAME)).func_230530_a_(ColorStyle.AQUA)}), true);
                    level.func_184148_a(null, player.func_213303_ch().field_72450_a, player.func_213303_ch().field_72448_b, player.func_213303_ch().field_72449_c, (SoundEvent)SoundEvents.KNOWLEDGE_SHARING_BOOK_USE.get(), SoundCategory.PLAYERS, 0.8f, 0.8f + level.field_73012_v.nextFloat() * 0.4f);
                } else {
                    player.func_146105_b((ITextComponent)Lang.Items.KNOWLEDGE_SHARING_BOOK_NO_NEW_KNOWLEDGE.translateColored(TextFormatting.RED, new Object[0]), true);
                    level.func_184148_a(null, player.func_213303_ch().field_72450_a, player.func_213303_ch().field_72448_b, player.func_213303_ch().field_72449_c, (SoundEvent)SoundEvents.KNOWLEDGE_SHARING_BOOK_USE_NONE.get(), SoundCategory.PLAYERS, 0.8f, 0.8f + level.field_73012_v.nextFloat() * 0.4f);
                }
            } else {
                long gained = nbt.func_74763_f(NBTNames.KNOWLEDGE_GAINED);
                for (int i = 0; i < 5; ++i) {
                    Vector3d v1 = new Vector3d(((double)level.field_73012_v.nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0).func_178789_a(-player.func_189653_aC().field_189982_i * ((float)Math.PI / 180)).func_178785_b(-player.func_189653_aC().field_189983_j * ((float)Math.PI / 180));
                    Vector3d v2 = new Vector3d(((double)level.field_73012_v.nextFloat() - 0.5) * 0.3, (double)(-level.field_73012_v.nextFloat()) * 0.6 - 0.3, 0.6).func_178789_a(-player.func_189653_aC().field_189982_i * ((float)Math.PI / 180)).func_178785_b(-player.func_189653_aC().field_189983_j * ((float)Math.PI / 180)).func_72441_c(player.func_213303_ch().field_72450_a, player.func_213303_ch().field_72448_b + (double)player.func_70047_e(), player.func_213303_ch().field_72449_c);
                    level.func_195594_a((IParticleData)(gained > 0L ? new ItemParticleData(ParticleTypes.field_197591_B, stack) : ParticleTypes.field_197601_L), v2.field_72450_a, v2.field_72448_b, v2.field_72449_c, v1.field_72450_a, v1.field_72448_b + 0.05, v1.field_72449_c);
                }
            }
            stack.func_190918_g(1);
            return ActionResult.func_233538_a_((Object)stack, (boolean)level.field_72995_K);
        }
        player.func_146105_b((ITextComponent)Lang.Items.KNOWLEDGE_SHARING_BOOK_NO_OWNER.translateColored(TextFormatting.RED, new Object[0]), true);
        return ActionResult.func_226251_d_((Object)stack);
    }

    public boolean func_77636_d(ItemStack stack) {
        return stack.func_196082_o().func_186855_b(NBTNames.OWNER);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        super.func_77624_a(stack, world, tooltip, flag);
        CompoundNBT nbt = stack.func_196082_o();
        if (nbt.func_186855_b(NBTNames.OWNER)) {
            tooltip.add((ITextComponent)Lang.Items.KNOWLEDGE_SHARING_BOOK_SELECTED.translateColored(TextFormatting.GRAY, new Object[]{new StringTextComponent(nbt.func_74779_i(NBTNames.OWNER_NAME)).func_230530_a_(ColorStyle.AQUA)}));
        }
    }
}

