/*
 * Decompiled with CFR 0.152.
 */
package cool.furry.mc.forge.projectexpansion.item;

import cool.furry.mc.forge.projectexpansion.Main;
import cool.furry.mc.forge.projectexpansion.config.Config;
import cool.furry.mc.forge.projectexpansion.util.ColorStyle;
import cool.furry.mc.forge.projectexpansion.util.EMCFormat;
import cool.furry.mc.forge.projectexpansion.util.Lang;
import cool.furry.mc.forge.projectexpansion.util.Util;
import java.math.BigInteger;
import java.util.List;
import javax.annotation.Nullable;
import moze_intel.projecte.api.capabilities.IKnowledgeProvider;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Food;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.Rarity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemInfiniteSteak
extends Item {
    public ItemInfiniteSteak() {
        super(new Item.Properties().func_200917_a(1).func_208103_a(Rarity.RARE).func_200916_a(Main.tab));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> list, ITooltipFlag flag) {
        super.func_77624_a(stack, world, list, flag);
        list.add((ITextComponent)Lang.Items.INFINITE_STEAK_TOOLTIP.translateColored(TextFormatting.GRAY, new Object[0]));
        list.add((ITextComponent)Lang.COST.translateColored(TextFormatting.RED, new Object[]{EMCFormat.getComponent(((Integer)Config.infiniteSteakCost.get()).intValue()).func_230530_a_(ColorStyle.GRAY)}));
    }

    public int func_77626_a(ItemStack stack) {
        return Items.field_151083_be.func_77626_a(stack);
    }

    public boolean func_77636_d(ItemStack stack) {
        return true;
    }

    public boolean func_219971_r() {
        return true;
    }

    @Nullable
    public Food func_219967_s() {
        return Items.field_151083_be.func_219967_s();
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        IKnowledgeProvider provider = Util.getKnowledgeProvider(player);
        if (!player.func_71043_e(false) || (Integer)Config.infiniteSteakCost.get() == 0 || provider == null || provider.getEmc().compareTo(BigInteger.valueOf(((Integer)Config.infiniteSteakCost.get()).intValue())) < 0) {
            return ActionResult.func_226251_d_((Object)stack);
        }
        player.func_184598_c(hand);
        return ActionResult.func_233538_a_((Object)stack, (boolean)world.field_72995_K);
    }

    public ItemStack func_77654_b(ItemStack stack, World level, LivingEntity entity) {
        if (!(entity instanceof ServerPlayerEntity) || level.field_72995_K) {
            return stack;
        }
        ServerPlayerEntity player = (ServerPlayerEntity)entity;
        IKnowledgeProvider provider = Util.getKnowledgeProvider((PlayerEntity)player);
        if (provider == null) {
            player.func_146105_b((ITextComponent)Lang.FAILED_TO_GET_KNOWLEDGE_PROVIDER.translateColored(TextFormatting.RED, new Object[]{player.func_145748_c_()}), true);
            return stack;
        }
        BigInteger emc = provider.getEmc().subtract(BigInteger.valueOf(((Integer)Config.infiniteSteakCost.get()).intValue()));
        if (emc.compareTo(BigInteger.ZERO) < 0) {
            player.func_146105_b((ITextComponent)Lang.Items.INFINITE_STEAK_NOT_ENOUGH_EMC.translateColored(TextFormatting.RED, new Object[]{new StringTextComponent(((Integer)Config.infiniteSteakCost.get()).toString())}), true);
            return stack;
        }
        provider.setEmc(emc);
        provider.syncEmc(player);
        player.func_213357_a(level, new ItemStack((IItemProvider)Items.field_151083_be));
        return stack;
    }
}

