/*
 * Decompiled with CFR 0.152.
 */
package cool.furry.mc.forge.projectexpansion.item;

import cool.furry.mc.forge.projectexpansion.Main;
import cool.furry.mc.forge.projectexpansion.capability.CapabilityAlchemicalBookLocations;
import cool.furry.mc.forge.projectexpansion.config.Config;
import cool.furry.mc.forge.projectexpansion.net.PacketHandler;
import cool.furry.mc.forge.projectexpansion.net.packets.to_client.PacketOpenAlchemicalBookGUI;
import cool.furry.mc.forge.projectexpansion.util.Lang;
import cool.furry.mc.forge.projectexpansion.util.NBTNames;
import cool.furry.mc.forge.projectexpansion.util.Util;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemAlchemicalBook
extends Item {
    private final Tier tier;

    public ItemAlchemicalBook(Tier tier) {
        super(new Item.Properties().func_200916_a(Main.tab).func_208103_a(tier.getRarity()).func_200917_a(1).func_234689_a_());
        this.tier = tier;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World level, List<ITextComponent> list, ITooltipFlag flag) {
        super.func_77624_a(stack, level, list, flag);
        list.add((ITextComponent)Lang.Items.ALCHEMICAL_BOOK_TOOLTIP.translateColored(TextFormatting.GRAY, new Object[0]));
        switch (this.tier) {
            case BASIC: {
                list.add((ITextComponent)Lang.Items.ALCHEMICAL_BOOK_TOOLTIP_BASIC.translateColored(TextFormatting.RED, new Object[]{1000}));
                break;
            }
            case ADVANCED: {
                list.add((ITextComponent)Lang.Items.ALCHEMICAL_BOOK_TOOLTIP_ADVANCED.translateColored(TextFormatting.RED, new Object[]{500}));
                list.add((ITextComponent)Lang.Items.ALCHEMICAL_BOOK_TOOLTIP_BIND.translateColored(TextFormatting.GREEN, new Object[0]));
                break;
            }
            case MASTER: {
                list.add((ITextComponent)Lang.Items.ALCHEMICAL_BOOK_TOOLTIP_MASTER.translateColored(TextFormatting.RED, new Object[]{100}));
                list.add((ITextComponent)Lang.Items.ALCHEMICAL_BOOK_TOOLTIP_BIND.translateColored(TextFormatting.GREEN, new Object[0]));
                list.add((ITextComponent)Lang.Items.ALCHEMICAL_BOOK_TOOLTIP_ACROSS_DIMENSIONS.translateColored(TextFormatting.GREEN, new Object[0]));
                break;
            }
            case ARCANE: {
                list.add((ITextComponent)Lang.Items.ALCHEMICAL_BOOK_TOOLTIP_ARCANE.translateColored(TextFormatting.RED, new Object[]{0}));
                list.add((ITextComponent)Lang.Items.ALCHEMICAL_BOOK_TOOLTIP_BIND.translateColored(TextFormatting.GREEN, new Object[0]));
                list.add((ITextComponent)Lang.Items.ALCHEMICAL_BOOK_TOOLTIP_ACROSS_DIMENSIONS.translateColored(TextFormatting.GREEN, new Object[0]));
            }
        }
        if (this.getMode(stack) == Mode.PLAYER) {
            ServerPlayerEntity player = this.getPlayer(stack);
            list.add((ITextComponent)Lang.Items.ALCHEMICAL_BOOK_BOUND_TO.translateColored(TextFormatting.RED, new Object[]{player == null ? new StringTextComponent(stack.func_196082_o().func_74779_i(NBTNames.OWNER_NAME)).func_240699_a_(TextFormatting.DARK_AQUA) : player.func_145748_c_().func_230532_e_().func_240699_a_(TextFormatting.DARK_AQUA)}));
        }
        list.add((ITextComponent)Lang.SEE_WIKI.translateColored(TextFormatting.AQUA, new Object[0]));
    }

    @Nullable
    public ServerPlayerEntity getPlayer(ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemAlchemicalBook && ((ItemAlchemicalBook)stack.func_77973_b()).getMode(stack) == Mode.STACK) {
            return null;
        }
        return Util.getPlayer(stack.func_196082_o().func_186857_a(NBTNames.OWNER));
    }

    public Mode getMode(ItemStack stack) {
        return stack.func_77942_o() && stack.func_196082_o().func_74764_b(NBTNames.OWNER) ? Mode.PLAYER : Mode.STACK;
    }

    public Tier getTier() {
        return this.tier;
    }

    public ActionResult<ItemStack> func_77659_a(World level, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!level.field_72995_K) {
            if (player.func_213453_ef() && this.getTier().canBindToPlayer()) {
                CompoundNBT tag = stack.func_196082_o();
                if (this.getMode(stack) == Mode.PLAYER) {
                    if (!tag.func_186857_a(NBTNames.OWNER).equals(player.func_110124_au())) {
                        Util.sendSystemMessage(player, (ITextComponent)Lang.NOT_OWNER.translateColored(TextFormatting.RED, new Object[]{new StringTextComponent(tag.func_74779_i(NBTNames.OWNER_NAME)).func_240699_a_(TextFormatting.DARK_AQUA)}));
                        return ActionResult.func_226251_d_((Object)stack);
                    }
                    tag.func_82580_o(NBTNames.OWNER);
                    tag.func_82580_o(NBTNames.OWNER_NAME);
                    Util.sendSystemMessage(player, (ITextComponent)Lang.Items.ALCHEMICAL_BOOK_NO_LONGER_BOUND.translateColored(TextFormatting.GREEN, new Object[]{tag.func_74779_i(NBTNames.OWNER_NAME)}));
                } else {
                    tag.func_186854_a(NBTNames.OWNER, player.func_110124_au());
                    tag.func_74778_a(NBTNames.OWNER_NAME, player.func_200200_C_().getString());
                    Util.sendSystemMessage(player, (ITextComponent)Lang.Items.ALCHEMICAL_BOOK_NOW_BOUND.translateColored(TextFormatting.GREEN, new Object[]{tag.func_74779_i(NBTNames.OWNER_NAME)}));
                }
            } else {
                try {
                    PacketHandler.sendTo(new PacketOpenAlchemicalBookGUI(hand, (List<CapabilityAlchemicalBookLocations.TeleportLocation>)CapabilityAlchemicalBookLocations.from(stack).getLocations(), this.getMode(stack), ItemAlchemicalBook.canEdit(stack, (ServerPlayerEntity)player)), (ServerPlayerEntity)player);
                }
                catch (CapabilityAlchemicalBookLocations.BookError.OwnerOfflineError ignore) {
                    Util.sendSystemMessage(player, (ITextComponent)Lang.Items.ALCHEMICAL_BOOK_OWNER_NOT_ONLINE.translateColored(TextFormatting.RED, new Object[0]));
                    return ActionResult.func_226251_d_((Object)stack);
                }
            }
        }
        return ActionResult.func_226248_a_((Object)stack);
    }

    public static boolean canEdit(ItemStack stack, ServerPlayerEntity player) {
        if (!(stack.func_77973_b() instanceof ItemAlchemicalBook)) {
            return false;
        }
        ServerPlayerEntity owner = ((ItemAlchemicalBook)stack.func_77973_b()).getPlayer(stack);
        if (owner == null) {
            return true;
        }
        return ItemAlchemicalBook.canEdit(player, owner);
    }

    public static boolean canEdit(ServerPlayerEntity player, ServerPlayerEntity owner) {
        Config.AlchemicalBookEditLevel editLevel = Config.editOthersAlchemicalBooks();
        if (editLevel == Config.AlchemicalBookEditLevel.ENABLED) {
            return true;
        }
        if (player.func_211513_k(2) && editLevel == Config.AlchemicalBookEditLevel.OP_ONLY) {
            return true;
        }
        return owner.equals((Object)player);
    }

    public boolean func_77636_d(ItemStack stack) {
        return stack.func_196082_o().func_74764_b(NBTNames.OWNER);
    }

    public static enum Tier {
        BASIC,
        ADVANCED,
        MASTER,
        ARCANE;


        public boolean isAcrossDimensions() {
            return this == MASTER || this == ARCANE;
        }

        public boolean canBindToPlayer() {
            return this == ADVANCED || this == MASTER || this == ARCANE;
        }

        public float distanceRatio() {
            switch (this) {
                case BASIC: {
                    return 1000.0f;
                }
                case ADVANCED: {
                    return 500.0f;
                }
                case MASTER: {
                    return 100.0f;
                }
                case ARCANE: {
                    return 0.0f;
                }
            }
            throw new IllegalStateException("Unexpected value: " + (Object)((Object)this));
        }

        public Rarity getRarity() {
            switch (this) {
                case BASIC: {
                    return Rarity.COMMON;
                }
                case ADVANCED: {
                    return Rarity.UNCOMMON;
                }
                case MASTER: {
                    return Rarity.RARE;
                }
                case ARCANE: {
                    return Rarity.EPIC;
                }
            }
            throw new IllegalStateException("Unexpected value: " + (Object)((Object)this));
        }
    }

    public static enum Mode {
        PLAYER,
        STACK;

    }
}

