/*
 * Decompiled with CFR 0.152.
 */
package cool.furry.mc.forge.projectexpansion.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import cool.furry.mc.forge.projectexpansion.capability.CapabilityAlchemicalBookLocations;
import cool.furry.mc.forge.projectexpansion.item.ItemAlchemicalBook;
import cool.furry.mc.forge.projectexpansion.net.PacketHandler;
import cool.furry.mc.forge.projectexpansion.net.packets.to_server.PacketCreateTeleportDestination;
import cool.furry.mc.forge.projectexpansion.net.packets.to_server.PacketDeleteTeleportDestination;
import cool.furry.mc.forge.projectexpansion.net.packets.to_server.PacketTeleportBack;
import cool.furry.mc.forge.projectexpansion.net.packets.to_server.PacketTeleportToDestination;
import cool.furry.mc.forge.projectexpansion.util.EMCFormat;
import cool.furry.mc.forge.projectexpansion.util.Lang;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import moze_intel.projecte.api.ProjectEAPI;
import moze_intel.projecte.api.capabilities.IKnowledgeProvider;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;
import org.apache.commons.lang3.StringUtils;

@OnlyIn(value=Dist.CLIENT)
public class GUIAlchemicalBook
extends Screen {
    private final List<CapabilityAlchemicalBookLocations.TeleportLocation> locations = new ArrayList<CapabilityAlchemicalBookLocations.TeleportLocation>();
    public static final int BUTTONS_PER_COLUMN = 8;
    ButtonCreate buttonCreate;
    ButtonBack buttonBack;
    ButtonClose buttonClose;
    TextFieldWidget createName;
    ClientPlayerEntity player;
    Hand hand;
    ArrayList<ButtonTeleport> teleportButtons = new ArrayList();
    ArrayList<ButtonDelete> deleteButtons = new ArrayList();
    @Nullable
    private IKnowledgeProvider knowledgeProvider = null;
    private boolean canEdit;
    private final boolean acrossDimensions;
    private final int w = 90;
    private final int h = 20;

    public GUIAlchemicalBook(ClientPlayerEntity player, Hand hand, List<CapabilityAlchemicalBookLocations.TeleportLocation> locations, boolean canEdit) {
        super((ITextComponent)Lang.ALCHEMICAL_BOOK.translate(new Object[0]));
        this.player = player;
        this.hand = hand;
        this.locations.addAll(locations);
        this.canEdit = canEdit;
        this.acrossDimensions = this.getTier().isAcrossDimensions();
    }

    private IKnowledgeProvider getKnowledgeCapability() {
        if (this.knowledgeProvider == null) {
            LazyOptional lazyOptional = this.player.getCapability(ProjectEAPI.KNOWLEDGE_CAPABILITY);
            this.knowledgeProvider = (IKnowledgeProvider)lazyOptional.orElseThrow(() -> new IllegalStateException("Player does not have knowledge capability"));
            lazyOptional.addListener(optional -> {
                this.knowledgeProvider = null;
            });
        }
        return this.knowledgeProvider;
    }

    private ItemStack getItemStack() {
        return this.player.func_184586_b(this.hand);
    }

    private ItemAlchemicalBook.Tier getTier() {
        return ((ItemAlchemicalBook)this.getItemStack().func_77973_b()).getTier();
    }

    private boolean canTeleport(CapabilityAlchemicalBookLocations.TeleportLocation location) {
        return this.getKnowledgeCapability().getEmc().compareTo(BigInteger.valueOf(location.getCost(this.getItemStack(), (PlayerEntity)this.player))) >= 0;
    }

    protected void func_231160_c_() {
        this.buttonCreate = new ButtonCreate(this.field_230708_k_ / 2 - 90, 20, 90, 20);
        this.func_230480_a_((Widget)this.buttonCreate);
        this.buttonClose = new ButtonClose(this.field_230708_k_ / 2 - 90 - 50, 20);
        this.func_230480_a_((Widget)this.buttonClose);
        this.createName = new TextFieldWidget(this.field_230712_o_, this.buttonCreate.field_230690_l_ + this.buttonCreate.func_230998_h_() + 10, this.buttonCreate.field_230691_m_, 90, 20, (ITextComponent)Lang.ALCHEMICAL_BOOK_CREATE.translate(new Object[0]));
        this.createName.func_146203_f(20);
        this.createName.func_146195_b(true);
        if (!this.canEdit) {
            this.buttonCreate.field_230693_o_ = false;
            this.createName.func_146184_c(false);
        } else {
            this.createName.func_212954_a(str -> {
                this.buttonCreate.field_230693_o_ = !str.isEmpty();
                this.buttonCreate.setName(str);
            });
        }
        String biomeName = Objects.requireNonNull(this.player.field_70170_p.func_241828_r().func_243612_b(Registry.field_239720_u_).func_177774_c((Object)this.player.field_70170_p.func_226691_t_(this.player.func_226268_ag_()))).func_110623_a();
        this.createName.func_146180_a(Arrays.stream(biomeName.split("_")).map(StringUtils::capitalize).reduce("", (a, b) -> a + " " + b).trim());
        this.buttonBack = new ButtonBack(this.createName.field_230690_l_ + this.createName.func_230998_h_() + 8, this.buttonClose.field_230691_m_, 45, 20);
        this.func_230480_a_((Widget)this.buttonBack);
        this.func_230481_d_((IGuiEventListener)this.createName);
        this.drawLocations();
    }

    public void func_230430_a_(MatrixStack stack, int x, int y, float z) {
        this.createName.func_230430_a_(stack, x, y, z);
        super.func_230430_a_(stack, x, y, z);
    }

    private void removeWidget(IGuiEventListener widget) {
        if (widget instanceof Button) {
            this.field_230710_m_.remove(widget);
        }
        this.field_230705_e_.remove(widget);
    }

    public void drawLocations() {
        int xStart;
        int ypad = 1;
        int delete_w = 20;
        int rowpad = 8;
        this.teleportButtons.forEach(this::removeWidget);
        this.teleportButtons.clear();
        this.deleteButtons.forEach(this::removeWidget);
        this.deleteButtons.clear();
        int yStart = 45;
        int x = xStart = this.field_230708_k_ / 10;
        int y = yStart;
        boolean hasBack = false;
        for (CapabilityAlchemicalBookLocations.TeleportLocation loc : this.locations) {
            if (loc.isBack()) {
                this.buttonBack.updateLocation(loc);
                hasBack = true;
                continue;
            }
            if (loc.index() % 8 == 0) {
                x += 90 + delete_w + rowpad;
                y = yStart;
            } else {
                y += 20 + ypad;
            }
            ButtonTeleport teleportButton = new ButtonTeleport(x, y, 90, 20, loc);
            ButtonDelete deleteButton = new ButtonDelete(x - delete_w - 2, y, delete_w, 20, loc.name());
            deleteButton.field_230693_o_ = this.canEdit;
            this.func_230480_a_((Widget)teleportButton);
            this.func_230480_a_((Widget)deleteButton);
            this.teleportButtons.add(teleportButton);
            this.deleteButtons.add(deleteButton);
        }
        if (!hasBack) {
            this.buttonBack.updateLocation(null);
        }
    }

    private void rebuildWidgets() {
        this.field_230710_m_.clear();
        this.field_230705_e_.clear();
        this.func_231035_a_(null);
        this.func_231160_c_();
    }

    public void setLocations(List<CapabilityAlchemicalBookLocations.TeleportLocation> locations, boolean canEdit) {
        this.locations.clear();
        this.locations.addAll(locations);
        if (canEdit != this.canEdit) {
            this.canEdit = canEdit;
            this.rebuildWidgets();
        } else {
            this.drawLocations();
        }
    }

    public boolean func_231177_au__() {
        return false;
    }

    public ArrayList<ITextComponent> getTeleportationTooltips(CapabilityAlchemicalBookLocations.TeleportLocation location, boolean canTeleport) {
        ArrayList<ITextComponent> tooltips = new ArrayList<ITextComponent>();
        if (canTeleport) {
            int cost;
            tooltips.add((ITextComponent)new StringTextComponent(String.format("%d, %d, %d", location.x(), location.y(), location.z())));
            int distance = (int)location.distanceFrom(this.player.func_226268_ag_());
            if (distance > 0) {
                tooltips.add((ITextComponent)Lang.ALCHEMICAL_BOOK_DISTANCE.translate(new Object[]{distance}));
            }
            if ((cost = location.getCost(this.getItemStack(), (PlayerEntity)this.player)) > 0) {
                tooltips.add((ITextComponent)Lang.ALCHEMICAL_BOOK_COST.translate(new Object[]{EMCFormat.getComponent(cost).func_240699_a_(TextFormatting.YELLOW)}));
            }
        } else {
            tooltips.add((ITextComponent)Lang.ALCHEMICAL_BOOK_DIMENSION.translate(new Object[]{new TranslationTextComponent(location.dimension().func_240901_a_().toString().replace(":", "."))}));
        }
        return tooltips;
    }

    private class ButtonBack
    extends Button {
        @Nullable
        private CapabilityAlchemicalBookLocations.TeleportLocation location;
        private boolean canTeleport;

        public ButtonBack(int x, int y, int w, int h) {
            super(x, y, w, h, (ITextComponent)Lang.ALCHEMICAL_BOOK_BACK.translate(new Object[0]), button -> PacketHandler.sendToServer(new PacketTeleportBack((PlayerEntity)cool$furry$mc$forge$projectexpansion$gui$GUIAlchemicalBook$this.player, cool$furry$mc$forge$projectexpansion$gui$GUIAlchemicalBook$this.hand)));
        }

        public void func_230443_a_(MatrixStack matrix, int pMouseX, int pMouseY) {
            if (this.func_230449_g_() || this.func_230999_j_()) {
                if (this.location == null) {
                    GUIAlchemicalBook.this.func_243308_b(matrix, Collections.singletonList(Lang.ALCHEMICAL_BOOK_NO_BACK_LOCATION.translate(new Object[0])), pMouseX, pMouseY);
                    return;
                }
                ArrayList<ITextComponent> tooltips = GUIAlchemicalBook.this.getTeleportationTooltips(this.location, this.canTeleport);
                GUIAlchemicalBook.this.func_243308_b(matrix, tooltips, pMouseX, pMouseY);
            }
            super.func_230443_a_(matrix, pMouseX, pMouseY);
        }

        public void updateLocation(@Nullable CapabilityAlchemicalBookLocations.TeleportLocation location) {
            if (location == null) {
                this.field_230693_o_ = false;
                this.location = null;
                this.canTeleport = false;
            } else {
                this.field_230693_o_ = true;
                this.location = location;
                this.canTeleport = GUIAlchemicalBook.this.acrossDimensions || location.dimension().equals((Object)GUIAlchemicalBook.this.player.field_70170_p.func_234923_W_());
            }
        }
    }

    private class ButtonTeleport
    extends Button {
        CapabilityAlchemicalBookLocations.TeleportLocation location;
        boolean canTeleport;
        boolean hasEnoughEMC;

        public ButtonTeleport(int x, int y, int w, int h, CapabilityAlchemicalBookLocations.TeleportLocation location) {
            super(x, y, w, h, (ITextComponent)new StringTextComponent(location.name()), button -> {
                PacketHandler.sendToServer(new PacketTeleportToDestination(location.name(), (PlayerEntity)cool$furry$mc$forge$projectexpansion$gui$GUIAlchemicalBook$this.player, cool$furry$mc$forge$projectexpansion$gui$GUIAlchemicalBook$this.hand));
                cool$furry$mc$forge$projectexpansion$gui$GUIAlchemicalBook$this.player.func_71053_j();
            });
            this.location = location;
            this.hasEnoughEMC = GUIAlchemicalBook.this.canTeleport(location);
            this.canTeleport = GUIAlchemicalBook.this.acrossDimensions || location.dimension().equals((Object)GUIAlchemicalBook.this.player.field_70170_p.func_234923_W_());
            this.field_230693_o_ = this.canTeleport && this.hasEnoughEMC;
        }

        public void func_230443_a_(MatrixStack matrix, int pMouseX, int pMouseY) {
            if (this.func_230449_g_() || this.func_230999_j_()) {
                ArrayList<ITextComponent> tooltips = GUIAlchemicalBook.this.getTeleportationTooltips(this.location, this.canTeleport);
                GUIAlchemicalBook.this.func_243308_b(matrix, tooltips, pMouseX, pMouseY);
            }
            super.func_230443_a_(matrix, pMouseX, pMouseY);
        }
    }

    private class ButtonDelete
    extends Button {
        public ButtonDelete(int x, int y, int w, int h, String name) {
            super(x, y, w, h, (ITextComponent)new StringTextComponent("X"), button -> PacketHandler.sendToServer(new PacketDeleteTeleportDestination(name, (PlayerEntity)cool$furry$mc$forge$projectexpansion$gui$GUIAlchemicalBook$this.player, cool$furry$mc$forge$projectexpansion$gui$GUIAlchemicalBook$this.hand)));
        }
    }

    private class ButtonCreate
    extends Button {
        String name;

        public ButtonCreate(int x, int y, int w, int h) {
            super(x, y, w, h, (ITextComponent)Lang.ALCHEMICAL_BOOK_CREATE.translate(new Object[0]), button -> {});
        }

        public void func_230982_a_(double p_93371_, double p_93372_) {
            if (this.name == null) {
                return;
            }
            PacketHandler.sendToServer(new PacketCreateTeleportDestination(this.name, (PlayerEntity)GUIAlchemicalBook.this.player, GUIAlchemicalBook.this.hand));
        }

        private void setName(String name) {
            this.name = name;
        }
    }

    private class ButtonClose
    extends Button {
        public ButtonClose(int x, int y) {
            super(x, y, 40, 20, (ITextComponent)Lang.ALCHEMICAL_BOOK_CLOSE.translate(new Object[0]), button -> cool$furry$mc$forge$projectexpansion$gui$GUIAlchemicalBook$this.player.func_71053_j());
        }
    }
}

