/*
 * Decompiled with CFR 0.152.
 */
package cool.furry.mc.forge.projectexpansion.gui;

import cool.furry.mc.forge.projectexpansion.config.Config;
import cool.furry.mc.forge.projectexpansion.util.EMCFormat;
import java.math.BigInteger;
import javax.annotation.Nullable;
import moze_intel.projecte.api.ProjectEAPI;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="projectexpansion", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class EMCDisplay {
    private static BigInteger emc = BigInteger.ZERO;
    private static final BigInteger[] history = new BigInteger[]{BigInteger.ZERO, BigInteger.ZERO};
    private static BigInteger lastEMC = BigInteger.ZERO;
    private static int tick = 0;

    @Nullable
    private static ClientPlayerEntity getPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    @SubscribeEvent
    public static void onTick(TickEvent.ClientTickEvent event) {
        if (!((Boolean)Config.emcDisplay.get()).booleanValue()) {
            return;
        }
        ClientPlayerEntity player = EMCDisplay.getPlayer();
        if (event.phase == TickEvent.Phase.END && player != null && ++tick >= 20) {
            tick = 0;
            player.getCapability(ProjectEAPI.KNOWLEDGE_CAPABILITY).ifPresent(provider -> {
                emc = provider.getEmc();
                EMCDisplay.history[1] = history[0];
                EMCDisplay.history[0] = emc.subtract(lastEMC);
                lastEMC = emc;
            });
        }
    }

    private static void reset() {
        emc = lastEMC = BigInteger.ZERO;
        tick = 0;
    }

    @SubscribeEvent
    public static void clientDisconnect(ClientPlayerNetworkEvent.LoggedOutEvent event) {
        if (!((Boolean)Config.emcDisplay.get()).booleanValue()) {
            return;
        }
        EMCDisplay.reset();
    }

    @SubscribeEvent
    public static void onWorldUnload(WorldEvent.Unload event) {
        if (!((Boolean)Config.emcDisplay.get()).booleanValue()) {
            return;
        }
        EMCDisplay.reset();
    }

    @SubscribeEvent
    public static void onRenderGUI(RenderGameOverlayEvent.Text event) {
        if (!((Boolean)Config.emcDisplay.get()).booleanValue()) {
            return;
        }
        BigInteger avg = history[0].add(history[1]);
        String str = EMCFormat.format(emc);
        if (!avg.equals(BigInteger.ZERO)) {
            str = str + " " + (avg.compareTo(BigInteger.ZERO) > 0 ? TextFormatting.GREEN + "+" : TextFormatting.RED + "-") + EMCFormat.format(avg.abs()) + "/s";
        }
        event.getLeft().add(String.format("EMC: %s", str));
    }
}

