/*
 * Decompiled with CFR 0.152.
 */
package cool.furry.mc.forge.projectexpansion.config;

import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;

public final class Config {
    public static final ForgeConfigSpec.Builder Builder = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec Spec;
    public static final ForgeConfigSpec.ConfigValue<Integer> tickDelay;
    public static final ForgeConfigSpec.ConfigValue<Boolean> formatEMC;
    public static final ForgeConfigSpec.ConfigValue<Boolean> fullNumberNames;
    public static final ForgeConfigSpec.ConfigValue<Boolean> emcDisplay;
    public static final ForgeConfigSpec.ConfigValue<Boolean> notifyCommandChanges;
    public static final ForgeConfigSpec.ConfigValue<Boolean> notifyKnowledgeBookGains;
    public static final ForgeConfigSpec.ConfigValue<Boolean> limitEmcLinkVendor;
    public static final ForgeConfigSpec.ConfigValue<Boolean> enableFluidEfficiency;
    public static final ForgeConfigSpec.ConfigValue<Integer> transmutationInterfaceItemCount;
    public static final ForgeConfigSpec.ConfigValue<Double> collectorMultiplier;
    public static final ForgeConfigSpec.ConfigValue<Double> emcLinkItemLimitMultiplier;
    public static final ForgeConfigSpec.ConfigValue<Double> emcLinkFluidLimitMultiplier;
    public static final ForgeConfigSpec.ConfigValue<Double> emcLinkEMCLimitMultiplier;
    public static final ForgeConfigSpec.ConfigValue<Double> powerflowerMultiplier;
    public static final ForgeConfigSpec.ConfigValue<Double> relayBonusMultiplier;
    public static final ForgeConfigSpec.ConfigValue<Double> relayTransferMultiplier;
    public static final ForgeConfigSpec.ConfigValue<Integer> infiniteFuelCost;
    public static final ForgeConfigSpec.ConfigValue<Integer> infiniteFuelBurnTime;
    public static final ForgeConfigSpec.ConfigValue<Integer> infiniteSteakCost;
    public static final ForgeConfigSpec.ConfigValue<Boolean> persistEnchantedBooksOnly;
    public static final ForgeConfigSpec.ConfigValue<Boolean> enabledLearnedTooltip;
    public static final ForgeConfigSpec.ConfigValue<Boolean> alchemicalCollectionSound;
    private static final ForgeConfigSpec.ConfigValue<String> editOthersAlchemicalBooks;
    public static final ForgeConfigSpec.ConfigValue<Boolean> zeroEmcFluidsAreFree;

    public static AlchemicalBookEditLevel editOthersAlchemicalBooks() {
        try {
            return AlchemicalBookEditLevel.valueOf(((String)editOthersAlchemicalBooks.get()).toUpperCase());
        }
        catch (IllegalArgumentException ignore) {
            LogManager.getLogger(Config.class).printf(Level.WARN, "Invalid value for editOthersAlchemicalBooks: %. Defaulting to %s", new Object[]{editOthersAlchemicalBooks.get(), AlchemicalBookEditLevel.DISABLED.name()});
            editOthersAlchemicalBooks.set((Object)AlchemicalBookEditLevel.DISABLED.name());
            return AlchemicalBookEditLevel.DISABLED;
        }
    }

    static {
        tickDelay = Builder.comment("The delay between mod operations (in ticks, default 20) - this will slightly effect the amount of emc generated via rounding - increase if you're noticing lag").defineInRange("tickDelay", 20, 1, 200);
        formatEMC = Builder.comment("If EMC should be formatted as M/B/T/etc").define("formatEMC", true);
        fullNumberNames = Builder.comment("If full number names (Million/Billion/Trillion) should be used instead of abbreviations").define("fullNumberNames", true);
        emcDisplay = Builder.comment("Displays your current emc and gained emc per second in the top left corner.").define("emcDisplay", true);
        notifyCommandChanges = Builder.comment("Notify users something is changed about them via /emc.").define("notifyCommandChanges", true);
        notifyKnowledgeBookGains = Builder.comment("Tell users the list of items they gained when using a knowledge book.").define("notifyKnowledgeBookGains", true);
        limitEmcLinkVendor = Builder.comment("If EMC Link Right-Click functionality should be Limited by Tier or Not.").define("limitEmcLinkVendor", true);
        enableFluidEfficiency = Builder.comment("If fluid efficiency should be enabled.").define("enableFluidEfficiency", true);
        transmutationInterfaceItemCount = Builder.comment("The amount of items that the transmutation interface will report to have. Depending on your usage, you may want this to be a high value.").defineInRange("transmutationInterfaceItemCount", Integer.MAX_VALUE, 1, Integer.MAX_VALUE);
        collectorMultiplier = Builder.comment("Multiplies the output of Collectors.").defineInRange("collectorMultiplier", 1.0, 0.1, 50.0);
        emcLinkItemLimitMultiplier = Builder.comment("Multiplies the item limit of EMC Links.").defineInRange("emcLinkItemLimitMultiplier", 1.0, 0.1, 50.0);
        emcLinkFluidLimitMultiplier = Builder.comment("Multiplies the fluid limit of EMC Links.").defineInRange("emcLinkFluidLimitMultiplier", 1.0, 0.1, 50.0);
        emcLinkEMCLimitMultiplier = Builder.comment("Multiplies the emc limit of EMC Links.").defineInRange("emcLinkEMCLimitMultiplier", 1.0, 0.1, 50.0);
        powerflowerMultiplier = Builder.comment("Multiplies the output of Power Flowers.").defineInRange("powerflowerMultiplier", 1.0, 0.1, 50.0);
        relayBonusMultiplier = Builder.comment("Multiplies the bonus of Relays.").defineInRange("relayBonusMultiplier", 1.0, 0.1, 50.0);
        relayTransferMultiplier = Builder.comment("Multiplies the transfer limit of Relays.").defineInRange("relayTransferMultiplier", 1.0, 0.1, 50.0);
        infiniteFuelCost = Builder.comment("The cost of using the infinite fuel item.").defineInRange("infiniteFuelCost", 128, 1, Integer.MAX_VALUE);
        infiniteFuelBurnTime = Builder.comment("The ticks each usage of the infinite fuel item will give.").defineInRange("infiniteFuelBurnTime", 1600, 1, Integer.MAX_VALUE);
        infiniteSteakCost = Builder.comment("The cost of using the infinite steak item.").defineInRange("infiniteSteakCost", 64, 1, Integer.MAX_VALUE);
        persistEnchantedBooksOnly = Builder.comment("If ProjectE's processors.EnchantmentProcessor.persistent option should only include enchanted books.").define("persistEnchantedBooksOnly", false);
        enabledLearnedTooltip = Builder.comment("If a tooltip should be shown on items which can be learned, denoting if the item has been learned or not. Note: ProjectE's client.shiftEmcToolTips applies to this.").define("enabledLearnedTooltip", true);
        alchemicalCollectionSound = Builder.comment("If a sound should be played when something is collected with Alchemical Collection.").define("alchemicalCollectionSound", true);
        editOthersAlchemicalBooks = Builder.comment("If players should be allowed to edit books bound to other players. A player is considered to be \"OP\" when they have an op level of 2 or greater. Allowed values: DISABLED, OP_ONLY, ENABLED").define("editOthersAlchemicalBooks", (Object)AlchemicalBookEditLevel.DISABLED.name());
        zeroEmcFluidsAreFree = Builder.comment("If fluids which end their calculations at zero emc should be returned as free.").define("zeroEmcFluidsAreFree", true);
        Spec = Builder.build();
    }

    public static enum AlchemicalBookEditLevel {
        DISABLED,
        OP_ONLY,
        ENABLED;

    }
}

