/*
 * Decompiled with CFR 0.152.
 */
package cool.furry.mc.forge.projectexpansion.commands;

import java.util.ArrayList;
import java.util.function.Predicate;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.server.permission.DefaultPermissionLevel;
import net.minecraftforge.server.permission.PermissionAPI;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class Permissions {
    public static final int LEVEL_ALL = 0;
    public static final int LEVEL_MODERATORS = 1;
    public static final int LEVEL_GAMEMASTERS = 2;
    public static final int LEVEL_ADMINS = 3;
    public static final int LEVEL_OWNERS = 4;
    private static final ArrayList<String> NODES = new ArrayList();
    public static final CommandPermissionNode EMC = Permissions.nodeOpCommand("emc");
    public static final CommandPermissionNode EMC_ADD = Permissions.nodeOpCommand("emc.add");
    public static final CommandPermissionNode EMC_GET = Permissions.nodeOpCommand("emc.get");
    public static final CommandPermissionNode EMC_REMOVE = Permissions.nodeOpCommand("emc.remove");
    public static final CommandPermissionNode EMC_SET = Permissions.nodeOpCommand("emc.set");
    public static final CommandPermissionNode EMC_TEST = Permissions.nodeOpCommand("emc.test");
    public static final CommandPermissionNode KNOWLEDGE = Permissions.nodeOpCommand("knowledge");
    public static final CommandPermissionNode KNOWLEDGE_CLEAR = Permissions.nodeOpCommand("knowledge.clear");
    public static final CommandPermissionNode KNOWLEDGE_LEARN = Permissions.nodeOpCommand("knowledge.learn");
    public static final CommandPermissionNode KNOWLEDGE_TEST = Permissions.nodeOpCommand("knowledge.test");
    public static final CommandPermissionNode KNOWLEDGE_UNLEARN = Permissions.nodeOpCommand("knowledge.unlearn");
    public static final CommandPermissionNode BOOK = Permissions.nodeOpCommand("book");
    public static final CommandPermissionNode BOOK_ADD = Permissions.nodeOpCommand("book.add");
    public static final CommandPermissionNode BOOK_ADD_HAND = Permissions.nodeOpCommand("book.add.hand");
    public static final CommandPermissionNode BOOK_ADD_PLAYER = Permissions.nodeOpCommand("book.add.player");
    public static final CommandPermissionNode BOOK_CLEAR = Permissions.nodeOpCommand("book.clear");
    public static final CommandPermissionNode BOOK_CLEAR_HAND = Permissions.nodeOpCommand("book.clear.hand");
    public static final CommandPermissionNode BOOK_CLEAR_PLAYER = Permissions.nodeOpCommand("book.clear.player");
    public static final CommandPermissionNode BOOK_DUMP = Permissions.nodeOpCommand("book.dump");
    public static final CommandPermissionNode BOOK_DUMP_HAND = Permissions.nodeOpCommand("book.dump.hand");
    public static final CommandPermissionNode BOOK_DUMP_PLAYER = Permissions.nodeOpCommand("book.dump.player");
    public static final CommandPermissionNode BOOK_LIST = Permissions.nodeOpCommand("book.list");
    public static final CommandPermissionNode BOOK_LIST_HAND = Permissions.nodeOpCommand("book.list.hand");
    public static final CommandPermissionNode BOOK_LIST_PLAYER = Permissions.nodeOpCommand("book.list.player");
    public static final CommandPermissionNode BOOK_REMOVE = Permissions.nodeOpCommand("book.remove");
    public static final CommandPermissionNode BOOK_REMOVE_HAND = Permissions.nodeOpCommand("book.remove.hand");
    public static final CommandPermissionNode BOOK_REMOVE_PLAYER = Permissions.nodeOpCommand("book.remove.player");

    private static CommandPermissionNode nodeOpCommand(String nodeName) {
        NODES.add(nodeName);
        return new CommandPermissionNode(nodeName, 2);
    }

    public static void registerPermissionNodes() {
        NODES.forEach(node -> PermissionAPI.registerNode((String)node, (DefaultPermissionLevel)DefaultPermissionLevel.NONE, (String)""));
    }

    public static final class CommandPermissionNode
    implements Predicate<CommandSource> {
        private final String node;
        private final int fallbackLevel;

        public CommandPermissionNode(String node, int fallbackLevel) {
            this.node = node;
            this.fallbackLevel = fallbackLevel;
        }

        @Override
        public boolean test(CommandSource source) {
            return source.field_197041_c instanceof ServerPlayerEntity ? PermissionAPI.hasPermission((PlayerEntity)((ServerPlayerEntity)source.field_197041_c), (String)this.node) : source.func_197034_c(this.fallbackLevel);
        }

        public String node() {
            return this.node;
        }

        public int fallbackLevel() {
            return this.fallbackLevel;
        }
    }
}

