/*
 * Decompiled with CFR 0.152.
 */
package cool.furry.mc.forge.projectexpansion.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import cool.furry.mc.forge.projectexpansion.commands.Permissions;
import cool.furry.mc.forge.projectexpansion.config.Config;
import cool.furry.mc.forge.projectexpansion.util.Lang;
import cool.furry.mc.forge.projectexpansion.util.Util;
import java.util.function.Predicate;
import moze_intel.projecte.api.ItemInfo;
import moze_intel.projecte.api.ProjectEAPI;
import moze_intel.projecte.api.capabilities.IKnowledgeProvider;
import moze_intel.projecte.api.proxy.IEMCProxy;
import moze_intel.projecte.emc.nbt.NBTManager;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.command.arguments.ItemArgument;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class CommandKnowledge {
    public static LiteralArgumentBuilder<CommandSource> getArguments() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"knowledge").requires((Predicate)Permissions.KNOWLEDGE)).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"clear").requires((Predicate)Permissions.KNOWLEDGE_CLEAR)).then(Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197096_c()).executes(ctx -> CommandKnowledge.handle((CommandContext<CommandSource>)ctx, ActionType.CLEAR))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"learn").requires((Predicate)Permissions.KNOWLEDGE_LEARN)).then(Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197096_c()).then(Commands.func_197056_a((String)"item", (ArgumentType)ItemArgument.func_197317_a()).executes(ctx -> CommandKnowledge.handle((CommandContext<CommandSource>)ctx, ActionType.LEARN)))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"unlearn").requires((Predicate)Permissions.KNOWLEDGE_UNLEARN)).then(Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197096_c()).then(Commands.func_197056_a((String)"item", (ArgumentType)ItemArgument.func_197317_a()).executes(ctx -> CommandKnowledge.handle((CommandContext<CommandSource>)ctx, ActionType.UNLEARN)))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"test").requires((Predicate)Permissions.KNOWLEDGE_TEST)).then(Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197096_c()).then(Commands.func_197056_a((String)"item", (ArgumentType)ItemArgument.func_197317_a()).executes(ctx -> CommandKnowledge.handle((CommandContext<CommandSource>)ctx, ActionType.TEST)))));
    }

    private static ITextComponent getSourceName(CommandSource source) {
        try {
            return source.func_197035_h().func_145748_c_();
        }
        catch (CommandSyntaxException e) {
            return Lang.Commands.CONSOLE.translateColored(TextFormatting.RED, new Object[0]);
        }
    }

    private static boolean compareUUID(CommandSource source, ServerPlayerEntity player) {
        try {
            return source.func_197035_h().func_110124_au().equals(player.func_110124_au());
        }
        catch (CommandSyntaxException e) {
            return false;
        }
    }

    private static int handle(CommandContext<CommandSource> ctx, ActionType action) throws CommandSyntaxException {
        ServerPlayerEntity player = EntityArgument.func_197089_d(ctx, (String)"player");
        boolean isSelf = CommandKnowledge.compareUUID((CommandSource)ctx.getSource(), player);
        if (action == ActionType.CLEAR) {
            IKnowledgeProvider provider = Util.getKnowledgeProvider((PlayerEntity)player);
            if (provider == null) {
                ((CommandSource)ctx.getSource()).func_197021_a((ITextComponent)Lang.FAILED_TO_GET_KNOWLEDGE_PROVIDER.translateColored(TextFormatting.RED, new Object[]{player.func_145748_c_()}));
                return 0;
            }
            if (provider.getKnowledge().isEmpty()) {
                if (isSelf) {
                    ((CommandSource)ctx.getSource()).func_197021_a((ITextComponent)Lang.Commands.KNOWLEDGE_CLEAR_FAIL_SELF.translateColored(TextFormatting.RED, new Object[0]));
                } else {
                    ((CommandSource)ctx.getSource()).func_197021_a((ITextComponent)Lang.Commands.KNOWLEDGE_CLEAR_FAIL.translateColored(TextFormatting.RED, new Object[]{player.func_145748_c_()}));
                }
                return 0;
            }
            provider.clearKnowledge();
            provider.sync(player);
            if (CommandKnowledge.compareUUID((CommandSource)ctx.getSource(), player)) {
                ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)Lang.Commands.KNOWLEDGE_CLEAR_SUCCESS_SELF.translateColored(TextFormatting.GREEN, new Object[0]), false);
            } else {
                ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)Lang.Commands.KNOWLEDGE_CLEAR_SUCCESS.translateColored(TextFormatting.GREEN, new Object[]{player.func_145748_c_()}), true);
                if (((Boolean)Config.notifyCommandChanges.get()).booleanValue()) {
                    Util.sendSystemMessage((PlayerEntity)player, (ITextComponent)Lang.Commands.KNOWLEDGE_CLEAR_NOTIFICATION.translate(new Object[]{CommandKnowledge.getSourceName((CommandSource)ctx.getSource())}));
                }
            }
            return 1;
        }
        Item item = ItemArgument.func_197316_a(ctx, (String)"item").func_197319_a();
        IKnowledgeProvider provider = Util.getKnowledgeProvider((PlayerEntity)player);
        if (provider == null) {
            ((CommandSource)ctx.getSource()).func_197021_a((ITextComponent)Lang.FAILED_TO_GET_KNOWLEDGE_PROVIDER.translateColored(TextFormatting.RED, new Object[]{player.func_145748_c_()}));
            return 0;
        }
        IEMCProxy proxy = ProjectEAPI.getEMCProxy();
        if (!proxy.hasValue(item)) {
            ((CommandSource)ctx.getSource()).func_197021_a((ITextComponent)Lang.Commands.KNOWLEDGE_INVALID.translate(new Object[0]));
            return 0;
        }
        int response = 1;
        switch (action) {
            case LEARN: {
                if (!provider.addKnowledge(ItemInfo.fromItem((Item)item))) {
                    response = 0;
                    if (isSelf) {
                        ((CommandSource)ctx.getSource()).func_197021_a((ITextComponent)Lang.Commands.KNOWLEDGE_LEARN_FAIL_SELF.translateColored(TextFormatting.RED, new Object[]{new ItemStack((IItemProvider)item).func_151000_E()}));
                        break;
                    }
                    ((CommandSource)ctx.getSource()).func_197021_a((ITextComponent)Lang.Commands.KNOWLEDGE_LEARN_FAIL.translateColored(TextFormatting.RED, new Object[]{player.func_145748_c_(), new ItemStack((IItemProvider)item).func_151000_E()}));
                    break;
                }
                if (isSelf) {
                    ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)Lang.Commands.KNOWLEDGE_LEARN_SUCCESS_SELF.translateColored(TextFormatting.GREEN, new Object[]{new ItemStack((IItemProvider)item).func_151000_E()}), false);
                    break;
                }
                ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)Lang.Commands.KNOWLEDGE_LEARN_SUCCESS.translateColored(TextFormatting.GRAY, new Object[]{player.func_145748_c_(), new ItemStack((IItemProvider)item).func_151000_E()}), true);
                if (!((Boolean)Config.notifyCommandChanges.get()).booleanValue()) break;
                Util.sendSystemMessage((PlayerEntity)player, (ITextComponent)Lang.Commands.KNOWLEDGE_LEARN_NOTIFICATION.translateColored(TextFormatting.GRAY, new Object[]{new ItemStack((IItemProvider)item).func_151000_E(), CommandKnowledge.getSourceName((CommandSource)ctx.getSource())}));
                break;
            }
            case UNLEARN: {
                if (!provider.removeKnowledge(ItemInfo.fromItem((Item)item))) {
                    response = 0;
                    if (isSelf) {
                        ((CommandSource)ctx.getSource()).func_197021_a((ITextComponent)Lang.Commands.KNOWLEDGE_UNLEARN_FAIL_SELF.translateColored(TextFormatting.RED, new Object[]{new ItemStack((IItemProvider)item).func_151000_E()}));
                        break;
                    }
                    ((CommandSource)ctx.getSource()).func_197021_a((ITextComponent)Lang.Commands.KNOWLEDGE_UNLEARN_FAIL.translateColored(TextFormatting.RED, new Object[]{player.func_145748_c_(), new ItemStack((IItemProvider)item).func_151000_E()}));
                    break;
                }
                if (isSelf) {
                    ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)Lang.Commands.KNOWLEDGE_UNLEARN_SUCCESS_SELF.translateColored(TextFormatting.GREEN, new Object[]{new ItemStack((IItemProvider)item).func_151000_E()}), false);
                    break;
                }
                ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)Lang.Commands.KNOWLEDGE_UNLEARN_SUCCESS.translateColored(TextFormatting.GREEN, new Object[]{player.func_145748_c_(), new ItemStack((IItemProvider)item).func_151000_E()}), true);
                if (!((Boolean)Config.notifyCommandChanges.get()).booleanValue()) break;
                Util.sendSystemMessage((PlayerEntity)player, (ITextComponent)Lang.Commands.KNOWLEDGE_UNLEARN_NOTIFICATION.translateColored(TextFormatting.GRAY, new Object[]{new ItemStack((IItemProvider)item).func_151000_E(), CommandKnowledge.getSourceName((CommandSource)ctx.getSource())}));
                break;
            }
            case TEST: {
                if (!provider.hasKnowledge(ItemInfo.fromItem((Item)item))) {
                    response = 0;
                    if (isSelf) {
                        ((CommandSource)ctx.getSource()).func_197021_a((ITextComponent)Lang.Commands.KNOWLEDGE_TEST_FAIL_SELF.translateColored(TextFormatting.RED, new Object[]{new ItemStack((IItemProvider)item).func_151000_E()}));
                        break;
                    }
                    ((CommandSource)ctx.getSource()).func_197021_a((ITextComponent)Lang.Commands.KNOWLEDGE_TEST_FAIL.translateColored(TextFormatting.RED, new Object[]{player.func_145748_c_(), new ItemStack((IItemProvider)item).func_151000_E()}));
                    break;
                }
                if (isSelf) {
                    ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)Lang.Commands.KNOWLEDGE_TEST_SUCCESS_SELF.translateColored(TextFormatting.GREEN, new Object[]{new ItemStack((IItemProvider)item).func_151000_E()}), false);
                    break;
                }
                ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)Lang.Commands.KNOWLEDGE_TEST_SUCCESS.translateColored(TextFormatting.GREEN, new Object[]{player.func_145748_c_(), new ItemStack((IItemProvider)item).func_151000_E()}), false);
            }
        }
        if (response == 1 && action != ActionType.TEST) {
            provider.syncKnowledgeChange(player, NBTManager.getPersistentInfo((ItemInfo)ItemInfo.fromItem((Item)item)), true);
        }
        return response;
    }

    private static enum ActionType {
        LEARN,
        UNLEARN,
        CLEAR,
        TEST;

    }
}

