/*
 * Decompiled with CFR 0.152.
 */
package cool.furry.mc.forge.projectexpansion.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import cool.furry.mc.forge.projectexpansion.commands.Permissions;
import cool.furry.mc.forge.projectexpansion.config.Config;
import cool.furry.mc.forge.projectexpansion.util.ColorStyle;
import cool.furry.mc.forge.projectexpansion.util.EMCFormat;
import cool.furry.mc.forge.projectexpansion.util.Lang;
import cool.furry.mc.forge.projectexpansion.util.Util;
import java.math.BigInteger;
import java.util.function.Predicate;
import moze_intel.projecte.api.capabilities.IKnowledgeProvider;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.HoverEvent;

public class CommandEMC {
    public static LiteralArgumentBuilder<CommandSource> getArguments() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"emc").requires((Predicate)Permissions.EMC)).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"add").requires((Predicate)Permissions.EMC_ADD)).then(Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197096_c()).then(Commands.func_197056_a((String)"value", (ArgumentType)StringArgumentType.string()).executes(ctx -> CommandEMC.handle((CommandContext<CommandSource>)ctx, ActionType.ADD)))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"remove").requires((Predicate)Permissions.EMC_REMOVE)).then(Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197096_c()).then(Commands.func_197056_a((String)"value", (ArgumentType)StringArgumentType.string()).executes(ctx -> CommandEMC.handle((CommandContext<CommandSource>)ctx, ActionType.REMOVE)))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"set").requires((Predicate)Permissions.EMC_SET)).then(Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197096_c()).then(Commands.func_197056_a((String)"value", (ArgumentType)StringArgumentType.string()).executes(ctx -> CommandEMC.handle((CommandContext<CommandSource>)ctx, ActionType.SET)))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"test").requires((Predicate)Permissions.EMC_TEST)).then(Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197096_c()).then(Commands.func_197056_a((String)"value", (ArgumentType)StringArgumentType.string()).executes(ctx -> CommandEMC.handle((CommandContext<CommandSource>)ctx, ActionType.TEST)))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"get").requires((Predicate)Permissions.EMC_GET)).then(Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197096_c()).executes(ctx -> CommandEMC.handle((CommandContext<CommandSource>)ctx, ActionType.GET))));
    }

    private static ITextComponent getSourceName(CommandSource source) {
        try {
            return source.func_197035_h().func_145748_c_();
        }
        catch (CommandSyntaxException e) {
            return Lang.Commands.CONSOLE.translateColored(TextFormatting.RED, new Object[0]);
        }
    }

    private static ITextComponent formatEMC(BigInteger value) {
        return new StringTextComponent(EMCFormat.formatForceShort(value)).func_230530_a_(Style.field_240709_b_.func_240716_a_(new HoverEvent(HoverEvent.Action.field_230550_a_, (Object)new StringTextComponent(EMCFormat.formatForceLong(value))))).func_230530_a_(ColorStyle.GRAY);
    }

    private static boolean compareUUID(CommandSource source, ServerPlayerEntity player) {
        try {
            return source.func_197035_h().func_110124_au().equals(player.func_110124_au());
        }
        catch (CommandSyntaxException e) {
            return false;
        }
    }

    private static int handle(CommandContext<CommandSource> ctx, ActionType action) throws CommandSyntaxException {
        ServerPlayerEntity player = EntityArgument.func_197089_d(ctx, (String)"player");
        if (action == ActionType.GET) {
            IKnowledgeProvider provider = Util.getKnowledgeProvider((PlayerEntity)player);
            if (provider == null) {
                ((CommandSource)ctx.getSource()).func_197021_a((ITextComponent)Lang.FAILED_TO_GET_KNOWLEDGE_PROVIDER.translateColored(TextFormatting.RED, new Object[]{player.func_145748_c_()}));
                return 0;
            }
            if (CommandEMC.compareUUID((CommandSource)ctx.getSource(), player)) {
                ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)Lang.Commands.EMC_GET_SUCCESS_SELF.translate(new Object[]{CommandEMC.formatEMC(provider.getEmc())}), false);
            } else {
                ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)Lang.Commands.EMC_GET_SUCCESS.translate(new Object[]{CommandEMC.formatEMC(provider.getEmc())}), true);
            }
            return 1;
        }
        String val = StringArgumentType.getString(ctx, (String)"value");
        BigInteger value = null;
        try {
            value = new BigInteger(val);
            switch (action) {
                case ADD: {
                    if (value.compareTo(BigInteger.ZERO) >= 0) break;
                    action = ActionType.REMOVE;
                    value = value.abs();
                    break;
                }
                case REMOVE: {
                    if (value.compareTo(BigInteger.ZERO) >= 0) break;
                    action = ActionType.ADD;
                    value = value.abs();
                    break;
                }
                case SET: 
                case TEST: {
                    if (value.compareTo(BigInteger.ZERO) >= 0) break;
                    value = null;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (value == null) {
            ((CommandSource)ctx.getSource()).func_197021_a((ITextComponent)Lang.Commands.EMC_INVALID.translateColored(TextFormatting.RED, new Object[0]));
            return 0;
        }
        int response = 1;
        IKnowledgeProvider provider = Util.getKnowledgeProvider((PlayerEntity)player);
        if (provider == null) {
            ((CommandSource)ctx.getSource()).func_197021_a((ITextComponent)Lang.FAILED_TO_GET_KNOWLEDGE_PROVIDER.translateColored(TextFormatting.RED, new Object[]{player.func_145748_c_()}));
            return 0;
        }
        BigInteger newEMC = provider.getEmc();
        switch (action) {
            case ADD: {
                newEMC = newEMC.add(value);
                if (CommandEMC.compareUUID((CommandSource)ctx.getSource(), player)) {
                    ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)Lang.Commands.EMC_ADD_SUCCESS_SELF.translateColored(TextFormatting.GREEN, new Object[]{CommandEMC.formatEMC(value), CommandEMC.formatEMC(newEMC)}), false);
                    break;
                }
                ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)Lang.Commands.EMC_ADD_SUCCESS.translateColored(TextFormatting.GREEN, new Object[]{CommandEMC.formatEMC(value), player.func_145748_c_(), CommandEMC.formatEMC(newEMC)}), true);
                if (!((Boolean)Config.notifyCommandChanges.get()).booleanValue()) break;
                Util.sendSystemMessage((PlayerEntity)player, (ITextComponent)Lang.Commands.EMC_ADD_NOTIFICATION.translate(new Object[]{CommandEMC.formatEMC(value), CommandEMC.getSourceName((CommandSource)ctx.getSource()), CommandEMC.formatEMC(newEMC)}));
                break;
            }
            case REMOVE: {
                newEMC = newEMC.subtract(value);
                if (newEMC.compareTo(BigInteger.ZERO) < 0) {
                    ((CommandSource)ctx.getSource()).func_197021_a((ITextComponent)Lang.Commands.EMC_REMOVE_NEGATIVE.translateColored(TextFormatting.RED, new Object[]{CommandEMC.formatEMC(value), player.func_195047_I_()}));
                    return 0;
                }
                if (CommandEMC.compareUUID((CommandSource)ctx.getSource(), player)) {
                    ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)Lang.Commands.EMC_REMOVE_SUCCESS_SELF.translateColored(TextFormatting.GREEN, new Object[]{CommandEMC.formatEMC(value), CommandEMC.formatEMC(newEMC)}), false);
                    break;
                }
                ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)Lang.Commands.EMC_REMOVE_SUCCESS.translateColored(TextFormatting.GREEN, new Object[]{CommandEMC.formatEMC(value), player.func_195047_I_(), CommandEMC.formatEMC(newEMC)}), true);
                if (!((Boolean)Config.notifyCommandChanges.get()).booleanValue()) break;
                Util.sendSystemMessage((PlayerEntity)player, (ITextComponent)Lang.Commands.EMC_REMOVE_NOTIFICATION.translate(new Object[]{CommandEMC.formatEMC(value), CommandEMC.getSourceName((CommandSource)ctx.getSource()), CommandEMC.formatEMC(newEMC)}));
                break;
            }
            case SET: {
                newEMC = value;
                if (CommandEMC.compareUUID((CommandSource)ctx.getSource(), player)) {
                    ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)Lang.Commands.EMC_SET_SUCCESS_SELF.translateColored(TextFormatting.GREEN, new Object[]{CommandEMC.formatEMC(value), CommandEMC.formatEMC(newEMC)}), false);
                    break;
                }
                ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)Lang.Commands.EMC_SET_SUCCESS.translateColored(TextFormatting.GREEN, new Object[]{player.func_145748_c_(), CommandEMC.formatEMC(newEMC)}), true);
                if (!((Boolean)Config.notifyCommandChanges.get()).booleanValue()) break;
                Util.sendSystemMessage((PlayerEntity)player, (ITextComponent)Lang.Commands.EMC_REMOVE_SUCCESS.translate(new Object[]{CommandEMC.formatEMC(newEMC), CommandEMC.getSourceName((CommandSource)ctx.getSource())}));
                break;
            }
            case TEST: {
                boolean canTake;
                boolean bl = canTake = newEMC.compareTo(value) > -1;
                if (CommandEMC.compareUUID((CommandSource)ctx.getSource(), player)) {
                    if (canTake) {
                        ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)Lang.Commands.EMC_TEST_SUCCESS_SELF.translateColored(TextFormatting.GREEN, new Object[]{CommandEMC.formatEMC(value)}), false);
                        break;
                    }
                    response = 0;
                    ((CommandSource)ctx.getSource()).func_197021_a((ITextComponent)Lang.Commands.EMC_TEST_FAIL_SELF.translateColored(TextFormatting.RED, new Object[]{CommandEMC.formatEMC(value)}));
                    break;
                }
                if (canTake) {
                    ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)Lang.Commands.EMC_TEST_SUCCESS.translateColored(TextFormatting.GREEN, new Object[]{player.func_195047_I_(), CommandEMC.formatEMC(value)}), false);
                    break;
                }
                response = 0;
                ((CommandSource)ctx.getSource()).func_197021_a((ITextComponent)Lang.Commands.KNOWLEDGE_TEST_FAIL_SELF.translateColored(TextFormatting.RED, new Object[]{player.func_195047_I_(), CommandEMC.formatEMC(value)}));
                break;
            }
        }
        if (response == 1 && action != ActionType.TEST) {
            provider.setEmc(newEMC);
            provider.syncEmc(player);
        }
        return response;
    }

    private static enum ActionType {
        ADD,
        REMOVE,
        SET,
        GET,
        TEST;

    }
}

