/*
 * Decompiled with CFR 0.152.
 */
package cool.furry.mc.forge.projectexpansion.commands;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import cool.furry.mc.forge.projectexpansion.Main;
import cool.furry.mc.forge.projectexpansion.capability.CapabilityAlchemicalBookLocations;
import cool.furry.mc.forge.projectexpansion.capability.IAlchemicalBookLocationsProvider;
import cool.furry.mc.forge.projectexpansion.commands.CommandRegistry;
import cool.furry.mc.forge.projectexpansion.commands.Permissions;
import cool.furry.mc.forge.projectexpansion.config.Config;
import cool.furry.mc.forge.projectexpansion.item.ItemAlchemicalBook;
import cool.furry.mc.forge.projectexpansion.util.Lang;
import cool.furry.mc.forge.projectexpansion.util.NBTNames;
import cool.furry.mc.forge.projectexpansion.util.Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.BlockPosArgument;
import net.minecraft.command.arguments.DimensionArgument;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.GlobalPos;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class CommandBook {
    private static final SimpleCommandExceptionType ERROR_OUT_OF_BOUNDS = new SimpleCommandExceptionType((Message)Lang.POS_OUTOFBOUNDS.translate(new Object[0]));

    public static LiteralArgumentBuilder<CommandSource> getArguments() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"book").requires((Predicate)Permissions.BOOK)).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"add").requires((Predicate)Permissions.BOOK_ADD)).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"player").requires((Predicate)Permissions.BOOK_ADD_PLAYER)).then(Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197096_c()).then(Commands.func_197056_a((String)"pos", (ArgumentType)BlockPosArgument.func_197276_a()).then(Commands.func_197056_a((String)"dimension", (ArgumentType)DimensionArgument.func_212595_a()).then(Commands.func_197056_a((String)"name", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> CommandBook.handleAdd((CommandContext<CommandSource>)ctx, new BookTarget((CommandContext<CommandSource>)ctx))))))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"hand").requires((Predicate)Permissions.BOOK_ADD_HAND)).then(Commands.func_197056_a((String)"pos", (ArgumentType)BlockPosArgument.func_197276_a()).then(Commands.func_197056_a((String)"dimension", (ArgumentType)DimensionArgument.func_212595_a()).then(Commands.func_197056_a((String)"name", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> CommandBook.handleAdd((CommandContext<CommandSource>)ctx, new BookTarget((CommandContext<CommandSource>)ctx))))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"clear").requires((Predicate)Permissions.BOOK_CLEAR)).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"player").requires((Predicate)Permissions.BOOK_CLEAR_PLAYER)).then(Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197096_c()).executes(ctx -> CommandBook.handleClear((CommandContext<CommandSource>)ctx, new BookTarget((CommandContext<CommandSource>)ctx)))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"hand").requires((Predicate)Permissions.BOOK_CLEAR_HAND)).executes(ctx -> CommandBook.handleClear((CommandContext<CommandSource>)ctx, new BookTarget((CommandContext<CommandSource>)ctx)))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"dump").requires((Predicate)Permissions.BOOK_DUMP)).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"player").requires((Predicate)Permissions.BOOK_DUMP_PLAYER)).then(Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197096_c()).executes(ctx -> CommandBook.handleDump((CommandContext<CommandSource>)ctx, new BookTarget((CommandContext<CommandSource>)ctx)))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"hand").requires((Predicate)Permissions.BOOK_DUMP_HAND)).executes(ctx -> CommandBook.handleDump((CommandContext<CommandSource>)ctx, new BookTarget((CommandContext<CommandSource>)ctx)))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"list").requires((Predicate)Permissions.BOOK_LIST)).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"player").requires((Predicate)Permissions.BOOK_LIST_PLAYER)).then(Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197096_c()).executes(ctx -> CommandBook.handleList((CommandContext<CommandSource>)ctx, new BookTarget((CommandContext<CommandSource>)ctx)))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"hand").requires((Predicate)Permissions.BOOK_LIST_HAND)).executes(ctx -> CommandBook.handleList((CommandContext<CommandSource>)ctx, new BookTarget((CommandContext<CommandSource>)ctx)))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"remove").requires((Predicate)Permissions.BOOK_REMOVE)).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"player").requires((Predicate)Permissions.BOOK_REMOVE_PLAYER)).then(Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197096_c()).then(Commands.func_197056_a((String)"location", (ArgumentType)StringArgumentType.string()).executes(ctx -> CommandBook.handleRemove((CommandContext<CommandSource>)ctx, new BookTarget((CommandContext<CommandSource>)ctx))))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"hand").requires((Predicate)Permissions.BOOK_REMOVE_HAND)).then(Commands.func_197056_a((String)"location", (ArgumentType)StringArgumentType.string()).executes(ctx -> CommandBook.handleRemove((CommandContext<CommandSource>)ctx, new BookTarget((CommandContext<CommandSource>)ctx))))));
    }

    @Nullable
    private static IAlchemicalBookLocationsProvider getCapability(CommandContext<CommandSource> ctx, BookTarget target, String commandSource) throws CommandSyntaxException {
        IAlchemicalBookLocationsProvider provider;
        try {
            if (target.isPlayer()) {
                provider = CapabilityAlchemicalBookLocations.fromPlayer((PlayerEntity)target.playerOrException());
            } else {
                ItemStack stack = target.itemStackOrException();
                provider = CapabilityAlchemicalBookLocations.fromItemStack(stack);
                if (stack.func_77973_b() instanceof ItemAlchemicalBook && ((ItemAlchemicalBook)stack.func_77973_b()).getMode(stack) == ItemAlchemicalBook.Mode.PLAYER) {
                    ServerPlayerEntity player = ((ItemAlchemicalBook)stack.func_77973_b()).getPlayer(target.itemStackOrException());
                    IFormattableTextComponent playerDisplay = player == null ? new StringTextComponent(target.itemStackOrException().func_196082_o().func_74779_i(NBTNames.OWNER_NAME)).func_240699_a_(TextFormatting.DARK_AQUA) : player.func_145748_c_().func_230532_e_().func_240699_a_(TextFormatting.DARK_AQUA);
                    IFormattableTextComponent command = new StringTextComponent(String.format("/%s book %s player %s", CommandRegistry.COMMAND_BASE, commandSource, playerDisplay.getString())).func_240700_a_(arg_0 -> CommandBook.lambda$getCapability$10(commandSource, (ITextComponent)playerDisplay, arg_0));
                    Util.sendSystemMessage((CommandSource)ctx.getSource(), (ITextComponent)Lang.Commands.BOOK_BOUND_TO_PLAYER.extendColored(commandSource, TextFormatting.RED, playerDisplay, command));
                }
            }
        }
        catch (IllegalStateException e) {
            Util.sendSystemMessage((CommandSource)ctx.getSource(), (ITextComponent)Lang.Commands.BOOK_FAILED_TO_GET_CAPABILITY.translateColored(TextFormatting.RED, new Object[0]));
            Main.Logger.error("Failed to get capability:");
            Main.Logger.error((Object)e);
            return null;
        }
        return provider;
    }

    @Nullable
    private static ServerPlayerEntity getPlayer(CommandContext<CommandSource> ctx) {
        try {
            return ((CommandSource)ctx.getSource()).func_197035_h();
        }
        catch (CommandSyntaxException ignore) {
            return null;
        }
    }

    private static ITextComponent getSourceName(CommandSource source) {
        try {
            return source.func_197035_h().func_145748_c_();
        }
        catch (CommandSyntaxException e) {
            return Lang.Commands.CONSOLE.translateColored(TextFormatting.RED, new Object[0]);
        }
    }

    private static int handleDump(CommandContext<CommandSource> ctx, BookTarget target) throws CommandSyntaxException {
        IAlchemicalBookLocationsProvider provider = CommandBook.getCapability(ctx, target, "dump");
        if (provider == null) {
            return 0;
        }
        if (provider.getLocations().isEmpty()) {
            ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)Lang.Commands.BOOK_EMPTY.translateColored(TextFormatting.GREEN, new Object[0]), false);
            return 0;
        }
        String content = ((CompoundNBT)provider.serializeNBT()).toString();
        ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)new StringTextComponent(content).func_240700_a_(style -> style.func_240715_a_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, content)).func_240716_a_(new HoverEvent(HoverEvent.Action.field_230550_a_, (Object)Lang.Commands.BOOK_CLICK_TO_COPY.translateColored(TextFormatting.AQUA, new Object[0])))).func_240699_a_(TextFormatting.GRAY), false);
        return 1;
    }

    private static Style suggestTeleportPos(CommandContext<CommandSource> ctx, Style style, CapabilityAlchemicalBookLocations.TeleportLocation location) {
        boolean isSameDimension = Objects.requireNonNull(CommandBook.getPlayer(ctx)).field_70170_p.func_234923_W_().equals(location.dimension());
        if (isSameDimension) {
            return Util.suggestCommand(style, String.format("/tp %s %s %s", location.x(), location.y(), location.z())).func_244282_c(Boolean.valueOf(true));
        }
        return Util.suggestCommand(style, String.format("/execute in %s run tp %s %s %s", location.dimension().func_240901_a_(), location.x(), location.y(), location.z())).func_244282_c(Boolean.valueOf(true));
    }

    private static Style suggestTeleportDimension(CommandContext<CommandSource> ctx, Style style, CapabilityAlchemicalBookLocations.TeleportLocation location) {
        boolean isSameDimension = Objects.requireNonNull(CommandBook.getPlayer(ctx)).field_70170_p.func_234923_W_().equals(location.dimension());
        if (!isSameDimension) {
            return Util.suggestCommand(style, String.format("/execute in %s run tp ~ ~ ~", location.dimension().func_240901_a_())).func_244282_c(Boolean.valueOf(true));
        }
        return style;
    }

    private static ITextComponent formatLocation(CommandContext<CommandSource> ctx, CapabilityAlchemicalBookLocations.TeleportLocation location) {
        boolean shouldSuggestCommand = CommandBook.getPlayer(ctx) != null;
        IFormattableTextComponent pos = new StringTextComponent(String.format("%s %s %s", location.x(), location.y(), location.z())).func_240700_a_(style -> shouldSuggestCommand ? CommandBook.suggestTeleportPos(ctx, style, location) : style).func_240699_a_(TextFormatting.DARK_AQUA);
        IFormattableTextComponent dimension = new StringTextComponent(location.dimension().func_240901_a_().toString()).func_240700_a_(style -> shouldSuggestCommand ? CommandBook.suggestTeleportDimension(ctx, style, location) : style).func_240699_a_(TextFormatting.DARK_AQUA);
        return Lang.Commands.BOOK_LIST_LOCATION.translateColored(TextFormatting.AQUA, new Object[]{new StringTextComponent(location.name()).func_240699_a_(TextFormatting.DARK_AQUA), pos, dimension});
    }

    private static int handleList(CommandContext<CommandSource> ctx, BookTarget target) throws CommandSyntaxException {
        IAlchemicalBookLocationsProvider provider = CommandBook.getCapability(ctx, target, "list");
        if (provider == null) {
            return 0;
        }
        if (provider.getLocations().isEmpty()) {
            ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)Lang.Commands.BOOK_EMPTY.translateColored(TextFormatting.GREEN, new Object[0]), false);
            return 0;
        }
        for (CapabilityAlchemicalBookLocations.TeleportLocation location : provider.getLocations()) {
            Util.sendSystemMessage((CommandSource)ctx.getSource(), CommandBook.formatLocation(ctx, location));
        }
        return 1;
    }

    private static int handleClear(CommandContext<CommandSource> ctx, BookTarget target) throws CommandSyntaxException {
        IAlchemicalBookLocationsProvider provider = CommandBook.getCapability(ctx, target, "clear");
        if (provider == null) {
            return 0;
        }
        ArrayList<CapabilityAlchemicalBookLocations.TeleportLocation> locations = new ArrayList<CapabilityAlchemicalBookLocations.TeleportLocation>((Collection<CapabilityAlchemicalBookLocations.TeleportLocation>)provider.getLocations());
        if (locations.isEmpty()) {
            ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)Lang.Commands.BOOK_EMPTY.translateColored(TextFormatting.RED, new Object[0]), false);
            return 0;
        }
        provider.resetLocations();
        if (provider.getMode() == ItemAlchemicalBook.Mode.PLAYER) {
            provider.syncToOtherPlayers();
            ServerPlayerEntity sourcePlayer = CommandBook.getPlayer(ctx);
            ServerPlayerEntity targetPlayer = target.playerOrException();
            if (sourcePlayer != null && sourcePlayer.func_110124_au().equals(targetPlayer.func_110124_au())) {
                Util.sendSystemMessage((CommandSource)ctx.getSource(), (ITextComponent)Lang.Commands.BOOK_CLEAR_PLAYER_SUCCESS_SELF.translateColored(TextFormatting.GREEN, new Object[0]));
                return 1;
            }
            if (((Boolean)Config.notifyCommandChanges.get()).booleanValue()) {
                Util.sendSystemMessage((PlayerEntity)target.playerOrException(), (ITextComponent)Lang.Commands.BOOK_CLEAR_PLAYER_NOTIFICATION.translate(new Object[]{CommandBook.getSourceName((CommandSource)ctx.getSource())}));
            }
            Util.sendSystemMessage((CommandSource)ctx.getSource(), (ITextComponent)Lang.Commands.BOOK_CLEAR_PLAYER_SUCCESS.translateColored(TextFormatting.GREEN, new Object[]{targetPlayer.func_145748_c_().func_230532_e_().func_240699_a_(TextFormatting.DARK_AQUA)}));
            return 1;
        }
        Util.sendSystemMessage((CommandSource)ctx.getSource(), (ITextComponent)Lang.Commands.BOOK_CLEAR_ITEMSTACK_SUCCESS.translateColored(TextFormatting.GREEN, new Object[0]));
        return 1;
    }

    private static int handleRemove(CommandContext<CommandSource> ctx, BookTarget target) throws CommandSyntaxException {
        CapabilityAlchemicalBookLocations.TeleportLocation location;
        IAlchemicalBookLocationsProvider provider = CommandBook.getCapability(ctx, target, "remove");
        if (provider == null) {
            return 0;
        }
        String name = StringArgumentType.getString(ctx, (String)"location");
        try {
            location = provider.getLocationOrThrow(name);
            if (location.isBack()) {
                ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)Lang.Commands.BOOK_REMOVE_INTERNAL_LOCATION.translateColored(TextFormatting.RED, new Object[0]), false);
                return 0;
            }
            provider.removeLocation(name);
        }
        catch (CapabilityAlchemicalBookLocations.BookError.NameNotFoundError ignore) {
            ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)Lang.Commands.BOOK_REMOVE_INVALID_LOCATION.translateColored(TextFormatting.RED, new Object[0]), false);
            return 0;
        }
        String locationDump = location.serialize().toString();
        ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)Lang.Commands.BOOK_REMOVE_BACKUP.translateColored(TextFormatting.AQUA, new Object[]{new StringTextComponent(locationDump).func_240700_a_(style -> style.func_240715_a_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, locationDump)).func_240716_a_(new HoverEvent(HoverEvent.Action.field_230550_a_, (Object)Lang.Commands.BOOK_REMOVE_BACKUP_INFO.translateColored(TextFormatting.AQUA, new Object[0])))).func_240699_a_(TextFormatting.GRAY)}), false);
        if (provider.getMode() == ItemAlchemicalBook.Mode.PLAYER) {
            provider.syncToOtherPlayers();
            ServerPlayerEntity sourcePlayer = CommandBook.getPlayer(ctx);
            ServerPlayerEntity targetPlayer = target.playerOrException();
            if (sourcePlayer != null && sourcePlayer.func_110124_au().equals(targetPlayer.func_110124_au())) {
                Util.sendSystemMessage((CommandSource)ctx.getSource(), (ITextComponent)Lang.Commands.BOOK_REMOVE_PLAYER_SUCCESS_SELF.translateColored(TextFormatting.GREEN, new Object[0]));
                return 1;
            }
            if (((Boolean)Config.notifyCommandChanges.get()).booleanValue()) {
                Util.sendSystemMessage((CommandSource)ctx.getSource(), (ITextComponent)Lang.Commands.BOOK_REMOVE_PLAYER_NOTIFICATION.translate(new Object[]{name, CommandBook.getSourceName((CommandSource)ctx.getSource())}), false);
            }
            Util.sendSystemMessage((CommandSource)ctx.getSource(), (ITextComponent)Lang.Commands.BOOK_REMOVE_PLAYER_SUCCESS.translateColored(TextFormatting.GREEN, new Object[]{targetPlayer.func_145748_c_().func_230532_e_().func_240699_a_(TextFormatting.DARK_AQUA)}));
            return 1;
        }
        Util.sendSystemMessage((CommandSource)ctx.getSource(), (ITextComponent)Lang.Commands.BOOK_REMOVE_ITEMSTACK_SUCCESS.translateColored(TextFormatting.GREEN, new Object[0]));
        return 1;
    }

    private static BlockPos getSpawnablePos(CommandContext<CommandSource> ctx, String name) throws CommandSyntaxException {
        BlockPos pos = BlockPosArgument.func_197273_a(ctx, (String)name);
        if (!World.func_234935_k_((BlockPos)pos)) {
            throw ERROR_OUT_OF_BOUNDS.create();
        }
        return pos;
    }

    private static int handleAdd(CommandContext<CommandSource> ctx, BookTarget target) throws CommandSyntaxException {
        IAlchemicalBookLocationsProvider provider = CommandBook.getCapability(ctx, target, "remove");
        if (provider == null) {
            return 0;
        }
        BlockPos pos = CommandBook.getSpawnablePos(ctx, "pos");
        ServerWorld dimension = DimensionArgument.func_212592_a(ctx, (String)"dimension");
        String name = StringArgumentType.getString(ctx, (String)"name");
        if (CapabilityAlchemicalBookLocations.isForbiddenName(name)) {
            ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)Lang.Commands.BOOK_ADD_INVALID_NAME.translateColored(TextFormatting.RED, new Object[0]), false);
            return 0;
        }
        try {
            provider.addLocation(name, GlobalPos.func_239648_a_((RegistryKey)dimension.func_234923_W_(), (BlockPos)pos));
        }
        catch (CapabilityAlchemicalBookLocations.BookError.DuplicateNameError e) {
            ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)Lang.Commands.BOOK_ADD_DUPLICATE_NAME.translateColored(TextFormatting.RED, new Object[0]), false);
            return 0;
        }
        if (provider.getMode() == ItemAlchemicalBook.Mode.PLAYER) {
            provider.syncToOtherPlayers();
            ServerPlayerEntity sourcePlayer = CommandBook.getPlayer(ctx);
            ServerPlayerEntity targetPlayer = target.playerOrException();
            if (sourcePlayer != null && sourcePlayer.func_110124_au().equals(targetPlayer.func_110124_au())) {
                Util.sendSystemMessage((CommandSource)ctx.getSource(), (ITextComponent)Lang.Commands.BOOK_ADD_PLAYER_SUCCESS_SELF.translateColored(TextFormatting.GREEN, new Object[0]));
                return 1;
            }
            if (((Boolean)Config.notifyCommandChanges.get()).booleanValue()) {
                Util.sendSystemMessage((CommandSource)ctx.getSource(), (ITextComponent)Lang.Commands.BOOK_ADD_PLAYER_NOTIFICATION.translate(new Object[]{name, CommandBook.getSourceName((CommandSource)ctx.getSource())}), false);
            }
            Util.sendSystemMessage((CommandSource)ctx.getSource(), (ITextComponent)Lang.Commands.BOOK_ADD_PLAYER_SUCCESS.translateColored(TextFormatting.GREEN, new Object[]{targetPlayer.func_145748_c_().func_230532_e_().func_240699_a_(TextFormatting.DARK_AQUA)}));
            return 1;
        }
        Util.sendSystemMessage((CommandSource)ctx.getSource(), (ITextComponent)Lang.Commands.BOOK_ADD_ITEMSTACK_SUCCESS.translateColored(TextFormatting.GREEN, new Object[0]));
        return 1;
    }

    private static /* synthetic */ Style lambda$getCapability$10(String commandSource, ITextComponent playerDisplay, Style style) {
        return style.func_240715_a_(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, String.format("/%s book %s player %s", CommandRegistry.COMMAND_BASE, commandSource, playerDisplay.getString()))).func_240712_a_(TextFormatting.RED);
    }

    public static class BookTarget {
        private final CommandContext<CommandSource> ctx;
        @Nullable
        private final ServerPlayerEntity player;

        public BookTarget(CommandContext<CommandSource> ctx) {
            ServerPlayerEntity playerArg;
            try {
                playerArg = EntityArgument.func_197089_d(ctx, (String)"player");
            }
            catch (CommandSyntaxException | IllegalArgumentException e) {
                playerArg = null;
            }
            this.ctx = ctx;
            this.player = playerArg;
        }

        public boolean isItemStack() {
            return this.player == null;
        }

        public boolean isPlayer() {
            return this.player != null;
        }

        @Nullable
        public ServerPlayerEntity player() {
            return this.player;
        }

        public ServerPlayerEntity playerOrException() {
            if (this.player == null) {
                throw new NullPointerException("Player is null");
            }
            return this.player;
        }

        @Nullable
        public ItemStack itemStack() {
            ServerPlayerEntity executor;
            try {
                executor = ((CommandSource)this.ctx.getSource()).func_197035_h();
            }
            catch (CommandSyntaxException e) {
                return null;
            }
            ItemStack stack = executor.func_184614_ca();
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemAlchemicalBook)) {
                return null;
            }
            return stack;
        }

        public ItemStack itemStackOrException() throws CommandSyntaxException {
            ServerPlayerEntity executor;
            try {
                executor = ((CommandSource)this.ctx.getSource()).func_197035_h();
            }
            catch (CommandSyntaxException e) {
                throw new SimpleCommandExceptionType((Message)Lang.Commands.PLAYER_ONLY.translate(new Object[0])).create();
            }
            ItemStack stack = executor.func_184614_ca();
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemAlchemicalBook)) {
                throw new SimpleCommandExceptionType((Message)Lang.Commands.BOOK_INVALID_HAND_ITEM.translate(new Object[0])).create();
            }
            return stack;
        }
    }
}

