/*
 * Decompiled with CFR 0.152.
 */
package cool.furry.mc.forge.projectexpansion.capability;

import com.google.common.collect.ImmutableList;
import cool.furry.mc.forge.projectexpansion.Main;
import cool.furry.mc.forge.projectexpansion.capability.IAlchemicalBookLocationsProvider;
import cool.furry.mc.forge.projectexpansion.item.ItemAlchemicalBook;
import cool.furry.mc.forge.projectexpansion.net.PacketHandler;
import cool.furry.mc.forge.projectexpansion.net.packets.to_client.PacketSyncAlchemicalBookLocations;
import cool.furry.mc.forge.projectexpansion.registries.Capabilities;
import cool.furry.mc.forge.projectexpansion.util.Lang;
import cool.furry.mc.forge.projectexpansion.util.NBTNames;
import cool.furry.mc.forge.projectexpansion.util.Util;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import moze_intel.projecte.capability.managing.ICapabilityResolver;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.GlobalPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class CapabilityAlchemicalBookLocations
implements IAlchemicalBookLocationsProvider {
    public static final int BASIC_DISTANCE_RATIO = 1000;
    public static final int ADVANCED_DISTANCE_RATIO = 500;
    public static final int MASTER_DISTANCE_RATIO = 100;
    public static final int ARCANE_DISTANCE_RATIO = 0;
    private final ItemAlchemicalBook.Mode mode;
    @Nullable
    private final ServerPlayerEntity player;
    @Nullable
    private final ItemStack itemStack;
    private final HashMap<String, TeleportLocation> locations = new HashMap();
    private static final String BACK_KEY = "@back";

    public static void init() {
        CapabilityManager.INSTANCE.register(IAlchemicalBookLocationsProvider.class, (Capability.IStorage)new Capability.IStorage<IAlchemicalBookLocationsProvider>(){

            public INBT writeNBT(Capability<IAlchemicalBookLocationsProvider> capability, IAlchemicalBookLocationsProvider instance, Direction side) {
                return instance.serializeNBT();
            }

            public void readNBT(Capability<IAlchemicalBookLocationsProvider> capability, IAlchemicalBookLocationsProvider instance, Direction side, INBT nbt) {
                if (nbt instanceof CompoundNBT) {
                    instance.deserializeNBT((INBT)((CompoundNBT)nbt));
                }
            }
        }, () -> CapabilityAlchemicalBookLocations.getDefault(ItemAlchemicalBook.Mode.PLAYER, null, null));
    }

    private CapabilityAlchemicalBookLocations(ItemAlchemicalBook.Mode mode, @Nullable ServerPlayerEntity player, @Nullable ItemStack itemStack) {
        this.mode = mode;
        this.player = player;
        this.itemStack = itemStack;
    }

    public static IAlchemicalBookLocationsProvider fromPlayer(PlayerEntity player) {
        return (IAlchemicalBookLocationsProvider)player.getCapability(Capabilities.ALCHEMICAL_BOOK_LOCATIONS).orElseThrow(() -> new IllegalStateException("Player does not have expected capability"));
    }

    public static IAlchemicalBookLocationsProvider fromItemStack(ItemStack stack) {
        return (IAlchemicalBookLocationsProvider)stack.getCapability(Capabilities.ALCHEMICAL_BOOK_LOCATIONS).orElseThrow(() -> new IllegalStateException("ItemStack does not have expected capability"));
    }

    public static IAlchemicalBookLocationsProvider from(ItemStack stack) throws BookError.OwnerOfflineError {
        if (!(stack.func_77973_b() instanceof ItemAlchemicalBook)) {
            throw new IllegalArgumentException("ItemStack is not an alchemical book");
        }
        ItemAlchemicalBook book = (ItemAlchemicalBook)stack.func_77973_b();
        if (book.getMode(stack) == ItemAlchemicalBook.Mode.PLAYER) {
            ServerPlayerEntity owner = book.getPlayer(stack);
            if (owner == null) {
                throw new BookError.OwnerOfflineError(stack.func_196082_o().func_74779_i(NBTNames.OWNER_NAME));
            }
            return CapabilityAlchemicalBookLocations.fromPlayer((PlayerEntity)owner);
        }
        return CapabilityAlchemicalBookLocations.fromItemStack(stack);
    }

    public static boolean isForbiddenName(String name) {
        return name.equalsIgnoreCase(BACK_KEY);
    }

    public static IAlchemicalBookLocationsProvider getDefault(ItemAlchemicalBook.Mode mode, @Nullable ServerPlayerEntity player, @Nullable ItemStack itemStack) {
        return new CapabilityAlchemicalBookLocations(mode, player, itemStack);
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        this.locations.forEach((name, location) -> nbt.func_218657_a(name, (INBT)location.serialize()));
        return nbt;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.locations.clear();
        nbt.func_150296_c().forEach(name -> this.locations.put((String)name, TeleportLocation.deserialize(nbt.func_74775_l(name))));
    }

    @Override
    public ImmutableList<TeleportLocation> getLocations() {
        return (ImmutableList)this.locations.values().stream().sorted(Comparator.comparingInt(TeleportLocation::index)).collect(ImmutableList.toImmutableList());
    }

    @Override
    public void addLocation(String name, GlobalPos pos) throws BookError.DuplicateNameError {
        if (this.locations.containsKey(name) && !name.equals(BACK_KEY)) {
            throw new BookError.DuplicateNameError(name);
        }
        int index = this.locations.size();
        if (name.equals(BACK_KEY)) {
            index = -1;
        } else if (this.locations.containsKey(BACK_KEY)) {
            --index;
        }
        TeleportLocation location = TeleportLocation.from(name, pos, index);
        this.locations.put(name, location);
    }

    @Override
    public void addLocation(PlayerEntity player, String name) throws BookError.DuplicateNameError {
        this.addLocation(name, GlobalPos.func_239648_a_((RegistryKey)player.field_70170_p.func_234923_W_(), (BlockPos)player.func_233580_cy_()));
    }

    @Override
    public void removeLocation(String name) throws BookError.NameNotFoundError {
        if (!this.locations.containsKey(name)) {
            throw new BookError.NameNotFoundError(name);
        }
        int index = this.locations.get(name).index();
        this.locations.remove(name);
        if (index < 0 || name.equals(BACK_KEY)) {
            return;
        }
        this.locations.forEach((loc, location) -> {
            if (location.index() < index) {
                return;
            }
            this.locations.replace((String)loc, location.withIndex(location.index() - 1));
        });
    }

    @Override
    public void saveBackLocation(PlayerEntity player, GlobalPos pos) {
        try {
            if (this.locations.containsKey(BACK_KEY)) {
                this.removeLocation(BACK_KEY);
            }
            this.addLocation(BACK_KEY, pos);
            this.sync((ServerPlayerEntity)player);
        }
        catch (BookError.DuplicateNameError | BookError.NameNotFoundError e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void saveBackLocation(PlayerEntity player) {
        this.saveBackLocation(player, GlobalPos.func_239648_a_((RegistryKey)player.field_70170_p.func_234923_W_(), (BlockPos)player.func_233580_cy_()));
    }

    @Override
    @Nullable
    public TeleportLocation getBackLocation() {
        if (!this.locations.containsKey(BACK_KEY)) {
            return null;
        }
        return this.locations.get(BACK_KEY);
    }

    @Override
    public TeleportLocation getBackLocationOrThrow() throws BookError.NoBackLocationError {
        TeleportLocation location = this.getBackLocation();
        if (location == null) {
            throw new BookError.NoBackLocationError();
        }
        return location;
    }

    @Override
    public void teleportBack(ServerPlayerEntity player, boolean acrossDimensions) throws BookError.NoBackLocationError, BookError.WrongDimensionError, BookError.DimensionNotFoundError {
        TeleportLocation backLocation = this.getBackLocation();
        if (backLocation == null) {
            throw new BookError.NoBackLocationError();
        }
        RegistryKey dim = player.func_71121_q().func_234923_W_();
        ServerWorld level = Util.getDimension(backLocation.dimension());
        if (level == null) {
            throw new BookError.DimensionNotFoundError(backLocation.dimension());
        }
        if (!dim.equals(backLocation.dimension()) && !acrossDimensions) {
            throw new BookError.WrongDimensionError();
        }
        try {
            this.removeLocation(BACK_KEY);
        }
        catch (BookError.NameNotFoundError e) {
            throw new RuntimeException(e);
        }
        this.sync(player);
        backLocation.teleportTo(player, acrossDimensions);
    }

    @Override
    public void teleportTo(String name, ServerPlayerEntity player, boolean acrossDimensions) throws BookError.NameNotFoundError, BookError.WrongDimensionError, BookError.DimensionNotFoundError {
        GlobalPos pos = GlobalPos.func_239648_a_((RegistryKey)player.field_70170_p.func_234923_W_(), (BlockPos)player.func_233580_cy_());
        this.getLocationOrThrow(name).teleportTo(player, acrossDimensions);
        this.saveBackLocation((PlayerEntity)player, pos);
    }

    @Override
    @Nullable
    public TeleportLocation getLocation(String name) {
        return this.locations.get(name);
    }

    @Override
    public TeleportLocation getLocationOrThrow(String name) throws BookError.NameNotFoundError {
        TeleportLocation location = this.getLocation(name);
        if (location == null) {
            throw new BookError.NameNotFoundError(name);
        }
        return location;
    }

    @Override
    public void resetLocations() {
        this.locations.clear();
    }

    @Override
    public void sync(ServerPlayerEntity player) {
        boolean canEdit = false;
        if (this.player != null) {
            canEdit = ItemAlchemicalBook.canEdit(player, this.player);
        } else if (this.itemStack != null) {
            canEdit = ItemAlchemicalBook.canEdit(this.itemStack, player);
        }
        PacketHandler.sendTo(new PacketSyncAlchemicalBookLocations((List<TeleportLocation>)this.getLocations(), canEdit), player);
    }

    @Override
    public ItemAlchemicalBook.Mode getMode() {
        return this.mode;
    }

    @Override
    @Nullable
    public ServerPlayerEntity getPlayer() {
        return this.player;
    }

    @Override
    public ServerPlayerEntity getPlayerOrException() {
        if (this.player == null) {
            throw new NullPointerException("Player is null");
        }
        return this.player;
    }

    @Override
    @Nullable
    public ItemStack getItemStack() {
        return this.itemStack;
    }

    @Override
    public ItemStack getItemStackOrException() {
        if (this.itemStack == null) {
            throw new NullPointerException("ItemStack is null");
        }
        return this.itemStack;
    }

    @Override
    public void syncToOtherPlayers() {
        if (this.player == null) {
            return;
        }
        for (String playerName : ServerLifecycleHooks.getCurrentServer().func_71213_z()) {
            ServerPlayerEntity target = ServerLifecycleHooks.getCurrentServer().func_184103_al().func_152612_a(playerName);
            if (target == null) continue;
            this.syncToPlayer(target);
        }
    }

    @Override
    public void syncToPlayer(ServerPlayerEntity target) {
        ServerPlayerEntity stackOwner;
        if (this.player == null) {
            return;
        }
        ItemStack stack = target.func_184614_ca();
        if (stack.func_77973_b() instanceof ItemAlchemicalBook && ((ItemAlchemicalBook)stack.func_77973_b()).getMode(stack) == ItemAlchemicalBook.Mode.PLAYER && this.player.equals((Object)(stackOwner = ((ItemAlchemicalBook)stack.func_77973_b()).getPlayer(stack)))) {
            CapabilityAlchemicalBookLocations.fromPlayer((PlayerEntity)this.player).sync(target);
        }
    }

    @Override
    public void ensureEditable(ServerPlayerEntity editor) throws BookError.EditNotAllowedError {
        if (this.player != null && !ItemAlchemicalBook.canEdit(editor, this.player)) {
            throw new BookError.EditNotAllowedError();
        }
    }

    public static class BookError
    extends Exception {
        private final Type type;

        public BookError(Type type) {
            super("Book error: " + type.name());
            this.type = type;
        }

        protected String getKey() {
            return this.type.name().toLowerCase();
        }

        public Type getType() {
            return this.type;
        }

        public IFormattableTextComponent getComponent() {
            return Lang.Items.ALCHEMICAL_BOOK_ERROR.extendColored(this.getKey(), TextFormatting.RED, new Object[0]);
        }

        public static enum Type {
            WRONG_DIMENSION,
            DIMENSION_NOT_FOUND,
            NO_BACK_LOCATION,
            NOT_ENOUGH_EMC,
            DUPLICATE_NAME,
            NAME_NOT_FOUND,
            OWNER_OFFLINE,
            EDIT_NOT_ALLOWED;

        }

        public static class EditNotAllowedError
        extends BookError {
            public EditNotAllowedError() {
                super(Type.EDIT_NOT_ALLOWED);
            }
        }

        public static class NotEnoughEMCError
        extends BookError {
            private final String emc;

            public NotEnoughEMCError(String emc) {
                super(Type.NOT_ENOUGH_EMC);
                this.emc = emc;
            }

            @Override
            public IFormattableTextComponent getComponent() {
                return Lang.Items.ALCHEMICAL_BOOK_ERROR.extendColored(this.getKey(), TextFormatting.RED, this.emc);
            }
        }

        public static class OwnerOfflineError
        extends BookError {
            private final ITextComponent player;

            public OwnerOfflineError(ITextComponent name) {
                super(Type.OWNER_OFFLINE);
                this.player = name;
            }

            public OwnerOfflineError(String name) {
                this((ITextComponent)new StringTextComponent(name));
            }

            @Override
            public IFormattableTextComponent getComponent() {
                return Lang.Items.ALCHEMICAL_BOOK_ERROR.extendColored(this.getKey(), TextFormatting.RED, this.player);
            }
        }

        public static class NameNotFoundError
        extends BookError {
            private final ITextComponent name;

            public NameNotFoundError(ITextComponent name) {
                super(Type.NAME_NOT_FOUND);
                this.name = name;
            }

            public NameNotFoundError(String name) {
                this((ITextComponent)new StringTextComponent(name));
            }

            @Override
            public IFormattableTextComponent getComponent() {
                return Lang.Items.ALCHEMICAL_BOOK_ERROR.extendColored(this.getKey(), TextFormatting.RED, this.name);
            }
        }

        public static class DuplicateNameError
        extends BookError {
            private final ITextComponent name;

            public DuplicateNameError(ITextComponent name) {
                super(Type.DUPLICATE_NAME);
                this.name = name;
            }

            public DuplicateNameError(String name) {
                this((ITextComponent)new StringTextComponent(name));
            }

            @Override
            public IFormattableTextComponent getComponent() {
                return Lang.Items.ALCHEMICAL_BOOK_ERROR.extendColored(this.getKey(), TextFormatting.RED, this.name);
            }
        }

        public static class NoBackLocationError
        extends BookError {
            public NoBackLocationError() {
                super(Type.NO_BACK_LOCATION);
            }
        }

        public static class DimensionNotFoundError
        extends BookError {
            private final ITextComponent name;

            public DimensionNotFoundError(ITextComponent name) {
                super(Type.DIMENSION_NOT_FOUND);
                this.name = name;
            }

            public DimensionNotFoundError(RegistryKey<World> level) {
                this((ITextComponent)new TranslationTextComponent(level.func_240901_a_().toString().replace(":", ".")));
            }

            public DimensionNotFoundError(String name) {
                this((ITextComponent)new StringTextComponent(name));
            }

            @Override
            public IFormattableTextComponent getComponent() {
                return Lang.Items.ALCHEMICAL_BOOK_ERROR.extendColored(this.getKey(), TextFormatting.RED, this.name);
            }
        }

        public static class WrongDimensionError
        extends BookError {
            public WrongDimensionError() {
                super(Type.WRONG_DIMENSION);
            }
        }
    }

    public static final class TeleportLocation {
        private final String name;
        private final int x;
        private final int y;
        private final int z;
        private final RegistryKey<World> dimension;
        private final int index;

        public TeleportLocation(String name, int x, int y, int z, RegistryKey<World> dimension, int index) {
            this.name = name;
            this.x = x;
            this.y = y;
            this.z = z;
            this.dimension = dimension;
            this.index = index;
        }

        public void teleportTo(ServerPlayerEntity player, boolean acrossDimensions) throws BookError.DimensionNotFoundError, BookError.WrongDimensionError {
            RegistryKey dim = player.func_71121_q().func_234923_W_();
            ServerWorld level = Util.getDimension(this.dimension);
            if (level == null) {
                throw new BookError.DimensionNotFoundError(this.dimension);
            }
            if (!dim.equals(this.dimension) && !acrossDimensions) {
                throw new BookError.WrongDimensionError();
            }
            player.func_200619_a(level, (double)this.x, (double)this.y, (double)this.z, player.field_70177_z, player.field_70125_A);
        }

        public double distanceFrom(BlockPos pos) {
            return Math.sqrt(Math.pow(pos.func_177958_n() - this.x, 2.0) + Math.pow(pos.func_177956_o() - this.y, 2.0) + Math.pow(pos.func_177952_p() - this.z, 2.0));
        }

        public int getCost(ItemStack stack, PlayerEntity player) {
            if (player.func_184812_l_()) {
                return 0;
            }
            return this.getCost(stack, player.func_226268_ag_());
        }

        public int getCost(ItemStack stack, BlockPos pos) {
            if (!(stack.func_77973_b() instanceof ItemAlchemicalBook)) {
                return (int)Math.ceil(this.distanceFrom(pos) * 1000.0);
            }
            return (int)Math.ceil(this.distanceFrom(pos) * (double)((ItemAlchemicalBook)stack.func_77973_b()).getTier().distanceRatio());
        }

        public TeleportLocation withIndex(int index) {
            return TeleportLocation.from(this.name, new BlockPos(this.x, this.y, this.z), this.dimension, index);
        }

        public boolean isBack() {
            return this.name.equals(CapabilityAlchemicalBookLocations.BACK_KEY);
        }

        public CompoundNBT serialize() {
            CompoundNBT tag = new CompoundNBT();
            tag.func_74778_a(NBTNames.NAME, this.name);
            tag.func_74768_a(NBTNames.X, this.x);
            tag.func_74768_a(NBTNames.Y, this.y);
            tag.func_74768_a(NBTNames.Z, this.z);
            tag.func_74768_a(NBTNames.INDEX, this.index);
            tag.func_74778_a(NBTNames.DIMENSION, this.dimension.func_240901_a_().toString());
            return tag;
        }

        public static TeleportLocation deserialize(CompoundNBT tag) {
            String name = tag.func_74779_i(NBTNames.NAME);
            int x = tag.func_74762_e(NBTNames.X);
            int y = tag.func_74762_e(NBTNames.Y);
            int z = tag.func_74762_e(NBTNames.Z);
            int index = tag.func_74762_e(NBTNames.INDEX);
            RegistryKey dimension = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(tag.func_74779_i(NBTNames.DIMENSION)));
            return new TeleportLocation(name, x, y, z, (RegistryKey<World>)dimension, index);
        }

        public static TeleportLocation from(String name, GlobalPos pos, int index) {
            return TeleportLocation.from(name, pos.func_218180_b(), (RegistryKey<World>)pos.func_239646_a_(), index);
        }

        public static TeleportLocation from(String name, BlockPos pos, RegistryKey<World> dimension, int index) {
            return new TeleportLocation(name, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), dimension, index);
        }

        public String name() {
            return this.name;
        }

        public int x() {
            return this.x;
        }

        public int y() {
            return this.y;
        }

        public int z() {
            return this.z;
        }

        public RegistryKey<World> dimension() {
            return this.dimension;
        }

        public int index() {
            return this.index;
        }
    }

    public static class Provider
    implements ICapabilityResolver<IAlchemicalBookLocationsProvider>,
    ICapabilitySerializable<CompoundNBT> {
        @Nullable
        private LazyOptional<IAlchemicalBookLocationsProvider> cached;
        public static final ResourceLocation NAME = Main.rl("alchemical_book_locations");
        private final IAlchemicalBookLocationsProvider defaultImpl;
        @Nullable
        private final ServerPlayerEntity player;
        @Nullable
        private final ItemStack itemStack;

        public Provider(ItemAlchemicalBook.Mode mode, @Nullable ServerPlayerEntity player, @Nullable ItemStack itemStack) {
            this.defaultImpl = CapabilityAlchemicalBookLocations.getDefault(mode, player, itemStack);
            this.player = player;
            this.itemStack = itemStack;
        }

        @Nonnull
        public Capability<IAlchemicalBookLocationsProvider> getMatchingCapability() {
            return Capabilities.ALCHEMICAL_BOOK_LOCATIONS;
        }

        @Nonnull
        public <T> LazyOptional<T> getCapabilityUnchecked(@Nonnull Capability<T> capability, @Nullable Direction direction) {
            if (this.cached == null || !this.cached.isPresent()) {
                this.cached = LazyOptional.of(() -> this.defaultImpl).cast();
            }
            return this.cached.cast();
        }

        public void invalidate(@Nonnull Capability<?> capability, @Nullable Direction side) {
            this.invalidateAll();
        }

        public void invalidateAll() {
            if (this.cached != null && this.cached.isPresent()) {
                this.cached.invalidate();
                this.cached = null;
            }
        }

        public CompoundNBT serializeNBT() {
            return (CompoundNBT)this.defaultImpl.serializeNBT();
        }

        public void deserializeNBT(CompoundNBT nbt) {
            this.defaultImpl.deserializeNBT((INBT)nbt);
        }
    }
}

