/*
 * Decompiled with CFR 0.152.
 */
package cool.furry.mc.forge.projectexpansion.block;

import cool.furry.mc.forge.projectexpansion.config.Config;
import cool.furry.mc.forge.projectexpansion.tile.TileRelay;
import cool.furry.mc.forge.projectexpansion.util.ColorStyle;
import cool.furry.mc.forge.projectexpansion.util.EMCFormat;
import cool.furry.mc.forge.projectexpansion.util.IHasMatter;
import cool.furry.mc.forge.projectexpansion.util.Lang;
import cool.furry.mc.forge.projectexpansion.util.Matter;
import java.math.BigInteger;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.PushReaction;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BlockRelay
extends Block
implements IHasMatter {
    private final Matter matter;

    public BlockRelay(Matter matter) {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200948_a(10.0f, 30.0f).func_235861_h_().func_235838_a_(state -> Math.min(matter.ordinal(), 15)));
        this.matter = matter;
    }

    @Override
    @Nonnull
    public Matter getMatter() {
        return this.matter;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileRelay();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable IBlockReader level, List<ITextComponent> list, ITooltipFlag flag) {
        super.func_190948_a(stack, level, list, flag);
        list.add((ITextComponent)Lang.Blocks.RELAY_TOOLTIP.translateColored(TextFormatting.GRAY, new Object[0]));
        list.add((ITextComponent)Lang.Blocks.RELAY_BONUS.translateColored(TextFormatting.GRAY, new Object[]{EMCFormat.getComponent(this.getMatter().getRelayBonusForTicks((Integer)Config.tickDelay.get())).func_230530_a_(ColorStyle.GREEN)}));
        list.add((ITextComponent)Lang.Blocks.RELAY_TRANSFER.translateColored(TextFormatting.GRAY, new Object[]{this.getMatter().getRelayTransferComponent().func_230530_a_(ColorStyle.GREEN)}));
        if (stack.func_190916_E() > 1) {
            list.add((ITextComponent)Lang.Blocks.COLLECTOR_STACK_EMC.translateColored(TextFormatting.GRAY, new Object[]{EMCFormat.getComponent(this.getMatter().getCollectorOutputForTicks((Integer)Config.tickDelay.get()).multiply(BigInteger.valueOf(stack.func_190916_E()))).func_230530_a_(ColorStyle.GREEN)}));
        }
        list.add((ITextComponent)Lang.SEE_WIKI.translateColored(TextFormatting.AQUA, new Object[0]));
    }

    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.BLOCK;
    }
}

