/*
 * Decompiled with CFR 0.152.
 */
package cool.furry.mc.forge.projectexpansion.block;

import cool.furry.mc.forge.projectexpansion.config.Config;
import cool.furry.mc.forge.projectexpansion.tile.TilePowerFlower;
import cool.furry.mc.forge.projectexpansion.util.ColorStyle;
import cool.furry.mc.forge.projectexpansion.util.EMCFormat;
import cool.furry.mc.forge.projectexpansion.util.IHasMatter;
import cool.furry.mc.forge.projectexpansion.util.Lang;
import cool.furry.mc.forge.projectexpansion.util.Matter;
import java.math.BigInteger;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.PushReaction;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BlockPowerFlower
extends Block
implements IHasMatter {
    public static final VoxelShape SHAPE = VoxelShapes.func_216384_a((VoxelShape)BlockPowerFlower.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0), (VoxelShape[])new VoxelShape[]{BlockPowerFlower.func_208617_a((double)3.5, (double)4.0, (double)6.5, (double)12.5, (double)13.0, (double)9.5), BlockPowerFlower.func_208617_a((double)6.5, (double)1.0, (double)6.5, (double)9.5, (double)16.0, (double)9.5), BlockPowerFlower.func_208617_a((double)6.5, (double)4.0, (double)3.5, (double)9.5, (double)13.0, (double)12.5), BlockPowerFlower.func_208617_a((double)6.5, (double)7.0, (double)0.5, (double)9.5, (double)10.0, (double)15.5), BlockPowerFlower.func_208617_a((double)3.5, (double)7.0, (double)3.5, (double)12.5, (double)10.0, (double)12.5), BlockPowerFlower.func_208617_a((double)0.5, (double)7.0, (double)6.5, (double)15.5, (double)10.0, (double)9.5)});
    private final Matter matter;

    public BlockPowerFlower(Matter matter) {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200948_a(1.5f, 30.0f).func_235838_a_(state -> Math.min(matter.ordinal(), 15)));
        this.matter = matter;
    }

    @Override
    @Nonnull
    public Matter getMatter() {
        return this.matter;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TilePowerFlower();
    }

    @Nonnull
    @Deprecated
    public VoxelShape func_220053_a(@Nonnull BlockState state, @Nonnull IBlockReader world, @Nonnull BlockPos pos, @Nonnull ISelectionContext ctx) {
        return SHAPE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable IBlockReader level, List<ITextComponent> list, ITooltipFlag flag) {
        super.func_190948_a(stack, level, list, flag);
        list.add((ITextComponent)Lang.Blocks.POWER_FLOWER_TOOLTIP.translateColored(TextFormatting.GRAY, new Object[]{new StringTextComponent(((Integer)Config.tickDelay.get()).toString()).func_230530_a_(ColorStyle.GREEN), new StringTextComponent((Integer)Config.tickDelay.get() == 1 ? "" : "s").func_230530_a_(ColorStyle.GRAY)}));
        list.add((ITextComponent)Lang.Blocks.POWER_FLOWER_EMC.translateColored(TextFormatting.GRAY, new Object[]{EMCFormat.getComponent(this.getMatter().getPowerFlowerOutput()).func_230530_a_(ColorStyle.GREEN)}));
        if (stack.func_190916_E() > 1) {
            list.add((ITextComponent)Lang.Blocks.POWER_FLOWER_STACK_EMC.translateColored(TextFormatting.GRAY, new Object[]{EMCFormat.getComponent(this.getMatter().getPowerFlowerOutput().multiply(BigInteger.valueOf(stack.func_190916_E()))).func_230530_a_(ColorStyle.GREEN)}));
        }
        list.add((ITextComponent)Lang.SEE_WIKI.translateColored(TextFormatting.AQUA, new Object[0]));
    }

    @Deprecated
    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult ray) {
        if (world.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TilePowerFlower) {
            player.func_146105_b((ITextComponent)new StringTextComponent(((TilePowerFlower)tile).ownerName), true);
        }
        return super.func_225533_a_(state, world, pos, player, hand, ray);
    }

    public void func_180633_a(World level, BlockPos pos, BlockState state, @Nullable LivingEntity livingEntity, ItemStack stack) {
        TileEntity tile = level.func_175625_s(pos);
        if (tile instanceof TilePowerFlower) {
            ((TilePowerFlower)tile).handlePlace(livingEntity, stack);
        }
    }

    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.BLOCK;
    }
}

