/*
 * Decompiled with CFR 0.152.
 */
package cool.furry.mc.forge.projectexpansion.block;

import cool.furry.mc.forge.projectexpansion.tile.TileEMCLink;
import cool.furry.mc.forge.projectexpansion.tile.TileNBTFilterable;
import cool.furry.mc.forge.projectexpansion.util.ColorStyle;
import cool.furry.mc.forge.projectexpansion.util.IHasMatter;
import cool.furry.mc.forge.projectexpansion.util.Lang;
import cool.furry.mc.forge.projectexpansion.util.Matter;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.PushReaction;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BlockEMCLink
extends Block
implements IHasMatter {
    private final Matter matter;

    public BlockEMCLink(Matter matter) {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200948_a(1.5f, 30.0f).func_235861_h_().func_235838_a_(state -> Math.min(matter.ordinal(), 15)));
        this.matter = matter;
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)TileNBTFilterable.FILTER, (Comparable)Boolean.valueOf(true)));
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileEMCLink();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable IBlockReader level, List<ITextComponent> list, ITooltipFlag flag) {
        super.func_190948_a(stack, level, list, flag);
        list.add((ITextComponent)Lang.Blocks.EMC_LINK_TOOLTIP.translateColored(TextFormatting.GRAY, new Object[]{this.getMatter().getEMCLinkItemLimitComponent()}));
        list.add((ITextComponent)Lang.Blocks.EMC_LINK_LIMIT_ITEMS.translateColored(TextFormatting.GRAY, new Object[]{this.getMatter().getEMCLinkFluidLimitComponent()}));
        list.add((ITextComponent)Lang.Blocks.EMC_LINK_LIMIT_FLUIDS.translateColored(TextFormatting.GRAY, new Object[]{this.getMatter().getEMCLinkEMCLimitComponent()}));
        list.add((ITextComponent)Lang.Blocks.EMC_LINK_FLUID_EXPORT_EFFICIENCY.translateColored(TextFormatting.GRAY, new Object[]{new StringTextComponent(this.getMatter().getFluidEfficiencyPercentage() + "%").func_230530_a_(ColorStyle.GREEN)}));
        list.add((ITextComponent)Lang.Blocks.EMC_LINK_LIMIT_EMC.translateColored(TextFormatting.GRAY, new Object[]{this.getMatter().getEMCLinkEMCLimitComponent()}));
        list.add((ITextComponent)Lang.SEE_WIKI.translateColored(TextFormatting.AQUA, new Object[0]));
    }

    public ActionResultType func_225533_a_(BlockState state, World level, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (level.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        TileEntity blockEntity = level.func_175625_s(pos);
        if (blockEntity instanceof TileEMCLink) {
            return ((TileEMCLink)blockEntity).handleActivation(player, hand);
        }
        return ActionResultType.PASS;
    }

    public void func_180633_a(World level, BlockPos pos, BlockState state, @Nullable LivingEntity livingEntity, ItemStack stack) {
        TileEntity blockEntity = level.func_175625_s(pos);
        if (blockEntity instanceof TileEMCLink) {
            ((TileEMCLink)blockEntity).handlePlace(livingEntity, stack);
        }
    }

    @Override
    @Nonnull
    public Matter getMatter() {
        return this.matter;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{TileNBTFilterable.FILTER});
        super.func_206840_a(builder);
    }

    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.BLOCK;
    }
}

