/*
 * Decompiled with CFR 0.152.
 */
package cool.furry.mc.forge.projectexpansion.block;

import cool.furry.mc.forge.projectexpansion.gui.container.ContainerAdvancedAlchemicalChest;
import cool.furry.mc.forge.projectexpansion.tile.TileAdvancedAlchemicalChest;
import cool.furry.mc.forge.projectexpansion.tile.TileOwnable;
import cool.furry.mc.forge.projectexpansion.util.AdvancedAlchemicalChest;
import cool.furry.mc.forge.projectexpansion.util.IHasColor;
import cool.furry.mc.forge.projectexpansion.util.Lang;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.piglin.PiglinTasks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.stats.Stats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public class BlockAdvancedAlchemicalChest
extends HorizontalBlock
implements IWaterLoggable,
IHasColor {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    private static final VoxelShape SHAPE = Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0);
    private final DyeColor color;

    public BlockAdvancedAlchemicalChest(DyeColor color) {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_235861_h_().func_200948_a(10.0f, 3600000.0f).func_235838_a_(state -> 10));
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)field_185512_D, (Comparable)Direction.NORTH)).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
        this.color = color;
    }

    @Override
    @Nonnull
    public DyeColor getColor() {
        return this.color;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable IBlockReader level, List<ITextComponent> list, ITooltipFlag flag) {
        super.func_190948_a(stack, level, list, flag);
        list.add((ITextComponent)Lang.Blocks.ADVANCED_ALCHEMICAL_CHEST_TOOLTIP.translateColored(TextFormatting.GRAY, new Object[0]));
        list.add((ITextComponent)Lang.SEE_WIKI.translateColored(TextFormatting.AQUA, new Object[0]));
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileAdvancedAlchemicalChest(AdvancedAlchemicalChest.getBlockEntityType(this.color), this.color);
    }

    public ActionResultType func_225533_a_(BlockState state, World level, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (level.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        TileEntity blockEntity = level.func_175625_s(pos);
        if (blockEntity instanceof TileAdvancedAlchemicalChest) {
            TileAdvancedAlchemicalChest be = (TileAdvancedAlchemicalChest)blockEntity;
            if (player.func_213453_ef()) {
                PiglinTasks.func_234478_a_((PlayerEntity)player, (boolean)true);
                return be.handleActivation(player, hand);
            }
            if (be.handleActivation(player, TileOwnable.ActivationType.CHECK_OWNERSHIP)) {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new ContainerProvider(be, hand), buf -> {
                    buf.func_179249_a((Enum)hand);
                    buf.writeByte(player.field_71071_by.field_70461_c);
                    buf.writeBoolean(false);
                    buf.func_179255_a(pos);
                });
                player.func_195066_a(Stats.field_188063_ac);
                PiglinTasks.func_234478_a_((PlayerEntity)player, (boolean)true);
                return ActionResultType.CONSUME;
            }
        }
        return ActionResultType.FAIL;
    }

    public void func_180633_a(World level, BlockPos pos, BlockState state, @Nullable LivingEntity livingEntity, ItemStack stack) {
        TileEntity tile = level.func_175625_s(pos);
        if (tile instanceof TileAdvancedAlchemicalChest) {
            ((TileAdvancedAlchemicalChest)tile).handlePlace(livingEntity, stack);
        }
    }

    public VoxelShape func_220053_a(BlockState p_220053_1_, IBlockReader p_220053_2_, BlockPos p_220053_3_, ISelectionContext p_220053_4_) {
        return SHAPE;
    }

    public BlockRenderType func_149645_b(BlockState p_149645_1_) {
        return BlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public int func_180641_l(BlockState state, World level, BlockPos pos) {
        TileEntity blockEntity = level.func_175625_s(pos);
        if (blockEntity instanceof TileAdvancedAlchemicalChest) {
            return blockEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).map(ItemHandlerHelper::calcRedstoneFromInventory).orElse(0);
        }
        return 0;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)((BlockState)Objects.requireNonNull(super.func_196258_a(context)).func_206870_a((Property)field_185512_D, (Comparable)(context.func_195999_j() == null ? Direction.NORTH : context.func_195999_j().func_174811_aO().func_176734_d()))).func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(context.func_195991_k().func_204610_c(context.func_195995_a()).func_206886_c() == Fluids.field_204546_a));
    }

    @Nonnull
    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)BlockStateProperties.field_208198_y) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    @Nonnull
    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld level, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.func_177229_b((Property)BlockStateProperties.field_208198_y)).booleanValue()) {
            level.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)level));
        }
        return super.func_196271_a(state, facing, facingState, level, currentPos, facingPos);
    }

    public boolean func_189539_a(BlockState state, World level, BlockPos pos, int id, int param) {
        super.func_189539_a(state, level, pos, id, param);
        TileEntity blockEntity = level.func_175625_s(pos);
        return blockEntity != null && blockEntity.func_145842_c(id, param);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{field_185512_D, WATERLOGGED});
    }

    private static class ContainerProvider
    implements INamedContainerProvider {
        private final TileAdvancedAlchemicalChest blockEntity;
        private final Hand hand;

        private ContainerProvider(TileAdvancedAlchemicalChest blockEntity, Hand hand) {
            this.blockEntity = blockEntity;
            this.hand = hand;
        }

        @Nonnull
        public Container createMenu(int windowId, PlayerInventory playerInventory, PlayerEntity player) {
            IItemHandlerModifiable inv = (IItemHandlerModifiable)this.blockEntity.getBag();
            return new ContainerAdvancedAlchemicalChest(windowId, playerInventory, this.hand, Objects.requireNonNull(inv), playerInventory.field_70461_c, false, this.blockEntity);
        }

        @Nonnull
        public ITextComponent func_145748_c_() {
            return Lang.ADVANCED_ALCHEMICAL_CHEST_TITLE.translate(new Object[0]);
        }
    }
}

