/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.cluster;

import io.lettuce.core.ClientOptions;
import io.lettuce.core.cluster.ClusterClientOptions;
import io.lettuce.core.cluster.ClusterEventListener;
import io.lettuce.core.cluster.ClusterTopologyRefreshOptions;
import io.lettuce.core.cluster.models.partitions.Partitions;
import io.lettuce.core.event.cluster.AdaptiveRefreshTriggeredEvent;
import io.lettuce.core.resource.ClientResources;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.ScheduledFuture;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.time.Duration;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;

class ClusterTopologyRefreshScheduler
implements Runnable,
ClusterEventListener {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ClusterTopologyRefreshScheduler.class);
    private static final ClusterTopologyRefreshOptions FALLBACK_OPTIONS = ClusterTopologyRefreshOptions.create();
    private final Supplier<ClusterClientOptions> clientOptions;
    private final Supplier<Partitions> partitions;
    private final ClientResources clientResources;
    private final ClusterTopologyRefreshTask clusterTopologyRefreshTask;
    private final AtomicReference<Timeout> timeoutRef = new AtomicReference();
    private final AtomicBoolean clusterTopologyRefreshActivated = new AtomicBoolean(false);
    private final AtomicReference<ScheduledFuture<?>> clusterTopologyRefreshFuture = new AtomicReference();
    private final EventExecutorGroup genericWorkerPool;

    ClusterTopologyRefreshScheduler(Supplier<ClusterClientOptions> clientOptions, Supplier<Partitions> partitions, Supplier<CompletionStage<?>> refreshTopology, ClientResources clientResources) {
        this.clientOptions = clientOptions;
        this.partitions = partitions;
        this.clientResources = clientResources;
        this.genericWorkerPool = this.clientResources.eventExecutorGroup();
        this.clusterTopologyRefreshTask = new ClusterTopologyRefreshTask(refreshTopology);
    }

    protected void activateTopologyRefreshIfNeeded() {
        ClusterClientOptions options = this.clientOptions.get();
        ClusterTopologyRefreshOptions topologyRefreshOptions = options.getTopologyRefreshOptions();
        if (!topologyRefreshOptions.isPeriodicRefreshEnabled() || this.clusterTopologyRefreshActivated.get()) {
            return;
        }
        if (this.clusterTopologyRefreshActivated.compareAndSet(false, true)) {
            ScheduledFuture<?> scheduledFuture = this.genericWorkerPool.scheduleAtFixedRate(this, options.getRefreshPeriod().toNanos(), options.getRefreshPeriod().toNanos(), TimeUnit.NANOSECONDS);
            this.clusterTopologyRefreshFuture.set(scheduledFuture);
        }
    }

    public void shutdown() {
        if (this.clusterTopologyRefreshActivated.compareAndSet(true, false)) {
            ScheduledFuture<?> scheduledFuture = this.clusterTopologyRefreshFuture.get();
            try {
                scheduledFuture.cancel(false);
                this.clusterTopologyRefreshFuture.set(null);
            }
            catch (Exception e) {
                logger.debug("Could not cancel Cluster topology refresh", e);
            }
        }
    }

    @Override
    public void run() {
        logger.debug("ClusterTopologyRefreshScheduler.run()");
        if (this.isEventLoopActive()) {
            if (!this.clientOptions.get().isRefreshClusterView()) {
                logger.debug("Periodic ClusterTopologyRefresh is disabled");
                return;
            }
        } else {
            logger.debug("Periodic ClusterTopologyRefresh is disabled");
            return;
        }
        this.clientResources.eventExecutorGroup().submit(this.clusterTopologyRefreshTask);
    }

    @Override
    public void onAskRedirection() {
        if (this.isEnabled(ClusterTopologyRefreshOptions.RefreshTrigger.ASK_REDIRECT)) {
            this.indicateTopologyRefreshSignal();
        }
    }

    @Override
    public void onMovedRedirection() {
        if (this.isEnabled(ClusterTopologyRefreshOptions.RefreshTrigger.MOVED_REDIRECT) && this.indicateTopologyRefreshSignal()) {
            this.emitAdaptiveRefreshScheduledEvent();
        }
    }

    @Override
    public void onReconnectAttempt(int attempt) {
        if (this.isEnabled(ClusterTopologyRefreshOptions.RefreshTrigger.PERSISTENT_RECONNECTS) && attempt >= this.getClusterTopologyRefreshOptions().getRefreshTriggersReconnectAttempts() && this.indicateTopologyRefreshSignal()) {
            this.emitAdaptiveRefreshScheduledEvent();
        }
    }

    @Override
    public void onUncoveredSlot(int slot) {
        if (this.isEnabled(ClusterTopologyRefreshOptions.RefreshTrigger.UNCOVERED_SLOT) && this.indicateTopologyRefreshSignal()) {
            this.emitAdaptiveRefreshScheduledEvent();
        }
    }

    @Override
    public void onUnknownNode() {
        if (this.isEnabled(ClusterTopologyRefreshOptions.RefreshTrigger.UNKNOWN_NODE) && this.indicateTopologyRefreshSignal()) {
            this.emitAdaptiveRefreshScheduledEvent();
        }
    }

    private void emitAdaptiveRefreshScheduledEvent() {
        AdaptiveRefreshTriggeredEvent event = new AdaptiveRefreshTriggeredEvent(this.partitions, this::scheduleRefresh);
        this.clientResources.eventBus().publish(event);
    }

    private boolean indicateTopologyRefreshSignal() {
        logger.debug("ClusterTopologyRefreshScheduler.indicateTopologyRefreshSignal()");
        if (!this.acquireTimeout()) {
            return false;
        }
        return this.scheduleRefresh();
    }

    private boolean scheduleRefresh() {
        if (this.isEventLoopActive()) {
            this.clientResources.eventExecutorGroup().submit(this.clusterTopologyRefreshTask);
            return true;
        }
        logger.debug("ClusterTopologyRefresh is disabled");
        return false;
    }

    private boolean isEventLoopActive() {
        EventExecutorGroup eventExecutors = this.clientResources.eventExecutorGroup();
        return !eventExecutors.isShuttingDown() && !eventExecutors.isShutdown() && !eventExecutors.isTerminated();
    }

    private boolean acquireTimeout() {
        Timeout existingTimeout = this.timeoutRef.get();
        if (existingTimeout != null && !existingTimeout.isExpired()) {
            return false;
        }
        ClusterTopologyRefreshOptions refreshOptions = this.getClusterTopologyRefreshOptions();
        Timeout timeout = new Timeout(refreshOptions.getAdaptiveRefreshTimeout());
        return this.timeoutRef.compareAndSet(existingTimeout, timeout);
    }

    private ClusterTopologyRefreshOptions getClusterTopologyRefreshOptions() {
        ClientOptions clientOptions = this.clientOptions.get();
        if (clientOptions instanceof ClusterClientOptions) {
            return ((ClusterClientOptions)clientOptions).getTopologyRefreshOptions();
        }
        return FALLBACK_OPTIONS;
    }

    private boolean isEnabled(ClusterTopologyRefreshOptions.RefreshTrigger refreshTrigger) {
        return this.getClusterTopologyRefreshOptions().getAdaptiveRefreshTriggers().contains((Object)refreshTrigger);
    }

    private static class ClusterTopologyRefreshTask
    extends AtomicBoolean
    implements Runnable {
        private static final long serialVersionUID = -1337731371220365694L;
        private final Supplier<CompletionStage<?>> reloadTopologyAsync;

        ClusterTopologyRefreshTask(Supplier<CompletionStage<?>> reloadTopologyAsync) {
            this.reloadTopologyAsync = reloadTopologyAsync;
        }

        @Override
        public void run() {
            if (this.compareAndSet(false, true)) {
                this.doRun();
                return;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("ClusterTopologyRefreshTask already in progress");
            }
        }

        void doRun() {
            if (logger.isDebugEnabled()) {
                logger.debug("ClusterTopologyRefreshTask requesting partitions");
            }
            try {
                this.reloadTopologyAsync.get().whenComplete((ignore, throwable) -> {
                    if (throwable != null) {
                        logger.warn("Cannot refresh Redis Cluster topology", (Throwable)throwable);
                    }
                    this.set(false);
                });
            }
            catch (Exception e) {
                logger.warn("Cannot refresh Redis Cluster topology", e);
            }
        }
    }

    private class Timeout {
        private final long expiresMs;

        public Timeout(Duration duration) {
            this.expiresMs = System.currentTimeMillis() + duration.toMillis();
        }

        public boolean isExpired() {
            return this.expiresMs < System.currentTimeMillis();
        }

        public long remaining() {
            long diff = this.expiresMs - System.currentTimeMillis();
            if (diff > 0L) {
                return diff;
            }
            return 0L;
        }
    }
}

