/*
 * Decompiled with CFR 0.152.
 */
package de.waterdu.atlantis.util.text;

import com.google.common.base.CharMatcher;
import com.google.common.collect.Sets;
import de.waterdu.atlantis.util.java.ExceptionUtils;
import de.waterdu.atlantis.util.placeholder.AtlantisPlaceholderProxy;
import de.waterdu.atlantis.util.text.Text;
import java.awt.Color;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Pattern;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import org.apache.commons.lang3.StringUtils;

public class TextUtils {
    public static final String PLACEHOLDER_CHAR = "%";
    public static final String COLOR_CHAR = "&";
    public static final String TRUE_COLOR_CHAR = "\u00a7";
    public static final String HEX_CHAR = "#";
    public static final String GRADIENT_CHAR = "@";
    public static final String HEX_PATTERN = "\u00a7#";
    public static final String GRADIENT_PATTERN = "\u00a7#@";
    public static final String COLOR_FORMAT = "#%02x%02x%02x";
    public static final Pattern NON_ALPHANUMERIC_PATTERN = Pattern.compile("[^a-zA-Z0-9]");
    public static final boolean[] NO_STYLE = new boolean[]{false, false, false, false, false};
    public static final Set<String> DO_NOT_CAPITALIZE = Sets.newHashSet((Object[])new String[]{"the", "a", "of", "and", "for", "nor", "but", "or", "yet", "so"});

    private TextUtils() {
        ExceptionUtils.throwCannotInstantiateClassException();
    }

    public static Text format(Text in, Object ... args) {
        return TextUtils.format(in.get(), args);
    }

    public static Text format(String in, Object ... args) {
        for (int i = args.length; i > 0; --i) {
            Object arg = args[i - 1];
            in = arg instanceof ITextComponent ? in.replace(PLACEHOLDER_CHAR + i, ((ITextComponent)arg).getString()) : in.replace(PLACEHOLDER_CHAR + i, String.valueOf(arg));
        }
        return Text.of(in);
    }

    public static IFormattableTextComponent colorize(String in) {
        in = in.replace(COLOR_CHAR, TRUE_COLOR_CHAR);
        StringTextComponent component = new StringTextComponent("");
        StringBuilder builder = new StringBuilder();
        String[] split2 = in.split(TRUE_COLOR_CHAR, -1);
        boolean first = in.startsWith(HEX_PATTERN);
        boolean first2 = in.startsWith(TRUE_COLOR_CHAR);
        for (int i = 0; i < split2.length; ++i) {
            String str = split2[i];
            if (str.startsWith(HEX_CHAR)) {
                boolean[] styles;
                str = str.substring(1);
                if (!first) {
                    builder.append(str);
                    first = true;
                    continue;
                }
                if (builder.length() > 0) {
                    component.func_230529_a_((ITextComponent)new StringTextComponent(builder.toString()));
                    builder = new StringBuilder();
                }
                if (str.startsWith(GRADIENT_CHAR)) {
                    boolean[] styles2;
                    float[] start = Color.decode(HEX_CHAR + str.substring(1, 7)).getRGBColorComponents(null);
                    float[] end = Color.decode(HEX_CHAR + str.substring(8, 14)).getRGBColorComponents(null);
                    if ((str = str.substring(14)).startsWith("[") && str.length() >= 3 && str.contains("]")) {
                        styles2 = TextUtils.getStyleArray(str.substring(str.indexOf("[") + 1, str.indexOf("]")));
                        str = str.substring(str.indexOf("]") + 1);
                    } else {
                        styles2 = NO_STYLE;
                    }
                    char[] chars = str.toCharArray();
                    float r = (end[0] - start[0]) / (float)(chars.length - 1);
                    float g = (end[1] - start[1]) / (float)(chars.length - 1);
                    float b = (end[2] - start[2]) / (float)(chars.length - 1);
                    for (int j = 0; j < chars.length; ++j) {
                        StringTextComponent segment = new StringTextComponent(String.valueOf(chars[j]));
                        segment.func_230530_a_(Style.field_240709_b_.func_240718_a_(net.minecraft.util.text.Color.func_240745_a_((String)String.format(COLOR_FORMAT, (int)((start[0] + r * (float)j) * 255.0f), (int)((start[1] + g * (float)j) * 255.0f), (int)((start[2] + b * (float)j) * 255.0f)))));
                        TextUtils.applyStyleArray((IFormattableTextComponent)segment, styles2);
                        component.func_230529_a_((ITextComponent)segment);
                    }
                    continue;
                }
                String hex = HEX_CHAR + str.substring(0, 6);
                if ((str = str.substring(6)).startsWith("[") && str.length() >= 3 && str.contains("]")) {
                    styles = TextUtils.getStyleArray(str.substring(str.indexOf("[") + 1, str.indexOf("]")));
                    str = str.substring(str.indexOf("]") + 1);
                } else {
                    styles = NO_STYLE;
                }
                StringTextComponent segment = new StringTextComponent(str);
                segment.func_230530_a_(Style.field_240709_b_.func_240718_a_(net.minecraft.util.text.Color.func_240745_a_((String)hex)));
                TextUtils.applyStyleArray((IFormattableTextComponent)segment, styles);
                component.func_230529_a_((ITextComponent)segment);
                continue;
            }
            if (!str.isEmpty()) {
                builder.append(first2 ? TRUE_COLOR_CHAR : "").append(str);
            }
            first = true;
            first2 = true;
        }
        if (builder.length() > 0) {
            component.func_230529_a_((ITextComponent)new StringTextComponent(builder.toString()));
        }
        return component;
    }

    public static IFormattableTextComponent combine(Object ... components) {
        StringTextComponent component = new StringTextComponent("");
        for (Object object : components) {
            if (object instanceof ITextComponent) {
                component.func_230529_a_((ITextComponent)object);
                continue;
            }
            component.func_240702_b_(String.valueOf(object));
        }
        return component;
    }

    public static String stripNewlines(String in) {
        return in.replace("\\n", "\\NEWLINE").replace("\n", "").replace("\\NEWLINE", "\\n");
    }

    public static String concat(String ... strings) {
        return TextUtils.concat(0, " ", strings);
    }

    public static String concat(int start, String divider, String ... strings) {
        return TextUtils.concat(start, strings.length, divider, strings);
    }

    public static String concat(int start, int end, String divider, String ... strings) {
        StringBuilder builder = new StringBuilder();
        for (int i = start; i < strings.length && i < end; ++i) {
            if (builder.length() > 0) {
                builder.append(divider);
            }
            builder.append(strings[i]);
        }
        return builder.toString();
    }

    public static String stripSpecialCharacters(String in) {
        return CharMatcher.ascii().retainFrom((CharSequence)in);
    }

    public static boolean[] getStyleArray(String codes) {
        HashSet chars = Sets.newHashSet();
        for (char c : codes.toCharArray()) {
            chars.add(Character.valueOf(c));
        }
        if (chars.contains(Character.valueOf('R')) || chars.contains(Character.valueOf('r'))) {
            return NO_STYLE;
        }
        return new boolean[]{chars.contains(Character.valueOf('K')) || chars.contains(Character.valueOf('k')), chars.contains(Character.valueOf('L')) || chars.contains(Character.valueOf('l')), chars.contains(Character.valueOf('M')) || chars.contains(Character.valueOf('m')), chars.contains(Character.valueOf('N')) || chars.contains(Character.valueOf('n')), chars.contains(Character.valueOf('O')) || chars.contains(Character.valueOf('o'))};
    }

    public static void applyStyleArray(IFormattableTextComponent text, boolean[] style) {
        for (ITextComponent sibling : text.func_150253_a()) {
            if (!(sibling instanceof StringTextComponent)) continue;
            TextUtils.applyStyleArray((IFormattableTextComponent)((StringTextComponent)sibling), style);
        }
        text.func_230530_a_(text.func_150256_b().setObfuscated(Boolean.valueOf(style[0])).func_240713_a_(Boolean.valueOf(style[1])).setStrikethrough(Boolean.valueOf(style[2])).setUnderlined(Boolean.valueOf(style[3])).func_240722_b_(Boolean.valueOf(style[4])));
    }

    public static IFormattableTextComponent empty() {
        return new StringTextComponent(" ");
    }

    public static Text asText(Object o) {
        if (o instanceof IFormattableTextComponent) {
            return Text.of((ITextComponent)((IFormattableTextComponent)o));
        }
        if (o instanceof Text) {
            return (Text)o;
        }
        return Text.of(o.toString());
    }

    public static IFormattableTextComponent asComponentWithPlaceholders(PlayerEntity player, Object o) {
        if (o instanceof IFormattableTextComponent) {
            return (IFormattableTextComponent)o;
        }
        if (o instanceof Text) {
            return AtlantisPlaceholderProxy.replace(player, (Text)o).compile();
        }
        return AtlantisPlaceholderProxy.replace(player, Text.of(o.toString())).compile();
    }

    public static IFormattableTextComponent asComponent(Object o) {
        if (o instanceof IFormattableTextComponent) {
            return (IFormattableTextComponent)o;
        }
        if (o instanceof Text) {
            return ((Text)o).compile();
        }
        return Text.of(o.toString()).compile();
    }

    public static String asString(Object o) {
        if (o instanceof IFormattableTextComponent) {
            return ((IFormattableTextComponent)o).getString();
        }
        if (o instanceof Text) {
            return ((Text)o).get();
        }
        return o.toString();
    }

    public static Text[] toArray(Object[] other) {
        Text[] texts = new Text[other.length];
        for (int i = 0; i < other.length; ++i) {
            texts[i] = TextUtils.asText(other[i]);
        }
        return texts;
    }

    public static String[] join(String[] a1, String ... a2) {
        String[] join = new String[a1.length + a2.length];
        System.arraycopy(a1, 0, join, 0, a1.length);
        System.arraycopy(a2, 0, join, a1.length, a2.length);
        return join;
    }

    public static int countCharOccurrence(String string, char test) {
        int count = 0;
        for (char c : string.toCharArray()) {
            if (c != test) continue;
            ++count;
        }
        return count;
    }

    public static int countCharOccurrenceDifference(String string, char add, char subtract) {
        int count = 0;
        for (char c : string.toCharArray()) {
            if (c == add) {
                ++count;
                continue;
            }
            if (c != subtract) continue;
            --count;
        }
        return count;
    }

    public static Text capitalizeEachWord(Text in) {
        return TextUtils.capitalizeEachWord(in, DO_NOT_CAPITALIZE);
    }

    public static Text capitalizeEachWord(Text in, Set<String> doNotCapitalize) {
        return Text.of(TextUtils.capitalizeEachWord(in.get(), doNotCapitalize));
    }

    public static String capitalizeEachWord(String in) {
        return TextUtils.capitalizeEachWord(in, DO_NOT_CAPITALIZE);
    }

    public static String capitalizeEachWord(String in, Set<String> doNotCapitalize) {
        StringBuilder builder = new StringBuilder();
        String[] split2 = in.toLowerCase(Locale.ROOT).split(" ");
        boolean first = true;
        for (String word : split2) {
            if (builder.length() > 0) {
                builder.append(" ");
            }
            boolean capitalize = first || !doNotCapitalize.contains(word);
            builder.append(capitalize ? StringUtils.capitalize((String)word) : word);
            first = false;
        }
        return builder.toString();
    }
}

