/*
 * Decompiled with CFR 0.152.
 */
package de.waterdu.atlantis.util.text;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import de.waterdu.atlantis.util.text.MessageUtils;
import de.waterdu.atlantis.util.text.TextUtils;
import java.awt.Color;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.Locale;
import java.util.stream.IntStream;
import net.minecraft.command.ICommandSource;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;

public class Text
implements Serializable,
Comparable<Text>,
CharSequence {
    private String value;
    private boolean raw = false;

    protected Text(String value) {
        this.value = value;
    }

    public static Text of(String string) {
        return new Text(string);
    }

    public static Text of(ITextComponent component) {
        return Text.of(component.getString());
    }

    public static Text empty() {
        return new Text("");
    }

    public Text mutable() {
        return Text.of(this.get());
    }

    public Text immutable() {
        return Immutable.of(this.get());
    }

    public Text raw() {
        this.raw = true;
        return this;
    }

    public Text compiled() {
        this.raw = false;
        return this;
    }

    public Text set(String string) {
        this.value = string;
        return this;
    }

    public Text clear() {
        this.value = "";
        return this;
    }

    public Text append(Object string) {
        this.value = this.value + string;
        return this;
    }

    public Text prepend(Object string) {
        this.value = string + this.value;
        return this;
    }

    public String[] split(String regex) {
        return this.value.split(regex);
    }

    public Text set(Text string) {
        this.value = string.value;
        return this;
    }

    public Text append(Text string) {
        this.value = this.value + string.value;
        return this;
    }

    public Text prepend(Text string) {
        this.value = string.value + this.value;
        return this;
    }

    public String[] split(Text regex) {
        return this.value.split(regex.value);
    }

    public boolean contains(CharSequence s) {
        return this.value.contains(s);
    }

    public boolean equalsIgnoreCase(String string) {
        return this.value.equalsIgnoreCase(string);
    }

    public boolean equalsIgnoreCase(Text string) {
        return this.value.equalsIgnoreCase(string.value);
    }

    @Override
    public boolean isEmpty() {
        return this.value.isEmpty();
    }

    public Text replace(CharSequence target, CharSequence replacement) {
        return Text.of(this.value.replace(target, replacement));
    }

    public Text toLowerCase() {
        return Text.of(this.value.toLowerCase());
    }

    public Text toUpperCase() {
        return Text.of(this.value.toUpperCase());
    }

    public Text trim() {
        return Text.of(this.value.trim());
    }

    public boolean startsWith(String prefix) {
        return this.value.startsWith(prefix);
    }

    public boolean startsWith(String prefix, int offset) {
        return this.value.startsWith(prefix, offset);
    }

    public boolean endsWith(String suffix) {
        return this.value.endsWith(suffix);
    }

    public boolean startsWith(Text prefix) {
        return this.value.startsWith(prefix.value);
    }

    public boolean startsWith(Text prefix, int offset) {
        return this.value.startsWith(prefix.value, offset);
    }

    public boolean endsWith(Text suffix) {
        return this.value.endsWith(suffix.value);
    }

    public String get() {
        return this.value;
    }

    public Text format(Object ... args) {
        return TextUtils.format(this.value, args);
    }

    public void send(ICommandSource ... receivers) {
        MessageUtils.send(this.compile(), receivers);
    }

    public IFormattableTextComponent compile() {
        return this.compile(true);
    }

    public IFormattableTextComponent compile(boolean ifEmptyAddSpace) {
        String value = this.value;
        if (ifEmptyAddSpace && this.value.isEmpty()) {
            value = " ";
        }
        if (this.raw) {
            return new StringTextComponent(value);
        }
        return TextUtils.colorize(value);
    }

    public Text copy() {
        return Text.of(this.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Text) {
            return this.value.equals(((Text)obj).value);
        }
        return this.value.equals(obj);
    }

    @Override
    public int length() {
        return this.value.length();
    }

    @Override
    public char charAt(int index) {
        return this.value.charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.value.subSequence(start, end);
    }

    @Override
    public String toString() {
        return this.value;
    }

    @Override
    public IntStream chars() {
        return this.value.chars();
    }

    @Override
    public IntStream codePoints() {
        return this.value.codePoints();
    }

    @Override
    public int compareTo(Text text) {
        return this.value.compareTo(text.value);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final StringBuilder text = new StringBuilder();

        public <T> Builder append(T text) {
            this.text.append(TextUtils.asText(text).get());
            return this;
        }

        public Builder style(TextFormatting ... styles) {
            for (TextFormatting style : styles) {
                this.append("&").append(style.toString().substring(1).toUpperCase(Locale.ROOT));
            }
            return this;
        }

        public Builder color(Color color, TextFormatting ... styles) {
            return this.append("&").append("#").append(String.format("%06X", 0xFFFFFF & color.getRGB())).styleSet(styles);
        }

        public Builder gradient(Color from, Color to, TextFormatting ... styles) {
            return this.append("&").append("#").append("@").append(String.format("%06X", 0xFFFFFF & from.getRGB())).append("-").append(String.format("%06X", 0xFFFFFF & to.getRGB())).styleSet(styles);
        }

        private Builder styleSet(TextFormatting ... styles) {
            if (styles.length > 0) {
                this.append("[");
                for (TextFormatting style : styles) {
                    this.append(style.toString().substring(1).toUpperCase(Locale.ROOT));
                }
                this.append("]");
            }
            return this;
        }

        public Text build() {
            return this.build(false);
        }

        public Text build(boolean immutable) {
            return immutable ? new Immutable(this.text.toString()) : new Text(this.text.toString());
        }
    }

    public static class Immutable
    extends Text {
        protected Immutable(String value) {
            super(value);
        }

        public static Immutable of(String string) {
            return new Immutable(string);
        }

        public static Immutable of(ITextComponent component) {
            return Immutable.of(component.getString());
        }

        public static Immutable empty() {
            return new Immutable("");
        }

        @Override
        public Text raw() {
            Text copy = this.copy();
            copy.raw = true;
            return copy;
        }

        @Override
        public Text compiled() {
            Text copy = this.copy();
            copy.raw = false;
            return copy;
        }

        @Override
        public Text set(String string) {
            return Immutable.of(string);
        }

        @Override
        public Text clear() {
            return Immutable.empty();
        }

        @Override
        public Text append(Object string) {
            return Immutable.of(this.get() + string);
        }

        @Override
        public Text prepend(Object string) {
            return Immutable.of(string + this.get());
        }

        @Override
        public Text set(Text string) {
            return this.set(string.get());
        }

        @Override
        public Text append(Text string) {
            return this.append(string.get());
        }

        @Override
        public Text prepend(Text string) {
            return this.prepend(string.get());
        }

        public static class TypeAdapter
        implements JsonSerializer<Immutable>,
        JsonDeserializer<Immutable> {
            public Immutable deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                return Immutable.of(json.getAsJsonPrimitive().getAsString());
            }

            public JsonElement serialize(Immutable src, Type typeOfSrc, JsonSerializationContext context) {
                return new JsonPrimitive(src.toString());
            }
        }
    }

    public static class TypeAdapter
    implements JsonSerializer<Text>,
    JsonDeserializer<Text> {
        public Text deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return Text.of(json.getAsJsonPrimitive().getAsString());
        }

        public JsonElement serialize(Text src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(src.toString());
        }
    }
}

