/*
 * Decompiled with CFR 0.152.
 */
package de.waterdu.atlantis.util.text;

import de.waterdu.atlantis.file.datatypes.PlayerData;
import de.waterdu.atlantis.util.entity.PermissionUtils;
import de.waterdu.atlantis.util.entity.PlayerReference;
import de.waterdu.atlantis.util.java.ExceptionUtils;
import de.waterdu.atlantis.util.text.TextUtils;
import java.util.Collection;
import java.util.function.Predicate;
import net.minecraft.command.CommandSource;
import net.minecraft.command.ICommandSource;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.Util;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class MessageUtils {
    private MessageUtils() {
        ExceptionUtils.throwCannotInstantiateClassException();
    }

    public static <T> void send(T message, CommandSource ... recipients) {
        if (message != null) {
            IFormattableTextComponent component = TextUtils.asComponent(message);
            for (CommandSource recipient : recipients) {
                recipient.func_197030_a((ITextComponent)component, false);
            }
        }
    }

    public static <T> void send(T message, ICommandSource ... recipients) {
        if (message != null) {
            IFormattableTextComponent component = TextUtils.asComponent(message);
            for (ICommandSource recipient : recipients) {
                recipient.func_145747_a((ITextComponent)component, Util.field_240973_b_);
            }
        }
    }

    public static <T> void send(T message, PlayerData ... recipients) {
        if (message != null) {
            IFormattableTextComponent component = TextUtils.asComponent(message);
            for (PlayerData recipient : recipients) {
                recipient.getPlayerEntitySafely().ifPresent(player -> player.func_145747_a((ITextComponent)component, Util.field_240973_b_));
            }
        }
    }

    public static <T> void send(T message, PlayerReference ... recipients) {
        if (message != null) {
            IFormattableTextComponent component = TextUtils.asComponent(message);
            for (PlayerReference recipient : recipients) {
                recipient.entity().ifPresent(player -> player.func_145747_a((ITextComponent)component, Util.field_240973_b_));
            }
        }
    }

    public static <T> void send(T message, Collection<PlayerReference> recipients) {
        if (message != null) {
            IFormattableTextComponent component = TextUtils.asComponent(message);
            for (PlayerReference recipient : recipients) {
                recipient.entity().ifPresent(player -> player.func_145747_a((ITextComponent)component, Util.field_240973_b_));
            }
        }
    }

    public static <T> void sendToAllWithPerm(T message, String permission) {
        if (message != null) {
            IFormattableTextComponent component = TextUtils.asComponent(message);
            for (ServerPlayerEntity player : ServerLifecycleHooks.getCurrentServer().func_184103_al().func_181057_v()) {
                if (!PermissionUtils.hasPermission((PlayerEntity)player, permission)) continue;
                player.func_145747_a((ITextComponent)component, Util.field_240973_b_);
            }
        }
    }

    public static <T> void sendToAll(T message) {
        if (message != null) {
            IFormattableTextComponent component = TextUtils.asComponent(message);
            for (ServerPlayerEntity player : ServerLifecycleHooks.getCurrentServer().func_184103_al().func_181057_v()) {
                player.func_145747_a((ITextComponent)component, Util.field_240973_b_);
            }
        }
    }

    public static <T> void sendToAllExcept(T message, Predicate<ServerPlayerEntity> predicate) {
        if (message != null) {
            IFormattableTextComponent component = TextUtils.asComponent(message);
            for (ServerPlayerEntity player : ServerLifecycleHooks.getCurrentServer().func_184103_al().func_181057_v()) {
                if (predicate.test(player)) continue;
                player.func_145747_a((ITextComponent)component, Util.field_240973_b_);
            }
        }
    }

    public static <T> void sendToMatching(T message, Predicate<ServerPlayerEntity> predicate) {
        if (message != null) {
            IFormattableTextComponent component = TextUtils.asComponent(message);
            for (ServerPlayerEntity player : ServerLifecycleHooks.getCurrentServer().func_184103_al().func_181057_v()) {
                if (!predicate.test(player)) continue;
                player.func_145747_a((ITextComponent)component, Util.field_240973_b_);
            }
        }
    }
}

