/*
 * Decompiled with CFR 0.152.
 */
package de.waterdu.atlantis.util.text;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;

public class IncompleteString {
    private final String[] strings;
    private final boolean[] order;
    private final boolean wrapper;

    private IncompleteString(String[] strings, boolean[] order) {
        this.strings = strings;
        this.order = order;
        this.wrapper = order == null;
    }

    public IncompleteString copy() {
        if (this.wrapper) {
            return new IncompleteString(new String[]{this.strings[0]}, null);
        }
        String[] strings = new String[this.strings.length];
        boolean[] order = new boolean[this.order.length];
        System.arraycopy(this.strings, 0, strings, 0, this.strings.length);
        System.arraycopy(this.order, 0, order, 0, this.order.length);
        return new IncompleteString(strings, order);
    }

    public IncompleteString replace(CharSequence target, CharSequence replacement) {
        for (int i = 0; i < this.strings.length; ++i) {
            this.strings[i] = this.strings[i].replace(target, replacement);
        }
        return this;
    }

    public IncompleteString replace(String target, IncompleteString replacement) {
        Builder builder = IncompleteString.builder();
        if (this.wrapper) {
            String[] split2 = this.strings[0].split(target, -1);
            if (split2.length == 2) {
                builder.string(split2[0]).merge(replacement).string(split2[1]);
            } else {
                builder.string(this.strings[0]);
            }
        } else {
            int i = 0;
            for (boolean order : this.order) {
                if (order) {
                    String[] split3 = this.strings[i].split(target, -1);
                    if (split3.length == 2) {
                        builder.string(split3[0]).merge(replacement).string(split3[1]);
                    } else {
                        builder.string(this.strings[i]);
                    }
                    ++i;
                    continue;
                }
                builder.placeholder();
            }
        }
        return builder.build();
    }

    public String complete(String ... placeholders) {
        if (this.wrapper) {
            return this.strings[0];
        }
        StringBuilder builder = new StringBuilder();
        int a = 0;
        int b = 0;
        for (boolean order : this.order) {
            if (order) {
                builder.append(this.strings[a++]);
                continue;
            }
            if (placeholders.length <= b) continue;
            builder.append(placeholders[b++]);
        }
        return builder.toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static IncompleteString of(String string) {
        return new IncompleteString(new String[]{string}, null);
    }

    public static class Builder {
        private final List<String> strings = Lists.newArrayList();
        private int count = 0;

        private Builder() {
        }

        public boolean isEmpty() {
            return this.strings.isEmpty();
        }

        public Builder placeholder() {
            this.strings.add(null);
            return this;
        }

        public Builder string(String string) {
            this.strings.add(Objects.requireNonNull(string));
            ++this.count;
            return this;
        }

        public Builder append(char c) {
            return this.append(String.valueOf(c));
        }

        public Builder append(String string) {
            if (this.isEmpty()) {
                this.string(string);
            } else {
                int i = this.strings.size() - 1;
                String s = this.strings.get(i);
                if (s == null) {
                    this.string(string);
                } else {
                    this.strings.set(i, s + string);
                }
            }
            return this;
        }

        public Builder merge(IncompleteString string) {
            if (string.order == null) {
                this.string(string.strings[0]);
            } else {
                int i = 0;
                for (boolean order : string.order) {
                    if (order) {
                        this.string(string.strings[i++]);
                        continue;
                    }
                    this.placeholder();
                }
            }
            return this;
        }

        public IncompleteString build() {
            String[] strings = new String[this.count];
            boolean[] order = new boolean[this.strings.size()];
            if (this.strings.size() == 1 && this.strings.get(0) != null) {
                return IncompleteString.of(this.strings.get(0));
            }
            int s = 0;
            for (int i = 0; i < order.length; ++i) {
                String string = this.strings.get(i);
                if (string == null) {
                    order[i] = false;
                    continue;
                }
                order[i] = true;
                strings[s++] = string;
            }
            return new IncompleteString(strings, order);
        }
    }
}

