/*
 * Decompiled with CFR 0.152.
 */
package de.waterdu.atlantis.util.server;

import com.google.common.collect.Lists;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.waterdu.atlantis.util.java.ExceptionUtils;
import de.waterdu.atlantis.util.level.LazyLevel;
import de.waterdu.atlantis.util.level.LevelPosition;
import de.waterdu.atlantis.util.level.Position;
import de.waterdu.atlantis.util.text.TextUtils;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.command.CommandSource;
import net.minecraft.command.arguments.EntitySelectorParser;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.MutableRegistry;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class ServerUtils {
    private ServerUtils() {
        ExceptionUtils.throwCannotInstantiateClassException();
    }

    public static MinecraftServer getServer() {
        return ServerLifecycleHooks.getCurrentServer();
    }

    public static DynamicRegistries registries() {
        return ServerUtils.getServer().func_244267_aX();
    }

    public static <T> MutableRegistry<T> registry(RegistryKey<Registry<T>> key) {
        return ServerUtils.registries().func_243612_b(key);
    }

    public static <T> ResourceLocation key(RegistryKey<Registry<T>> key, T instance) {
        return ServerUtils.registry(key).func_177774_c(instance);
    }

    public static List<ServerPlayerEntity> getPlayers() {
        return ServerUtils.getServer().func_184103_al().func_181057_v();
    }

    public static void forEachPlayer(Consumer<ServerPlayerEntity> forEach) {
        for (ServerPlayerEntity player : ServerUtils.getPlayers()) {
            forEach.accept(player);
        }
    }

    public static Optional<ServerPlayerEntity> getPlayer(UUID uuid) {
        return Optional.ofNullable(ServerUtils.getServer().func_184103_al().func_177451_a(uuid));
    }

    public static Optional<ServerPlayerEntity> getPlayer(String name) {
        return Optional.ofNullable(ServerUtils.getServer().func_184103_al().func_152612_a(name));
    }

    public static void parsePlayersOrElse(CommandSource source, String getterString, Consumer<List<ServerPlayerEntity>> success, Runnable failure) throws CommandSyntaxException {
        List players;
        if (getterString.contains("@")) {
            players = new EntitySelectorParser(new StringReader(getterString)).func_201345_m().func_197342_d(source);
        } else {
            players = Lists.newArrayList();
            ServerPlayerEntity target = ServerLifecycleHooks.getCurrentServer().func_184103_al().func_152612_a(getterString);
            if (target != null) {
                players.add(target);
            }
        }
        if (!players.isEmpty()) {
            success.accept(players);
        } else {
            failure.run();
        }
    }

    public static List<String> getPlayerNames() {
        return Lists.newArrayList((Object[])ServerUtils.getServer().func_71213_z());
    }

    public static int performCommand(String command, Object ... args) {
        MinecraftServer server = ServerUtils.getServer();
        return server.func_195571_aL().func_197059_a(server.func_195573_aM(), TextUtils.format(command, args).get());
    }

    public static LevelPosition getSpawnPoint() {
        ServerWorld overworld = ServerUtils.getServer().func_241755_D_();
        return new LevelPosition(LazyLevel.of((World)overworld), new Position(overworld.func_241135_u_()));
    }
}

