/*
 * Decompiled with CFR 0.152.
 */
package de.waterdu.atlantis.util.placeholder.impl;

import com.envyful.papi.api.PlaceholderFactory;
import com.envyful.papi.api.manager.AbstractPlaceholderManager;
import com.envyful.papi.api.manager.extensions.PlaceholderExtension;
import com.envyful.papi.api.util.UtilPlaceholder;
import com.google.common.collect.Maps;
import de.waterdu.atlantis.Atlantis;
import de.waterdu.atlantis.util.placeholder.AtlantisPlaceholderExtension;
import de.waterdu.atlantis.util.placeholder.impl.PlaceholderProvider;
import de.waterdu.atlantis.util.text.Text;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class FPAPI
implements PlaceholderProvider {
    private final Map<Class<?>, Map<String, Impl<?>>> impl = Maps.newHashMap();

    @Override
    public <T> void register(String id, String name, AtlantisPlaceholderExtension<T> extension, Class<T> type) {
        this.impl.computeIfAbsent(type, t -> Maps.newHashMap()).computeIfAbsent(id, i -> {
            Impl newImpl = new Impl(id, name, type);
            PlaceholderFactory.register(newImpl);
            return newImpl;
        }).registerPlaceholder(new ExtensionImpl<T>(extension));
    }

    @Override
    public <T> Text replace(T object, Text text) {
        return Text.of(UtilPlaceholder.replaceIdentifiers(object, (String)text.get()));
    }

    @Override
    public Text replace(UUID uuid, Text text) {
        return Text.of(UtilPlaceholder.replaceIdentifiers((UUID)uuid, (String)text.get()));
    }

    private static class Impl<T>
    extends AbstractPlaceholderManager<T> {
        public Impl(String id, String name, Class<T> type) {
            super(id, Atlantis.WATERDUDE_NAME_AS_ARRAY, "6.6.3", name, type);
        }
    }

    private static class ExtensionImpl<T>
    implements PlaceholderExtension<T> {
        private final AtlantisPlaceholderExtension<T> impl;

        public ExtensionImpl(AtlantisPlaceholderExtension<T> impl) {
            this.impl = impl;
        }

        public String getName() {
            return this.impl.name();
        }

        public int getPriority() {
            return this.impl.priority();
        }

        public List<String> getDescription() {
            return this.impl.description();
        }

        public List<String> getExamples() {
            return this.impl.examples();
        }

        public boolean matches(T object, String placeholder) {
            return this.impl.matches(object, placeholder);
        }

        public boolean matchesObject(Object object, String placeholder) {
            return this.impl.matchesObject(object, placeholder);
        }

        public String parse(T object, String placeholder) {
            return this.impl.parse(object, placeholder);
        }

        public String parseObject(Object object, String placeholder) {
            return this.impl.parseObject(object, placeholder);
        }
    }
}

