/*
 * Decompiled with CFR 0.152.
 */
package de.waterdu.atlantis.util.placeholder;

import com.google.common.collect.Lists;
import de.waterdu.atlantis.Atlantis;
import de.waterdu.atlantis.meta.SetPlaceholderProviderEvent;
import de.waterdu.atlantis.util.java.ExceptionUtils;
import de.waterdu.atlantis.util.java.ReflectionUtils;
import de.waterdu.atlantis.util.placeholder.AtlantisPlaceholderExtension;
import de.waterdu.atlantis.util.placeholder.impl.FPAPI;
import de.waterdu.atlantis.util.placeholder.impl.NoProvider;
import de.waterdu.atlantis.util.placeholder.impl.PlaceholderProvider;
import de.waterdu.atlantis.util.text.Text;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraftforge.eventbus.api.Event;

public class AtlantisPlaceholderProxy {
    private static final AtomicReference<PlaceholderProvider> PROVIDER = new AtomicReference<PlaceholderProvider>(NoProvider.INSTANCE);
    private static final List<PlaceholderProvider> PROVIDERS = Lists.newArrayList();

    private AtlantisPlaceholderProxy() {
        ExceptionUtils.throwCannotInstantiateClassException();
    }

    public static void bootstrap() {
        block0: {
            Iterator<PlaceholderProvider> iterator = PROVIDERS.iterator();
            if (!iterator.hasNext()) break block0;
            PlaceholderProvider provider = iterator.next();
            AtlantisPlaceholderProxy.setProvider(provider);
        }
    }

    public static void addPlaceholderProvider(PlaceholderProvider provider) {
        PROVIDERS.add(provider);
    }

    public static void setProvider(PlaceholderProvider provider) {
        SetPlaceholderProviderEvent event = new SetPlaceholderProviderEvent(provider);
        Atlantis.EVENT_BUS.post((Event)event);
        PROVIDER.set(event.getProvider());
    }

    public static <T> void register(String id, String name, AtlantisPlaceholderExtension<T> extension, Class<T> type) {
        PROVIDER.get().register(id, name, extension, type);
    }

    public static <T> Text replace(T object, Text text) {
        return PROVIDER.get().replace(object, text);
    }

    public static Text replace(UUID uuid, Text text) {
        return PROVIDER.get().replace(uuid, text);
    }

    static {
        if (ReflectionUtils.doesClassExist("com.envyful.papi.forge.ForgePlaceholderAPI")) {
            AtlantisPlaceholderProxy.addPlaceholderProvider(new FPAPI());
        }
        AtlantisPlaceholderProxy.bootstrap();
    }
}

