/*
 * Decompiled with CFR 0.152.
 */
package de.waterdu.atlantis.util.network;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import de.waterdu.atlantis.util.entity.PlayerReference;
import de.waterdu.atlantis.util.java.ExceptionUtils;
import java.net.SocketAddress;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.entity.player.ServerPlayerEntity;

public class NetworkUtils {
    private static final Set<PlayerReference> EMPTY_SET = Sets.newHashSet();
    private static final Map<PlayerReference, Optional<SocketAddress>> ADDRESS_MAP = Maps.newHashMap();
    private static final Map<PlayerReference, Optional<String>> IP_MAP = Maps.newHashMap();
    private static final Map<SocketAddress, Set<PlayerReference>> INVERSE_ADDRESS_MAP = Maps.newHashMap();
    private static final Map<String, Set<PlayerReference>> INVERSE_IP_MAP = Maps.newHashMap();

    private NetworkUtils() {
        ExceptionUtils.throwCannotInstantiateClassException();
    }

    public static void addAddress(ServerPlayerEntity player) {
        PlayerReference reference = PlayerReference.get(player);
        SocketAddress address = player.field_71135_a.func_147298_b().func_74430_c();
        Optional<SocketAddress> optionalAddress = Optional.of(address);
        String ip = NetworkUtils.addressToIP(address);
        Optional<String> optionalIP = Optional.of(ip);
        ADDRESS_MAP.put(reference, optionalAddress);
        INVERSE_ADDRESS_MAP.computeIfAbsent(address, k -> Sets.newHashSet()).add(reference);
        IP_MAP.put(reference, optionalIP);
        INVERSE_IP_MAP.computeIfAbsent(ip, k -> Sets.newHashSet()).add(reference);
    }

    public static <T extends SocketAddress> Optional<T> address(PlayerReference reference) {
        return ADDRESS_MAP.getOrDefault(reference, Optional.empty());
    }

    public static Optional<String> ip(PlayerReference reference) {
        return IP_MAP.getOrDefault(reference, Optional.empty());
    }

    public static Set<PlayerReference> player(SocketAddress address) {
        return INVERSE_ADDRESS_MAP.getOrDefault(address, EMPTY_SET);
    }

    public static Set<PlayerReference> player(String ip) {
        return INVERSE_IP_MAP.getOrDefault(ip, EMPTY_SET);
    }

    public static String addressToIP(SocketAddress address) {
        String s = address.toString();
        s = s.substring(s.indexOf("/") + 1);
        return s.substring(0, s.indexOf(":"));
    }
}

