/*
 * Decompiled with CFR 0.152.
 */
package de.waterdu.atlantis.util.level;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import de.waterdu.atlantis.util.java.RandomUtils;
import de.waterdu.atlantis.util.level.LazyLevel;
import java.lang.reflect.Type;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class Position
extends Vector3d {
    private static final Position ZERO = new Position();
    private final float[] rotation = new float[]{0.0f, 0.0f};

    public Position() {
        this(0.0, 0.0, 0.0);
    }

    protected Position(double x, double y, double z, float[] rotation) {
        super(x, y, z);
        this.rotation[0] = rotation[0];
        this.rotation[1] = rotation[1];
    }

    public Position(double x, double y, double z, float xRot, float yRot) {
        super(x, y, z);
        this.rotation[0] = xRot;
        this.rotation[1] = yRot;
    }

    public Position(BlockPos pos) {
        this(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), 0.0f, 0.0f);
    }

    public Position(BlockPos pos, float xRot, float yRot) {
        this(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), xRot, yRot);
    }

    public Position(double x, double y, double z) {
        this(x, y, z, 0.0f, 0.0f);
    }

    public Position(Entity entity) {
        this(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), entity.field_70125_A, entity.field_70177_z);
    }

    public static Position zero() {
        return ZERO;
    }

    public float xRot() {
        return this.rotation[0];
    }

    public float yRot() {
        return this.rotation[1];
    }

    public Position setX(double x) {
        return new Position(x, this.field_72448_b, this.field_72449_c, this.rotation);
    }

    public Position setY(double y) {
        return new Position(this.field_72450_a, y, this.field_72449_c, this.rotation);
    }

    public Position setZ(double z) {
        return new Position(this.field_72450_a, this.field_72448_b, z, this.rotation);
    }

    public Position setXRot(float xRot) {
        return new Position(this.field_72450_a, this.field_72448_b, this.field_72449_c, xRot, this.rotation[1]);
    }

    public Position setYRot(float yRot) {
        return new Position(this.field_72450_a, this.field_72448_b, this.field_72449_c, this.rotation[0], yRot);
    }

    public boolean hasRotation() {
        return this.rotation[0] != 0.0f || this.rotation[1] != 0.0f;
    }

    public Position randomize() {
        return this.randomize(1.0);
    }

    public Position randomize(double factor) {
        double doubleFactor = factor + factor;
        return new Position(RandomUtils.getRandom().nextDouble() * doubleFactor * this.field_72450_a - this.field_72450_a * factor, RandomUtils.getRandom().nextDouble() * doubleFactor * this.field_72448_b - this.field_72448_b * factor, RandomUtils.getRandom().nextDouble() * doubleFactor * this.field_72449_c - this.field_72449_c * factor, this.xRot(), this.yRot());
    }

    public BlockPos getBlockPos() {
        return new BlockPos(this.field_72450_a, this.field_72448_b, this.field_72449_c);
    }

    public void teleport(Entity entity) {
        this.teleport(entity, entity.field_70170_p);
    }

    public void teleport(Entity entity, boolean ignoreRotation) {
        this.teleport(entity, entity.field_70170_p, ignoreRotation);
    }

    public void teleport(Entity entity, LazyLevel level) {
        this.teleport(entity, level, false);
    }

    public void teleport(Entity entity, LazyLevel level, boolean ignoreRotation) {
        this.teleport(entity, (World)level.getLevel(), ignoreRotation);
    }

    public void teleport(Entity entity, World level) {
        this.teleport(entity, level, false);
    }

    public void teleport(Entity entity, World level, boolean ignoreRotation) {
        if (level instanceof ServerWorld) {
            ServerWorld serverLevel = (ServerWorld)level;
            if (!ignoreRotation) {
                entity.field_70125_A = this.rotation[0];
                entity.field_70177_z = this.rotation[1];
            }
            if (entity instanceof ServerPlayerEntity) {
                ServerPlayerEntity player = (ServerPlayerEntity)entity;
                player.func_200619_a(serverLevel, this.field_72450_a, this.field_72448_b, this.field_72449_c, entity.field_70125_A, entity.field_70177_z);
            } else {
                entity.func_70634_a(this.field_72450_a, this.field_72448_b, this.field_72449_c);
                if (!entity.field_70170_p.equals(level)) {
                    entity.func_241206_a_(serverLevel);
                    entity.func_223102_j(this.field_72450_a, this.field_72448_b, this.field_72449_c);
                }
            }
        }
    }

    public Position add(double x, double y, double z) {
        return new Position(this.field_72450_a + x, this.field_72448_b + y, this.field_72449_c + z, this.rotation);
    }

    public Position add(Position position) {
        return this.add(position.field_72450_a, position.field_72448_b, position.field_72449_c);
    }

    public Position move(Direction direction) {
        return this.move(direction, 1.0);
    }

    public Position move(Direction direction, double distance) {
        return this.add((double)direction.func_82601_c() * distance, (double)direction.func_96559_d() * distance, (double)direction.func_82599_e() * distance);
    }

    public Position rotate(float xRot, float yRot) {
        return new Position(this.field_72450_a, this.field_72448_b, this.field_72449_c, this.rotation[0] + xRot, this.rotation[1] + yRot);
    }

    public double getDX(double x) {
        return x - this.field_72450_a;
    }

    public double getDY(double y) {
        return y - this.field_72448_b;
    }

    public double getDZ(double z) {
        return z - this.field_72449_c;
    }

    public boolean equals(Object object) {
        if (object instanceof Vector3i) {
            Vector3i vec = (Vector3i)object;
            return this.func_82615_a() == (double)vec.func_177958_n() && this.func_82617_b() == (double)vec.func_177956_o() && this.func_82616_c() == (double)vec.func_177952_p();
        }
        if (object instanceof Vector3f) {
            Vector3f vec = (Vector3f)object;
            return this.func_82615_a() == (double)vec.func_195899_a() && this.func_82617_b() == (double)vec.func_195900_b() && this.func_82616_c() == (double)vec.func_195902_c();
        }
        if (object instanceof Position) {
            Position pos = (Position)((Object)object);
            return this.func_82615_a() == pos.func_82615_a() && this.func_82617_b() == pos.func_82617_b() && this.func_82616_c() == pos.func_82616_c() && this.xRot() == pos.xRot() && this.yRot() == pos.yRot();
        }
        return super.equals(object);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return super.toString();
    }

    public static class TypeAdapter
    implements JsonSerializer<Position>,
    JsonDeserializer<Position> {
        public Position deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject object = json.getAsJsonObject();
            Position position = new Position(object.get("x").getAsDouble(), object.get("y").getAsDouble(), object.get("z").getAsDouble());
            if (object.has("xRot")) {
                ((Position)position).rotation[0] = object.get("xRot").getAsFloat();
            }
            if (object.has("yRot")) {
                ((Position)position).rotation[1] = object.get("yRot").getAsFloat();
            }
            return position;
        }

        public JsonElement serialize(Position src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject object = new JsonObject();
            object.addProperty("x", (Number)src.field_72450_a);
            object.addProperty("y", (Number)src.field_72448_b);
            object.addProperty("z", (Number)src.field_72449_c);
            if (src.hasRotation()) {
                object.addProperty("xRot", (Number)Float.valueOf(src.rotation[0]));
                object.addProperty("yRot", (Number)Float.valueOf(src.rotation[1]));
            }
            return object;
        }
    }
}

