/*
 * Decompiled with CFR 0.152.
 */
package de.waterdu.atlantis.util.level;

import com.google.common.collect.Lists;
import de.waterdu.atlantis.util.java.ExceptionUtils;
import de.waterdu.atlantis.util.server.ServerUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class LevelUtils {
    private LevelUtils() {
        ExceptionUtils.throwCannotInstantiateClassException();
    }

    public static ServerWorld overworld() {
        return ServerUtils.getServer().func_241755_D_();
    }

    public static RegistryKey<World> dimension(String dimension) {
        if (dimension.isEmpty()) {
            return null;
        }
        return LevelUtils.dimension(new ResourceLocation(dimension));
    }

    public static RegistryKey<World> dimension(ResourceLocation key) {
        return RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)key);
    }

    public static Optional<ServerWorld> level(RegistryKey<World> key) {
        return Optional.ofNullable(ServerLifecycleHooks.getCurrentServer().func_71218_a(key));
    }

    public static Optional<ServerWorld> level(String key) {
        return LevelUtils.level(LevelUtils.dimension(key));
    }

    public static List<ServerWorld> levels() {
        ArrayList levels = Lists.newArrayList();
        for (ServerWorld level : ServerLifecycleHooks.getCurrentServer().func_212370_w()) {
            levels.add(level);
        }
        return levels;
    }

    public static List<String> levelIDs() {
        ArrayList levels = Lists.newArrayList();
        for (World world : LevelUtils.levels()) {
            levels.add(world.func_234923_W_().func_240901_a_().toString());
        }
        return levels;
    }
}

