/*
 * Decompiled with CFR 0.152.
 */
package de.waterdu.atlantis.util.level;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import de.waterdu.atlantis.util.entity.PlayerReference;
import de.waterdu.atlantis.util.level.LazyLevel;
import de.waterdu.atlantis.util.level.Position;
import java.lang.reflect.Type;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class LevelPosition {
    private final LazyLevel level;
    private final Position position;

    public LevelPosition(LazyLevel level, Position position) {
        this.level = level;
        this.position = position;
    }

    public LevelPosition(Entity entity) {
        this(LazyLevel.of(entity.field_70170_p), new Position(entity));
    }

    public ServerWorld level() {
        return this.level.getLevel();
    }

    public Position position() {
        return this.position;
    }

    public double x() {
        return this.position.func_82615_a();
    }

    public double y() {
        return this.position.func_82617_b();
    }

    public double z() {
        return this.position.func_82616_c();
    }

    public float xRot() {
        return this.position.xRot();
    }

    public float yRot() {
        return this.position.yRot();
    }

    public <E extends Entity> Optional<E> createEntity(EntityType<E> type) {
        Entity entity = type.func_200721_a((World)this.level());
        if (entity == null) {
            return Optional.empty();
        }
        entity.func_70080_a(this.x(), this.y(), this.z(), this.yRot(), this.xRot());
        return Optional.of(entity);
    }

    public void sound(SoundEvent sound) {
        this.sound(sound, SoundCategory.MASTER);
    }

    public void sound(SoundEvent sound, float volume, float pitch) {
        this.sound(sound, SoundCategory.MASTER, volume, pitch);
    }

    public void sound(SoundEvent sound, SoundCategory category) {
        this.sound(sound, category, 1.0f, 1.0f);
    }

    public void sound(SoundEvent sound, SoundCategory category, float volume, float pitch) {
        this.level().func_184148_a(null, this.position().func_82615_a(), this.position().func_82617_b(), this.position().func_82616_c(), sound, category, volume, pitch);
    }

    public void teleport(PlayerReference reference) {
        this.teleport(reference.entity());
    }

    public void teleport(Optional<? extends Entity> entity) {
        entity.ifPresent(this::teleport);
    }

    public void teleport(Entity entity) {
        this.position.teleport(entity, this.level);
    }

    public static class TypeAdapter
    implements JsonSerializer<LevelPosition>,
    JsonDeserializer<LevelPosition> {
        public LevelPosition deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject object = json.getAsJsonObject();
            return new LevelPosition((LazyLevel)context.deserialize(object.get("level"), LazyLevel.class), (Position)((Object)context.deserialize(object.get("position"), Position.class)));
        }

        public JsonElement serialize(LevelPosition src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject object = new JsonObject();
            object.add("level", context.serialize((Object)src.level));
            object.add("position", context.serialize((Object)src.position));
            return object;
        }
    }
}

