/*
 * Decompiled with CFR 0.152.
 */
package de.waterdu.atlantis.util.level;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import de.waterdu.atlantis.util.level.LevelUtils;
import java.lang.reflect.Type;
import net.minecraft.entity.Entity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class LazyLevel {
    private final RegistryKey<World> key;
    private ServerWorld level = null;

    public LazyLevel(String key) {
        this.key = LevelUtils.dimension(key);
    }

    public static LazyLevel of(String key) {
        return new LazyLevel(key);
    }

    public static LazyLevel of(String mod, String key) {
        return new LazyLevel(mod + ":" + key);
    }

    public static LazyLevel of(ResourceLocation location) {
        return LazyLevel.of(location.toString());
    }

    public static LazyLevel of(RegistryKey<World> level) {
        return LazyLevel.of(level.func_240901_a_());
    }

    public static LazyLevel of(World level) {
        return LazyLevel.of((RegistryKey<World>)level.func_234923_W_());
    }

    public RegistryKey<World> getKey() {
        return this.key;
    }

    public ServerWorld getLevel() {
        if (this.level == null) {
            this.level = LevelUtils.level(this.key).orElse(null);
        }
        return this.level;
    }

    public boolean contains(Entity entity) {
        return this.equals(entity.field_70170_p);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof World) {
            return ((World)obj).func_234923_W_().compareTo(this.key) == 0;
        }
        if (obj instanceof RegistryKey) {
            return ((RegistryKey)obj).compareTo(this.key) == 0;
        }
        if (obj instanceof LazyLevel) {
            return ((LazyLevel)obj).getKey().compareTo(this.key) == 0;
        }
        return false;
    }

    public String toString() {
        return this.key.func_240901_a_().toString();
    }

    public static class TypeAdapter
    implements JsonSerializer<LazyLevel>,
    JsonDeserializer<LazyLevel> {
        public LazyLevel deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return new LazyLevel(json.getAsString());
        }

        public JsonElement serialize(LazyLevel src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(src.getKey().func_240901_a_().toString());
        }
    }
}

