/*
 * Decompiled with CFR 0.152.
 */
package de.waterdu.atlantis.util.java.math;

import com.google.common.collect.Lists;
import de.waterdu.atlantis.util.java.math.Comparator;
import de.waterdu.atlantis.util.java.math.Comparators;
import de.waterdu.atlantis.util.java.math.Operator;
import de.waterdu.atlantis.util.java.math.Operators;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Variable {
    private double startingValue = 0.0;
    private List<Operator> operators = Lists.newArrayList();
    private Comparator comparator = null;

    public Variable(String formula) {
        boolean modified = false;
        while (!formula.isEmpty()) {
            if (formula.contains("(")) {
                String name = formula.substring(0, formula.indexOf("("));
                Operators operator = Operators.get(name);
                formula = formula.substring(formula.indexOf("("));
                formula = formula.replace("(", "").replace(")", "");
                this.operators.add(new Operator(operator, formula));
                formula = "";
                continue;
            }
            if (formula.contains("?")) {
                Comparators comparator = Comparators.find(formula);
                String[] split2 = formula.split("\\?");
                String[] splitLHS = split2[0].split(comparator.getRepresentation());
                String[] splitRHS = split2[1].split(":");
                this.comparator = new Comparator(comparator, splitLHS[0], splitLHS[1], splitRHS[0], splitRHS[1]);
                formula = "";
                continue;
            }
            if (formula.contains("RAND") || formula.contains("rand")) {
                modified = true;
                this.operators.add(new Operator(Operators.RAND, "0"));
                formula = formula.replace("RAND", "").replace("rand", "");
                continue;
            }
            ArrayList<String> symbols = new ArrayList<String>();
            ArrayList<String> values = new ArrayList<String>();
            Pattern patternSymbols = Pattern.compile("[+\\-/*^%]");
            Matcher matcherSymbols = patternSymbols.matcher(formula);
            Pattern patternValues = Pattern.compile("[^+\\-/*^%]+");
            Matcher matcherValues = patternValues.matcher(formula);
            while (matcherSymbols.find()) {
                String s = matcherSymbols.group();
                if (s.isEmpty()) continue;
                symbols.add(s);
            }
            while (matcherValues.find()) {
                String v = matcherValues.group();
                if (v.isEmpty()) continue;
                values.add(v);
            }
            int symbolIndex = 0;
            int valueIndex = 0;
            for (String value : values) {
                if (!modified) {
                    this.operators.add(new Operator(Operators.ADD, (String)values.get(valueIndex++)));
                    modified = true;
                    continue;
                }
                this.operators.add(new Operator(Operators.get((String)symbols.get(symbolIndex++)), (String)values.get(valueIndex++)));
            }
            formula = "";
        }
    }

    public double getStartingValue() {
        return this.startingValue;
    }

    public void setStartingValue(double startingValue) {
        this.startingValue = startingValue;
    }

    public List<Operator> getOperators() {
        return this.operators;
    }

    public void setOperators(List<Operator> operators) {
        this.operators = operators;
    }

    public Comparator getComparator() {
        return this.comparator;
    }

    public void setComparator(Comparator comparator) {
        this.comparator = comparator;
    }

    public double calculate(Map<String, Double> variableMap) {
        double value = 0.0;
        if (this.comparator != null) {
            return this.comparator.evaluate(variableMap);
        }
        for (Operator operator : this.operators) {
            value = operator.calculate(value, variableMap);
        }
        return value;
    }
}

