/*
 * Decompiled with CFR 0.152.
 */
package de.waterdu.atlantis.util.java.math;

import de.waterdu.atlantis.util.java.RandomUtils;

public enum Operators {
    ADD("+", false),
    SUBTRACT("-", false),
    MULTIPLY("*", false),
    DIVIDE("/", false),
    POWER("^", false),
    MODULO("%", false),
    SQRT("SQRT", true),
    CBRT("CBRT", true),
    RAND("RAND", false),
    SIN("SIN", true),
    COS("COS", true),
    TAN("TAN", true),
    SINH("SINH", true),
    COSH("COSH", true),
    TANH("TANH", true),
    ASIN("ASIN", true),
    ACOS("ACOS", true),
    ATAN("ATAN", true),
    SPHERE("SPHERE", true);

    private final String representation;
    private final boolean bracketed;

    private Operators(String representation, boolean bracketed) {
        this.representation = representation;
        this.bracketed = bracketed;
    }

    public boolean matches(String representation) {
        return this.representation.equalsIgnoreCase(representation);
    }

    public boolean isBracketed() {
        return this.bracketed;
    }

    public double calculate(double currentValue, double operatorValue) {
        switch (this) {
            case ADD: {
                return currentValue + operatorValue;
            }
            case SUBTRACT: {
                return currentValue - operatorValue;
            }
            case MULTIPLY: {
                return currentValue * operatorValue;
            }
            case DIVIDE: {
                return currentValue / operatorValue;
            }
            case POWER: {
                return Math.pow(currentValue, operatorValue);
            }
            case MODULO: {
                return currentValue % operatorValue;
            }
            case SQRT: {
                return Math.sqrt(operatorValue);
            }
            case CBRT: {
                return Math.cbrt(operatorValue);
            }
            case RAND: {
                return RandomUtils.getRandom().nextDouble();
            }
            case SIN: {
                return Math.sin(operatorValue);
            }
            case COS: {
                return Math.cos(operatorValue);
            }
            case TAN: {
                return Math.tan(operatorValue);
            }
            case SINH: {
                return Math.sinh(operatorValue);
            }
            case COSH: {
                return Math.cosh(operatorValue);
            }
            case TANH: {
                return Math.tanh(operatorValue);
            }
            case ASIN: {
                return Math.asin(operatorValue);
            }
            case ACOS: {
                return Math.acos(operatorValue);
            }
            case ATAN: {
                return Math.atan(operatorValue);
            }
            case SPHERE: {
                if (operatorValue < 0.5) {
                    operatorValue *= 2.0;
                } else {
                    double toTake = (operatorValue *= 2.0) - 1.0;
                    operatorValue -= toTake * 2.0;
                }
                return operatorValue;
            }
        }
        return currentValue;
    }

    public static Operators get(String name) {
        for (Operators operator : Operators.values()) {
            if (operator.name().equalsIgnoreCase(name)) {
                return operator;
            }
            if (!operator.representation.equalsIgnoreCase(name)) continue;
            return operator;
        }
        return null;
    }
}

