/*
 * Decompiled with CFR 0.152.
 */
package de.waterdu.atlantis.util.java.math;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import de.waterdu.atlantis.util.java.JsonUtils;
import de.waterdu.atlantis.util.java.math.Constant;
import de.waterdu.atlantis.util.java.math.Variable;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public class Formula {
    private final Map<String, Variable> variables = new LinkedHashMap<String, Variable>();
    private final Collection<String> lines;

    public Formula(Collection<String> lines) {
        this.lines = lines;
        for (String segment : lines) {
            if (!(segment = segment.replace(" ", "")).contains("=")) continue;
            String[] equalsSplit = new String[]{segment.substring(0, segment.indexOf("=")), segment.substring(segment.indexOf("=") + 1)};
            String variable = equalsSplit[0];
            String formula = equalsSplit[1];
            this.variables.put(variable, new Variable(formula));
        }
    }

    public Map<String, Double> process(Map<String, Double> defaultVariables) {
        LinkedHashMap<String, Double> variableMap = new LinkedHashMap<String, Double>(defaultVariables);
        for (Constant constant : Constant.values()) {
            for (String representation : constant.getRepresentations()) {
                variableMap.put(representation, constant.getValue());
            }
        }
        for (Map.Entry entry : this.variables.entrySet()) {
            String name = String.valueOf(entry.getKey());
            double value = ((Variable)entry.getValue()).calculate(variableMap);
            variableMap.put(name, value);
        }
        return variableMap;
    }

    public Collection<String> getLines() {
        return this.lines;
    }

    public static class TypeAdapter
    implements JsonSerializer<Formula>,
    JsonDeserializer<Formula> {
        public Formula deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return new Formula(JsonUtils.deserializeList(json.getAsJsonArray(), JsonElement::getAsString));
        }

        public JsonElement serialize(Formula src, Type typeOfSrc, JsonSerializationContext context) {
            return JsonUtils.serializeList(src.getLines(), JsonPrimitive::new);
        }
    }
}

