/*
 * Decompiled with CFR 0.152.
 */
package de.waterdu.atlantis.util.java.math;

public enum Constant {
    PI(Math.PI, "pi", "\u03c0"),
    TAU(Math.PI * 2, "tau", "\u03c4"),
    E(Math.E, "e"),
    PHI(1.618033988749895, "phi", "\u03c6");

    private final double value;
    private final String[] representations;

    private Constant(double value, String ... representations) {
        this.value = value;
        this.representations = representations;
    }

    public double getValue() {
        return this.value;
    }

    public String[] getRepresentations() {
        return this.representations;
    }

    public static Constant get(String name) {
        for (Constant constant : Constant.values()) {
            for (String representation : constant.representations) {
                if (!representation.equalsIgnoreCase(name)) continue;
                return constant;
            }
        }
        return null;
    }
}

