/*
 * Decompiled with CFR 0.152.
 */
package de.waterdu.atlantis.util.java.math;

public enum Comparators {
    EQUAL("=="),
    GREATER_THAN_OR_EQUAL(">="),
    GREATER_THAN(">"),
    LESS_THAN_OR_EQUAL("<="),
    LESS_THAN("<"),
    NOT_EQUAL("!=");

    private final String representation;

    private Comparators(String representation) {
        this.representation = representation;
    }

    public String getRepresentation() {
        return this.representation;
    }

    public static Comparators find(String formula) {
        for (Comparators comparator : Comparators.values()) {
            if (!formula.contains(comparator.representation)) continue;
            return comparator;
        }
        return EQUAL;
    }

    public boolean matches(String representation) {
        return this.representation.equalsIgnoreCase(representation);
    }

    public double evaluate(double inA, double inB, double outT, double outF) {
        switch (this) {
            case EQUAL: {
                return inA == inB ? outT : outF;
            }
            case NOT_EQUAL: {
                return inA != inB ? outT : outF;
            }
            case LESS_THAN: {
                return inA < inB ? outT : outF;
            }
            case LESS_THAN_OR_EQUAL: {
                return inA <= inB ? outT : outF;
            }
            case GREATER_THAN: {
                return inA > inB ? outT : outF;
            }
            case GREATER_THAN_OR_EQUAL: {
                return inA >= inB ? outT : outF;
            }
        }
        return outF;
    }

    public static Comparators get(String name) {
        for (Comparators operator : Comparators.values()) {
            if (operator.name().equalsIgnoreCase(name)) {
                return operator;
            }
            if (!operator.representation.equalsIgnoreCase(name)) continue;
            return operator;
        }
        return null;
    }
}

