/*
 * Decompiled with CFR 0.152.
 */
package de.waterdu.atlantis.util.java.interfaces;

import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface ResettableLazy<T>
extends Supplier<T> {
    public static <T> ResettableLazy<T> of(@Nonnull Supplier<T> supplier) {
        return new Fast(supplier);
    }

    public static <T> ResettableLazy<T> concurrentOf(@Nonnull Supplier<T> supplier) {
        return new Concurrent(supplier);
    }

    @Override
    public T get();

    default public void reset() {
    }

    public static final class Concurrent<T>
    implements ResettableLazy<T> {
        private final Object lock = new Object();
        private final Supplier<T> supplier;
        private final AtomicReference<T> instance;

        private Concurrent(Supplier<T> supplier) {
            this.supplier = supplier;
            this.instance = new AtomicReference<Object>(null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable
        public T get() {
            if (this.instance.get() == null) {
                Object object = this.lock;
                synchronized (object) {
                    if (this.instance.get() == null) {
                        this.instance.set(this.supplier.get());
                    }
                }
            }
            return this.instance.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void reset() {
            Object object = this.lock;
            synchronized (object) {
                this.instance.set(null);
            }
        }
    }

    public static final class Fast<T>
    implements ResettableLazy<T> {
        private final Supplier<T> supplier;
        private T instance;

        private Fast(Supplier<T> supplier) {
            this.supplier = supplier;
        }

        @Override
        @Nullable
        public T get() {
            if (this.instance == null) {
                this.instance = this.supplier.get();
            }
            return this.instance;
        }

        @Override
        public void reset() {
            this.instance = null;
        }
    }
}

