/*
 * Decompiled with CFR 0.152.
 */
package de.waterdu.atlantis.util.java;

import com.google.common.collect.Sets;
import de.waterdu.atlantis.util.java.RandomUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.Spliterator;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.stream.Stream;

public class WeightedSet<T>
implements Set<T> {
    private final TreeMap<Double, T> treeMap = new TreeMap();
    private final Map<T, Double> weightMap = new HashMap<T, Double>();
    private double maxWeight = 0.0;
    private double defaultElementWeight = 1.0;

    public static <T> WeightedSet<T> newWeightedSet() {
        return new WeightedSet<T>();
    }

    public void setDefaultElementWeight(double weight) {
        this.defaultElementWeight = weight;
    }

    @Override
    public void clear() {
        this.treeMap.clear();
        this.weightMap.clear();
        this.maxWeight = 0.0;
    }

    public T get() {
        return this.get(RandomUtils.getRandom());
    }

    public T get(Random random) {
        if (this.isEffectivelyEmpty()) {
            return null;
        }
        return this.treeMap.get(this.treeMap.ceilingKey(random.nextDouble() * this.maxWeight));
    }

    public void getAndDo(int count, Consumer<T> consumer) {
        this.getAndDo(RandomUtils.getRandom(), count, consumer);
    }

    public void getAndDo(Random random, int count, Consumer<T> consumer) {
        for (int i = 0; i < count; ++i) {
            consumer.accept(this.get(random));
        }
    }

    public double getWeight(T element) {
        return this.weightMap.getOrDefault(element, 0.0);
    }

    public double getChance(T element) {
        return this.getWeight(element) / this.maxWeight;
    }

    public String getChanceString(T element, int decimalPlaces) {
        String value = String.format("%." + decimalPlaces + "f", this.getChance(element) * 100.0);
        while (value.endsWith(".0")) {
            value = value.substring(0, value.length() - 2);
        }
        if (value.contains(".")) {
            while (value.endsWith("0")) {
                value = value.substring(0, value.length() - 1);
            }
        }
        return value;
    }

    public boolean isEffectivelyEmpty() {
        return this.isEmpty() || this.maxWeight <= 0.0;
    }

    @Override
    public boolean isEmpty() {
        return this.treeMap.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return false;
    }

    @Override
    public int size() {
        return this.treeMap.size();
    }

    public double weight() {
        return this.maxWeight;
    }

    @Override
    public Stream<T> stream() {
        return this.treeMap.values().stream();
    }

    @Override
    public Iterator<T> iterator() {
        return this.treeMap.values().iterator();
    }

    @Override
    public Spliterator<T> spliterator() {
        return this.treeMap.values().spliterator();
    }

    @Override
    public Object[] toArray() {
        return this.treeMap.values().toArray();
    }

    @Override
    public <T1> T1[] toArray(T1[] array) {
        return this.treeMap.values().toArray(array);
    }

    @Override
    public boolean add(T element) {
        return this.add(this.defaultElementWeight, element);
    }

    public boolean add(double weight, T element) {
        if (weight <= 0.0 || this.weightMap.containsKey(element)) {
            return false;
        }
        this.maxWeight += weight;
        this.treeMap.put(this.maxWeight, element);
        this.weightMap.put(element, weight);
        return true;
    }

    @Override
    public boolean remove(Object element) {
        if (this.weightMap.remove(element) == null) {
            return false;
        }
        this.treeMap.clear();
        this.maxWeight = 0.0;
        for (Map.Entry<T, Double> entry : this.weightMap.entrySet()) {
            this.maxWeight += entry.getValue().doubleValue();
            this.treeMap.put(this.maxWeight, entry.getKey());
        }
        return true;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        for (Object element : collection) {
            if (this.weightMap.containsKey(element)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends T> collection) {
        boolean changed = false;
        for (T element : collection) {
            changed |= this.add(element);
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        boolean changed = false;
        HashSet toRemove = Sets.newHashSet();
        for (Object element : this.weightMap.keySet()) {
            if (collection.contains(element)) continue;
            toRemove.add(element);
        }
        for (Object element : toRemove) {
            changed |= this.remove(element);
        }
        return changed;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        boolean changed = false;
        for (Object element : collection) {
            changed |= this.remove(element);
        }
        return changed;
    }
}

