/*
 * Decompiled with CFR 0.152.
 */
package de.waterdu.atlantis.util.java;

import de.waterdu.atlantis.util.java.ExceptionUtils;
import java.util.Random;
import java.util.UUID;

public class UUIDUtils {
    public static final UUID ZEROED_UUID = new UUID(0L, 0L);

    private UUIDUtils() {
        ExceptionUtils.throwCannotInstantiateClassException();
    }

    public static UUID fromString(String uuid) {
        if (uuid.length() == 32) {
            String builder = uuid.substring(0, 8) + '-' + uuid.substring(8, 12) + '-' + uuid.substring(12, 16) + '-' + uuid.substring(16, 20) + '-' + uuid.substring(20, 32);
            return UUID.fromString(builder);
        }
        return UUID.fromString(uuid);
    }

    public static UUID fromHashCode(Object object) {
        return UUIDUtils.fromSeed(object.hashCode());
    }

    public static UUID fromSeed(long seed) {
        int i;
        Random ng = new Random(seed);
        byte[] randomBytes = new byte[16];
        ng.nextBytes(randomBytes);
        randomBytes[6] = (byte)(randomBytes[6] & 0xF);
        randomBytes[6] = (byte)(randomBytes[6] | 0x40);
        randomBytes[8] = (byte)(randomBytes[8] & 0x3F);
        randomBytes[8] = (byte)(randomBytes[8] | 0x80);
        long msb = 0L;
        long lsb = 0L;
        for (i = 0; i < 8; ++i) {
            msb = msb << 8 | (long)(randomBytes[i] & 0xFF);
        }
        for (i = 8; i < 16; ++i) {
            lsb = lsb << 8 | (long)(randomBytes[i] & 0xFF);
        }
        return new UUID(msb, lsb);
    }
}

