/*
 * Decompiled with CFR 0.152.
 */
package de.waterdu.atlantis.util.java;

import com.google.gson.reflect.TypeToken;
import de.waterdu.atlantis.util.java.ExceptionUtils;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public class ReflectionUtils {
    private ReflectionUtils() {
        ExceptionUtils.throwCannotInstantiateClassException();
    }

    public static Type getTypeForField(Field field) {
        Type type = field.getGenericType();
        if (type instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)type;
            return TypeToken.getParameterized((Type)pType.getRawType(), (Type[])pType.getActualTypeArguments()).getType();
        }
        if (type instanceof GenericArrayType) {
            return TypeToken.getArray((Type)((GenericArrayType)type).getGenericComponentType()).getType();
        }
        return TypeToken.get(field.getType()).getType();
    }

    public static boolean doesClassExist(String classpath) {
        try {
            Class.forName(classpath);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static <T> T invokeSafely(Method method, Object object, Object ... args) {
        try {
            return (T)method.invoke(object, args);
        }
        catch (ClassCastException | IllegalAccessException | InvocationTargetException e) {
            return null;
        }
    }
}

