/*
 * Decompiled with CFR 0.152.
 */
package de.waterdu.atlantis.util.java;

import de.waterdu.atlantis.util.java.ExceptionUtils;
import java.util.Random;

public class RandomUtils {
    private static final Random RANDOM = new Random();

    private RandomUtils() {
        ExceptionUtils.throwCannotInstantiateClassException();
    }

    public static Random getRandom() {
        return RANDOM;
    }

    public static byte getBetween(byte min, byte max) {
        if (min > max) {
            byte temp = min;
            min = max;
            max = temp;
        }
        return (byte)(RandomUtils.getRandom().nextInt(max - min + 1) + min);
    }

    public static short getBetween(short min, short max) {
        if (min > max) {
            short temp = min;
            min = max;
            max = temp;
        }
        return (short)(RandomUtils.getRandom().nextInt(max - min + 1) + min);
    }

    public static int getBetween(int min, int max) {
        if (min > max) {
            int temp = min;
            min = max;
            max = temp;
        }
        return RandomUtils.getRandom().nextInt(max - min + 1) + min;
    }

    public static long getBetween(long min, long max) {
        if (min > max) {
            long temp = min;
            min = max;
            max = temp;
        }
        return (long)RandomUtils.getRandom().nextInt((int)(max - min + 1L)) + min;
    }

    public static float getBetween(float min, float max) {
        if (min > max) {
            float temp = min;
            min = max;
            max = temp;
        }
        return RandomUtils.getRandom().nextFloat() * (max - min + 1.0f) + min;
    }

    public static double getBetween(double min, double max) {
        if (min > max) {
            double temp = min;
            min = max;
            max = temp;
        }
        return RandomUtils.getRandom().nextDouble() * (max - min + 1.0) + min;
    }
}

