/*
 * Decompiled with CFR 0.152.
 */
package de.waterdu.atlantis.util.java;

import java.util.Objects;

public class Pair<A, B> {
    private A a;
    private B b;

    private Pair(A a, B b) {
        this.a = a;
        this.b = b;
    }

    public static <A, B> Pair<A, B> of(A a, B b) {
        return new Pair<A, B>(a, b);
    }

    public Pair<A, B> mutable() {
        return Pair.of(this.a, this.b);
    }

    public Pair<A, B> immutable() {
        return Immutable.of(this.a, this.b);
    }

    public A getA() {
        return this.a;
    }

    public B getB() {
        return this.b;
    }

    public void setA(A a) {
        this.a = a;
    }

    public void setB(B b) {
        this.b = b;
    }

    public int hashCode() {
        return (this.a == null ? 0 : this.a.hashCode()) ^ (this.b == null ? 0 : this.b.hashCode());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Pair)) {
            return false;
        }
        Pair other = (Pair)obj;
        return Objects.equals(this.a, other.a) && Objects.equals(this.b, other.b);
    }

    public String toString() {
        return "Pair{[" + (this.a == null ? "null" : this.a.toString()) + "],[" + (this.b == null ? "null" : this.b.toString()) + "]}";
    }

    public static class Immutable<A, B>
    extends Pair<A, B> {
        private Immutable(A a, B b) {
            super(a, b);
        }

        public static <A, B> Immutable<A, B> of(A a, B b) {
            return new Immutable<A, B>(a, b);
        }

        @Override
        public void setA(A a) {
            throw new UnsupportedOperationException("Cannot modify an immutable Pair");
        }

        @Override
        public void setB(B b) {
            throw new UnsupportedOperationException("Cannot modify an immutable Pair");
        }

        @Override
        public String toString() {
            return "ImmutablePair{[" + (this.getA() == null ? "null" : this.getA().toString()) + "],[" + (this.getB() == null ? "null" : this.getB().toString()) + "]}";
        }
    }
}

