/*
 * Decompiled with CFR 0.152.
 */
package de.waterdu.atlantis.util.java;

import de.waterdu.atlantis.util.java.ExceptionUtils;

public class NumberUtils {
    private NumberUtils() {
        ExceptionUtils.throwCannotInstantiateClassException();
    }

    public static double boundDouble(double d) {
        return NumberUtils.isFinite(d) ? d : (d > 0.0 ? Double.MAX_VALUE : -1.7976931348623157E308);
    }

    public static float boundFloat(double d) {
        return NumberUtils.boundFloat((float)d);
    }

    public static float boundFloat(float f) {
        return NumberUtils.isFinite(f) ? f : (f > 0.0f ? Float.MAX_VALUE : -3.4028235E38f);
    }

    public static boolean isFinite(double d) {
        return Math.abs(d) <= Double.MAX_VALUE;
    }

    public static boolean isFinite(float f) {
        return Math.abs(f) <= Float.MAX_VALUE;
    }

    public static int[] arrayOfRange(int start, int end) {
        if (start == end) {
            return new int[]{start};
        }
        int[] array = new int[Math.abs(start - end) + 1];
        int change = start < end ? 1 : -1;
        int index = 0;
        for (int value = start; value != end + change; value += change) {
            array[index++] = value;
        }
        return array;
    }

    public static byte setBit(byte flags, int bitMask, boolean z) {
        flags = z ? (byte)(flags | bitMask) : (byte)(flags & ~bitMask);
        return flags;
    }
}

