/*
 * Decompiled with CFR 0.152.
 */
package de.waterdu.atlantis.util.java;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import de.waterdu.atlantis.util.java.ExceptionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;

public class JsonUtils {
    private JsonUtils() {
        ExceptionUtils.throwCannotInstantiateClassException();
    }

    public static <T> T getOrDefault(JsonObject object, String key, Class<T> type, T def, JsonDeserializationContext context) {
        if (object.has(key) && !object.get(key).isJsonNull()) {
            return (T)context.deserialize(object.get(key), type);
        }
        return def;
    }

    public static <T> T getOrDefault(JsonObject object, String key, TypeToken<T> type, T def, JsonDeserializationContext context) {
        if (object.has(key) && !object.get(key).isJsonNull()) {
            return (T)context.deserialize(object.get(key), type.getType());
        }
        return def;
    }

    public static <T> JsonArray serializeList(Collection<T> collection, Function<T, JsonElement> serializer) {
        JsonArray array = new JsonArray();
        for (T element : collection) {
            array.add(serializer.apply(element));
        }
        return array;
    }

    public static <T> ImmutableList<T> deserializeListImmutable(JsonArray array, Function<JsonElement, T> deserializer) {
        List<T> list = JsonUtils.deserializeList(array, deserializer);
        list.remove(null);
        return ImmutableList.copyOf(list);
    }

    public static <T> List<T> deserializeList(JsonArray array, Function<JsonElement, T> deserializer) {
        ArrayList list = Lists.newArrayList();
        for (JsonElement property : array) {
            T apply = deserializer.apply(property);
            if (apply == null) continue;
            list.add(apply);
        }
        return list;
    }
}

