/*
 * Decompiled with CFR 0.152.
 */
package de.waterdu.atlantis.util.java;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import de.waterdu.atlantis.util.java.ReflectionUtils;
import de.waterdu.atlantis.util.java.interfaces.EventConsumer;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraftforge.eventbus.api.Event;

public abstract class EventHandler<H extends EventHandler<H>> {
    private final Map<Class<? extends Event>, Optional<List<EventConsumer<? extends Event, H>>>> listeners = Maps.newHashMap();
    private final Map<Class<? extends Event>, Optional<Method>> playerGetters = Maps.newHashMap();

    public <E extends Event> void addEventHandler(Class<E> event, EventConsumer<E, H> listener) {
        ((List)this.listeners.computeIfAbsent(event, key -> Optional.of(Lists.newArrayList())).get()).add(listener);
        try {
            this.playerGetters.put(event, Optional.of(event.getMethod("getPlayer", new Class[0])));
        }
        catch (NoSuchMethodException ignored) {
            this.playerGetters.put(event, Optional.empty());
        }
    }

    public <E extends Event> void clearEventHandlers(Class<E> event) {
        ((List)this.listeners.computeIfAbsent(event, key -> Optional.of(Lists.newArrayList())).get()).clear();
    }

    public <E extends Event> void handleEvent(E event) {
        Class<?> type = event.getClass();
        if (this.playerGetters.getOrDefault(type, Optional.empty()).map(method -> this.playerValid((PlayerEntity)ReflectionUtils.invokeSafely(method, event, new Object[0]))).orElse(true).booleanValue()) {
            this.listeners.getOrDefault(type, Optional.empty()).ifPresent(list -> {
                for (EventConsumer consumer : list) {
                    consumer.consume(event, this);
                }
            });
        }
    }

    public boolean playerValid(PlayerEntity player) {
        return true;
    }
}

