/*
 * Decompiled with CFR 0.152.
 */
package de.waterdu.atlantis.util.java;

import com.google.common.collect.Maps;
import de.waterdu.atlantis.util.java.ExceptionUtils;
import java.util.Map;

public class ClassNameCache {
    private static final Map<Class<?>, String> NAME_MAP = Maps.newConcurrentMap();
    private static final Map<Class<?>, String> SIMPLE_NAME_MAP = Maps.newConcurrentMap();
    private static final Map<Class<?>, String> CANONICAL_NAME_MAP = Maps.newConcurrentMap();

    private ClassNameCache() {
        ExceptionUtils.throwCannotInstantiateClassException();
    }

    public static String getName(Class<?> clazz) {
        return NAME_MAP.computeIfAbsent(clazz, ___ -> clazz.getName());
    }

    public static String getSimpleName(Class<?> clazz) {
        return SIMPLE_NAME_MAP.computeIfAbsent(clazz, ___ -> clazz.getSimpleName());
    }

    public static String getCanonicalName(Class<?> clazz) {
        return CANONICAL_NAME_MAP.computeIfAbsent(clazz, ___ -> clazz.getCanonicalName());
    }
}

