/*
 * Decompiled with CFR 0.152.
 */
package de.waterdu.atlantis.util.item;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import de.waterdu.atlantis.AtlantisLogger;
import de.waterdu.atlantis.Settings;
import de.waterdu.atlantis.util.item.ItemUtils;
import de.waterdu.atlantis.util.level.LevelPosition;
import de.waterdu.atlantis.util.text.TextUtils;
import java.lang.reflect.Type;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.registries.ForgeRegistries;

public class ParsedItemStack {
    private final String string;
    private transient ItemStack stack = null;

    private ParsedItemStack(String string) {
        this.string = string;
    }

    public static ParsedItemStack empty() {
        return ParsedItemStack.of(Items.field_190931_a);
    }

    public static ParsedItemStack of(String string) {
        return new ParsedItemStack(string);
    }

    public static ParsedItemStack of(BlockState blockState) {
        return ParsedItemStack.of(blockState.func_177230_c());
    }

    public static ParsedItemStack of(Block block) {
        return ParsedItemStack.of(block.func_199767_j());
    }

    public static ParsedItemStack of(Item item) {
        return ParsedItemStack.of(item.getRegistryName().toString());
    }

    public static ParsedItemStack of(ItemStack stack) {
        StringBuilder builder = new StringBuilder();
        builder.append(stack.func_77973_b().getRegistryName().toString());
        if (stack.func_190916_E() > 1) {
            builder.append(" ").append("count:").append(stack.func_190916_E());
        }
        if (stack.getStack().func_77951_h()) {
            builder.append(" ").append("damage:").append(stack.func_77952_i());
        }
        if (stack.func_77942_o()) {
            builder.append(" ").append(stack.func_77978_p().toString());
        }
        return ParsedItemStack.of(builder.toString());
    }

    public String originalString() {
        return this.string;
    }

    public ItemStack stack() {
        if (this.stack == null) {
            try {
                String[] args = Settings.getSettings().getParsedItemStack(this.string).split(" ");
                this.stack = new ItemStack((IItemProvider)ItemUtils.getItem(args[0], false).orElse(null));
                int curlyCount = 0;
                StringBuilder nbt = new StringBuilder();
                for (int i = 1; i < args.length; ++i) {
                    String arg = args[i];
                    if (arg.startsWith("{")) {
                        curlyCount = 1;
                    }
                    if (curlyCount > 0) {
                        if (nbt.length() > 0) {
                            nbt.append(" ");
                        }
                        nbt.append(arg);
                        if ((curlyCount += TextUtils.countCharOccurrenceDifference(arg, '{', '}')) != 1) continue;
                        this.stack.func_77982_d(JsonToNBT.func_180713_a((String)nbt.toString()));
                        curlyCount = 0;
                        continue;
                    }
                    if (arg.startsWith("x")) {
                        Processor.COUNT.execute(new String[]{"count", arg.substring(1)}, this.stack);
                        continue;
                    }
                    if (arg.startsWith("#")) {
                        Processor.DAMAGE.execute(new String[]{"damage", arg.substring(1)}, this.stack);
                        continue;
                    }
                    Processor.getAndExecute(arg.split(":"), this.stack);
                }
            }
            catch (Exception e) {
                AtlantisLogger.error("Failed to parse ParsedItemStack: {}", this.string);
            }
        }
        return this.stack;
    }

    public Item item() {
        return this.stack().func_77973_b();
    }

    public ItemStack newStack() {
        return this.stack().func_77946_l();
    }

    public ItemStack newStack(int count) {
        ItemStack stack = this.stack().func_77946_l();
        stack.func_190920_e(count);
        return stack;
    }

    public boolean giveOrElse(PlayerEntity player, Consumer<ItemStack> orElse) {
        return ItemUtils.giveOrElse(player, this, orElse);
    }

    public Optional<ItemEntity> drop(LevelPosition position, Consumer<ItemEntity> modifier) {
        return ItemUtils.drop(this, position, modifier);
    }

    public Optional<ItemEntity> drop(LevelPosition position, @Nullable PlayerEntity owner, Consumer<ItemEntity> modifier) {
        return ItemUtils.drop(this, position, owner, modifier);
    }

    public boolean giveOrDrop(PlayerEntity player) {
        return ItemUtils.giveOrDrop(player, this);
    }

    public boolean giveOrDrop(PlayerEntity player, Consumer<ItemStack> onGive, Consumer<ItemEntity> onDrop) {
        return ItemUtils.giveOrDrop(player, this, onGive, onDrop);
    }

    public boolean matches(Object obj) {
        if (this.equals(obj)) {
            return true;
        }
        if (obj instanceof Item) {
            return this.item().equals(obj);
        }
        if (obj instanceof ItemStack) {
            return this.stack().equals((ItemStack)obj, false);
        }
        if (obj instanceof String) {
            String str = (String)obj;
            return this.string.equalsIgnoreCase(str) || this.toString().equalsIgnoreCase(str);
        }
        return false;
    }

    public int hashCode() {
        return this.string.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ParsedItemStack)) {
            return false;
        }
        return this.string.equalsIgnoreCase(((ParsedItemStack)obj).string);
    }

    public String toString() {
        return "ParsedItemStack{" + this.string + "}";
    }

    public static class TypeAdapter
    implements JsonSerializer<ParsedItemStack>,
    JsonDeserializer<ParsedItemStack> {
        public ParsedItemStack deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return ParsedItemStack.of(json.getAsJsonPrimitive().getAsString());
        }

        public JsonElement serialize(ParsedItemStack src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(src.originalString());
        }
    }

    private static enum Processor {
        COUNT((kv, stack) -> stack.func_190920_e(Integer.parseInt(kv[1]))),
        DAMAGE((kv, stack) -> stack.func_196085_b(Integer.parseInt(kv[1]))),
        FLAGS((kv, stack) -> ItemUtils.setFlags(stack, Integer.parseInt(kv[1]))),
        ENCHANTMENT((kv, stack) -> {
            String[] ekv = kv[1].split("-");
            int level = ekv.length == 2 ? Integer.parseInt(ekv[1]) : 1;
            for (Enchantment enchantment : ForgeRegistries.ENCHANTMENTS) {
                if (!enchantment.getRegistryName().func_110623_a().equalsIgnoreCase(ekv[0])) continue;
                ItemUtils.addEnchantment(stack, enchantment, level);
                break;
            }
        }),
        GLOW((kv, stack) -> ItemUtils.applyGlow(stack)),
        TOOLTIP((kv, stack) -> ItemUtils.setPixelmonTooltip(stack, kv[1].replace("_", " "))),
        NAME((kv, stack) -> ItemUtils.setDisplayName(stack, kv[1].replace("_", " ")));

        private final BiConsumer<String[], ItemStack> process;

        private Processor(BiConsumer<String[], ItemStack> process) {
            this.process = process;
        }

        private void execute(String[] kv, ItemStack stack) {
            this.process.accept(kv, stack);
        }

        private static void getAndExecute(String[] kv, ItemStack stack) {
            if (kv.length == 1) {
                kv = new String[]{kv[0], ""};
            }
            try {
                Processor.valueOf(kv[0].toUpperCase()).execute(kv, stack);
            }
            catch (IllegalArgumentException e) {
                AtlantisLogger.warn("Invalid processor in ParsedItemStack: {}", kv[0]);
            }
        }
    }
}

