/*
 * Decompiled with CFR 0.152.
 */
package de.waterdu.atlantis.util.item;

import com.google.common.collect.Maps;
import de.waterdu.atlantis.util.entity.EntityUtils;
import de.waterdu.atlantis.util.item.ItemFlags;
import de.waterdu.atlantis.util.item.ParsedItemStack;
import de.waterdu.atlantis.util.java.ExceptionUtils;
import de.waterdu.atlantis.util.level.LevelPosition;
import de.waterdu.atlantis.util.text.TextUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemUtils {
    private static final Map<Enchantment, Integer> DUMMY_ENCHANTMENT = Maps.newHashMap();

    private ItemUtils() {
        ExceptionUtils.throwCannotInstantiateClassException();
    }

    public static Optional<Item> getItem(String item) {
        return ItemUtils.getItem(item, true);
    }

    public static Optional<Item> getItem(String item, boolean airIsNull) {
        return ItemUtils.getItem(ResourceLocation.func_208304_a((String)item), airIsNull);
    }

    public static Optional<Item> getItem(ResourceLocation location) {
        return ItemUtils.getItem(location, true);
    }

    public static Optional<Item> getItem(ResourceLocation location, boolean airIsNull) {
        Item item = (Item)ForgeRegistries.ITEMS.getValue(location);
        if (item == null || airIsNull && item == Items.field_190931_a) {
            return Optional.empty();
        }
        return Optional.of(item);
    }

    public static <T> void setDisplayName(ItemStack stack, T name) {
        stack.func_200302_a((ITextComponent)TextUtils.asComponent(name));
    }

    public static <T> void setDisplayNameWithPlaceholders(PlayerEntity player, ItemStack stack, T name) {
        stack.func_200302_a((ITextComponent)TextUtils.asComponentWithPlaceholders(player, name));
    }

    @SafeVarargs
    public static <T> void setDisplayLore(ItemStack stack, T ... lore) {
        ListNBT list = new ListNBT();
        for (T loreLine : lore) {
            list.add((Object)StringNBT.func_229705_a_((String)ITextComponent.Serializer.func_150696_a((ITextComponent)TextUtils.asComponent(loreLine))));
        }
        stack.func_190925_c("display").func_218657_a("Lore", (INBT)list);
    }

    public static <T> void setDisplayLore(ItemStack stack, Collection<T> lore) {
        ListNBT list = new ListNBT();
        for (T loreLine : lore) {
            list.add((Object)StringNBT.func_229705_a_((String)ITextComponent.Serializer.func_150696_a((ITextComponent)TextUtils.asComponent(loreLine))));
        }
        stack.func_190925_c("display").func_218657_a("Lore", (INBT)list);
    }

    @SafeVarargs
    public static <T> void addDisplayLore(ItemStack stack, T ... lore) {
        CompoundNBT display;
        ListNBT list = stack.func_77942_o() && stack.func_77978_p().func_74764_b("display") ? ((display = stack.func_196082_o().func_74775_l("display")).func_74764_b("Lore") ? display.func_150295_c("Lore", 8) : new ListNBT()) : new ListNBT();
        for (T loreLine : lore) {
            list.add((Object)StringNBT.func_229705_a_((String)ITextComponent.Serializer.func_150696_a((ITextComponent)TextUtils.asComponent(loreLine))));
        }
        stack.func_190925_c("display").func_218657_a("Lore", (INBT)list);
    }

    public static <T> void addDisplayLore(ItemStack stack, Collection<T> lore) {
        CompoundNBT display;
        ListNBT list = stack.func_77942_o() && stack.func_77978_p().func_74764_b("display") ? ((display = stack.func_196082_o().func_74775_l("display")).func_74764_b("Lore") ? display.func_150295_c("Lore", 8) : new ListNBT()) : new ListNBT();
        for (T loreLine : lore) {
            list.add((Object)StringNBT.func_229705_a_((String)ITextComponent.Serializer.func_150696_a((ITextComponent)TextUtils.asComponent(loreLine))));
        }
        stack.func_190925_c("display").func_218657_a("Lore", (INBT)list);
    }

    @SafeVarargs
    public static <T> void setDisplayLoreWithPlaceholders(PlayerEntity player, ItemStack stack, T ... lore) {
        ListNBT list = new ListNBT();
        for (T loreLine : lore) {
            list.add((Object)StringNBT.func_229705_a_((String)ITextComponent.Serializer.func_150696_a((ITextComponent)TextUtils.asComponentWithPlaceholders(player, loreLine))));
        }
        stack.func_190925_c("display").func_218657_a("Lore", (INBT)list);
    }

    public static <T> void setDisplayLoreWithPlaceholders(PlayerEntity player, ItemStack stack, Collection<T> lore) {
        ListNBT list = new ListNBT();
        for (T loreLine : lore) {
            list.add((Object)StringNBT.func_229705_a_((String)ITextComponent.Serializer.func_150696_a((ITextComponent)TextUtils.asComponentWithPlaceholders(player, loreLine))));
        }
        stack.func_190925_c("display").func_218657_a("Lore", (INBT)list);
    }

    @SafeVarargs
    public static <T> void addDisplayLoreWithPlaceholders(PlayerEntity player, ItemStack stack, T ... lore) {
        CompoundNBT display;
        ListNBT list = stack.func_77942_o() && stack.func_77978_p().func_74764_b("display") ? ((display = stack.func_196082_o().func_74775_l("display")).func_74764_b("Lore") ? display.func_150295_c("Lore", 8) : new ListNBT()) : new ListNBT();
        for (T loreLine : lore) {
            list.add((Object)StringNBT.func_229705_a_((String)ITextComponent.Serializer.func_150696_a((ITextComponent)TextUtils.asComponentWithPlaceholders(player, loreLine))));
        }
        stack.func_190925_c("display").func_218657_a("Lore", (INBT)list);
    }

    public static <T> void addDisplayLoreWithPlaceholders(PlayerEntity player, ItemStack stack, Collection<T> lore) {
        CompoundNBT display;
        ListNBT list = stack.func_77942_o() && stack.func_77978_p().func_74764_b("display") ? ((display = stack.func_196082_o().func_74775_l("display")).func_74764_b("Lore") ? display.func_150295_c("Lore", 8) : new ListNBT()) : new ListNBT();
        for (T loreLine : lore) {
            list.add((Object)StringNBT.func_229705_a_((String)ITextComponent.Serializer.func_150696_a((ITextComponent)TextUtils.asComponentWithPlaceholders(player, loreLine))));
        }
        stack.func_190925_c("display").func_218657_a("Lore", (INBT)list);
    }

    @SafeVarargs
    public static <T> void prependDisplayLore(ItemStack stack, T ... lines) {
        ListNBT oldLore;
        CompoundNBT tag = stack.func_190925_c("display");
        ListNBT lore = new ListNBT();
        for (T loreLine : lines) {
            lore.add((Object)StringNBT.func_229705_a_((String)ITextComponent.Serializer.func_150696_a((ITextComponent)TextUtils.asComponent(loreLine))));
        }
        if (tag.func_74764_b("Lore") && !(oldLore = tag.func_150295_c("Lore", 8)).isEmpty()) {
            for (INBT obj : oldLore) {
                if (!(obj instanceof StringNBT)) continue;
                lore.add((Object)obj);
            }
        }
        tag.func_218657_a("Lore", (INBT)lore);
    }

    public static <T> void prependDisplayLore(ItemStack stack, Collection<T> lines) {
        ListNBT oldLore;
        CompoundNBT tag = stack.func_190925_c("display");
        ListNBT lore = new ListNBT();
        for (T loreLine : lines) {
            lore.add((Object)StringNBT.func_229705_a_((String)ITextComponent.Serializer.func_150696_a((ITextComponent)TextUtils.asComponent(loreLine))));
        }
        if (tag.func_74764_b("Lore") && !(oldLore = tag.func_150295_c("Lore", 8)).isEmpty()) {
            for (INBT obj : oldLore) {
                if (!(obj instanceof StringNBT)) continue;
                lore.add((Object)obj);
            }
        }
        tag.func_218657_a("Lore", (INBT)lore);
    }

    @SafeVarargs
    public static <T> void prependDisplayLoreWithPlaceholders(PlayerEntity player, ItemStack stack, T ... lines) {
        ListNBT oldLore;
        CompoundNBT tag = stack.func_190925_c("display");
        ListNBT lore = new ListNBT();
        for (T loreLine : lines) {
            lore.add((Object)StringNBT.func_229705_a_((String)ITextComponent.Serializer.func_150696_a((ITextComponent)TextUtils.asComponentWithPlaceholders(player, loreLine))));
        }
        if (tag.func_74764_b("Lore") && !(oldLore = tag.func_150295_c("Lore", 8)).isEmpty()) {
            for (INBT obj : oldLore) {
                if (!(obj instanceof StringNBT)) continue;
                lore.add((Object)obj);
            }
        }
        tag.func_218657_a("Lore", (INBT)lore);
    }

    public static <T> void prependDisplayLoreWithPlaceholders(PlayerEntity player, ItemStack stack, Collection<T> lines) {
        ListNBT oldLore;
        CompoundNBT tag = stack.func_190925_c("display");
        ListNBT lore = new ListNBT();
        for (T loreLine : lines) {
            lore.add((Object)StringNBT.func_229705_a_((String)ITextComponent.Serializer.func_150696_a((ITextComponent)TextUtils.asComponentWithPlaceholders(player, loreLine))));
        }
        if (tag.func_74764_b("Lore") && !(oldLore = tag.func_150295_c("Lore", 8)).isEmpty()) {
            for (INBT obj : oldLore) {
                if (!(obj instanceof StringNBT)) continue;
                lore.add((Object)obj);
            }
        }
        tag.func_218657_a("Lore", (INBT)lore);
    }

    public static void setPixelmonTooltip(ItemStack stack, String tooltip) {
        stack.func_196082_o().func_74778_a("tooltip", tooltip);
    }

    public static void setEffect(ItemStack stack, boolean effect) {
        stack.func_196082_o().func_74757_a("HasEffect", effect);
    }

    public static void setFlags(ItemStack stack, int flags) {
        stack.func_196082_o().func_74768_a("HideFlags", flags);
    }

    public static void setFlags(ItemStack stack, ItemFlags ... flags) {
        ItemUtils.setFlags(stack, ItemFlags.valueOf(flags));
    }

    public static void addFlags(ItemStack stack, int flags) {
        stack.func_196082_o().func_74768_a("HideFlags", stack.func_196082_o().func_74762_e("HideFlags") | flags);
    }

    public static void addFlags(ItemStack stack, ItemFlags ... flags) {
        ItemUtils.addFlags(stack, ItemFlags.valueOf(flags));
    }

    public static void addEnchantment(ItemStack stack, Enchantment enchantment, int tier) {
        HashMap map = Maps.newHashMap();
        map.put(enchantment, tier);
        ItemUtils.addEnchantments(stack, map);
    }

    public static void addEnchantments(ItemStack stack, Map<Enchantment, Integer> enchantments) {
        EnchantmentHelper.func_82782_a(enchantments, (ItemStack)stack);
    }

    public static void addDummyEnchantment(ItemStack stack) {
        ItemUtils.addFlags(stack, ItemFlags.HIDE_ENCHANTMENTS);
        ItemUtils.addEnchantments(stack, ItemUtils.getDummyEnchantment());
    }

    public static Map<Enchantment, Integer> getDummyEnchantment() {
        if (DUMMY_ENCHANTMENT.isEmpty()) {
            DUMMY_ENCHANTMENT.put(Enchantments.field_185312_x, 1);
        }
        return DUMMY_ENCHANTMENT;
    }

    public static void applyGlow(ItemStack stack) {
        ItemUtils.setEffect(stack, true);
        ItemUtils.addDummyEnchantment(stack);
    }

    public static void ensureTagExists(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new CompoundNBT());
        }
    }

    public static boolean giveOrElse(PlayerEntity player, ParsedItemStack stack, Consumer<ItemStack> orElse) {
        return ItemUtils.giveOrElse(player, stack.newStack(), orElse);
    }

    public static boolean giveOrElse(PlayerEntity player, ItemStack stack, Consumer<ItemStack> orElse) {
        if (!player.func_191521_c(stack)) {
            orElse.accept(stack);
            return false;
        }
        return true;
    }

    public static Optional<ItemEntity> drop(ParsedItemStack stack, LevelPosition position, Consumer<ItemEntity> modifier) {
        return ItemUtils.drop(stack, position, null, modifier);
    }

    public static Optional<ItemEntity> drop(ItemStack stack, LevelPosition position, Consumer<ItemEntity> modifier) {
        return ItemUtils.drop(stack, position, null, modifier);
    }

    public static Optional<ItemEntity> drop(ParsedItemStack stack, LevelPosition position, @Nullable PlayerEntity owner, Consumer<ItemEntity> modifier) {
        return ItemUtils.drop(stack.newStack(), position, owner, modifier);
    }

    public static Optional<ItemEntity> drop(ItemStack stack, LevelPosition position, @Nullable PlayerEntity owner, Consumer<ItemEntity> modifier) {
        return EntityUtils.createEntity(EntityType.field_200765_E, position, false, true, entity -> {
            entity.func_92058_a(stack);
            int n = entity.lifespan = stack.func_77973_b() == null ? 6000 : stack.getEntityLifespan((World)position.level());
            if (owner != null) {
                entity.func_174873_u();
                entity.func_200216_c(owner.func_110124_au());
                entity.func_200217_b(owner.func_110124_au());
            }
            modifier.accept((ItemEntity)entity);
        });
    }

    public static boolean giveOrDrop(PlayerEntity player, ParsedItemStack stack) {
        return ItemUtils.giveOrDrop(player, stack, (ItemStack item) -> {}, (ItemEntity entity) -> {});
    }

    public static boolean giveOrDrop(PlayerEntity player, ItemStack stack) {
        return ItemUtils.giveOrDrop(player, stack, (ItemStack item) -> {}, (ItemEntity entity) -> {});
    }

    public static boolean giveOrDrop(PlayerEntity player, ParsedItemStack stack, Consumer<ItemStack> onGive, Consumer<ItemEntity> onDrop) {
        return ItemUtils.giveOrDrop(player, stack.newStack(), onGive, onDrop);
    }

    public static boolean giveOrDrop(PlayerEntity player, ItemStack stack, Consumer<ItemStack> onGive, Consumer<ItemEntity> onDrop) {
        if (ItemUtils.giveOrElse(player, stack, (ItemStack orElse) -> ItemUtils.drop(orElse, new LevelPosition((Entity)player), player, (ItemEntity entity) -> {}).ifPresent(onDrop))) {
            onGive.accept(stack);
            return true;
        }
        return false;
    }
}

