/*
 * Decompiled with CFR 0.152.
 */
package de.waterdu.atlantis.util.item;

import de.waterdu.atlantis.util.item.ItemFlags;
import de.waterdu.atlantis.util.item.ItemUtils;
import de.waterdu.atlantis.util.item.ParsedItemStack;
import java.util.Collection;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;

public class ItemBuilder {
    private ItemStack stack;
    private ServerPlayerEntity target;

    private ItemBuilder(ItemStack stack) {
        this.stack = stack;
        this.target = null;
    }

    public static ItemBuilder builder() {
        return ItemBuilder.builder((ItemStack)null);
    }

    public static ItemBuilder builder(String item) {
        return ItemBuilder.builder(ParsedItemStack.of(item));
    }

    public static ItemBuilder builder(IItemProvider item) {
        return ItemBuilder.builder(new ItemStack(item));
    }

    public static ItemBuilder builder(ParsedItemStack stack) {
        return ItemBuilder.builder(stack.newStack());
    }

    public static ItemBuilder builder(ItemStack stack) {
        return new ItemBuilder(stack);
    }

    private ItemStack getStackInternal() {
        if (this.stack == null) {
            this.stack = new ItemStack(null);
        }
        return this.stack;
    }

    private boolean hasPlaceholderTarget() {
        return this.target != null;
    }

    public ItemBuilder placeholders(ServerPlayerEntity target) {
        this.target = target;
        return this;
    }

    public ItemBuilder item(String item) {
        return this.stack(ParsedItemStack.of(item));
    }

    public ItemBuilder item(IItemProvider item) {
        ItemStack old = this.getStackInternal();
        return this.stack(new ItemStack(item, old.func_190916_E(), old.func_77978_p()), false);
    }

    public ItemBuilder stack(ParsedItemStack stack) {
        return this.stack(stack.newStack(), false);
    }

    public ItemBuilder stack(ItemStack stack) {
        return this.stack(stack, true);
    }

    public ItemBuilder stack(ItemStack stack, boolean copy) {
        this.stack = copy ? stack.func_77946_l() : stack;
        return this;
    }

    public ItemBuilder count(int count) {
        this.stack.func_190920_e(count);
        return this;
    }

    public ItemBuilder grow(int amount) {
        this.stack.func_190917_f(amount);
        return this;
    }

    public ItemBuilder shrink(int amount) {
        this.stack.func_190918_g(amount);
        return this;
    }

    public ItemBuilder damage(int damage) {
        this.stack.func_196085_b(damage);
        return this;
    }

    public ItemBuilder name(Object name) {
        if (this.hasPlaceholderTarget()) {
            ItemUtils.setDisplayNameWithPlaceholders((PlayerEntity)this.target, this.stack, name);
        } else {
            ItemUtils.setDisplayName(this.stack, name);
        }
        return this;
    }

    public ItemBuilder lore(Object ... lore) {
        if (this.hasPlaceholderTarget()) {
            ItemUtils.setDisplayLoreWithPlaceholders((PlayerEntity)this.target, this.stack, lore);
        } else {
            ItemUtils.setDisplayLore(this.stack, lore);
        }
        return this;
    }

    public ItemBuilder lore(Collection<Object> lore) {
        if (this.hasPlaceholderTarget()) {
            ItemUtils.setDisplayLoreWithPlaceholders((PlayerEntity)this.target, this.stack, lore);
        } else {
            ItemUtils.setDisplayLore(this.stack, lore);
        }
        return this;
    }

    public ItemBuilder addLore(Object ... lore) {
        if (this.hasPlaceholderTarget()) {
            ItemUtils.addDisplayLoreWithPlaceholders((PlayerEntity)this.target, this.stack, lore);
        } else {
            ItemUtils.addDisplayLore(this.stack, lore);
        }
        return this;
    }

    public ItemBuilder addLore(Collection<Object> lore) {
        if (this.hasPlaceholderTarget()) {
            ItemUtils.addDisplayLoreWithPlaceholders((PlayerEntity)this.target, this.stack, lore);
        } else {
            ItemUtils.addDisplayLore(this.stack, lore);
        }
        return this;
    }

    public ItemBuilder flags(ItemFlags ... flags) {
        ItemUtils.setFlags(this.stack, flags);
        return this;
    }

    public ItemBuilder flags(int flags) {
        ItemUtils.setFlags(this.stack, flags);
        return this;
    }

    public ItemBuilder allFlags() {
        return this.flags(ItemFlags.ALL);
    }

    public ItemBuilder glow() {
        ItemUtils.applyGlow(this.stack);
        return this;
    }

    public ItemBuilder enchantment(Enchantment enchantment) {
        return this.enchantment(enchantment, 1);
    }

    public ItemBuilder enchantment(Enchantment enchantment, int tier) {
        ItemUtils.addEnchantment(this.stack, enchantment, tier);
        return this;
    }

    public ItemBuilder enchantments(Map<Enchantment, Integer> enchantments) {
        ItemUtils.addEnchantments(this.stack, enchantments);
        return this;
    }

    public ItemBuilder attribute(Attribute attribute, AttributeModifier modifier) {
        return this.attribute(attribute, modifier, null);
    }

    public ItemBuilder attribute(Attribute attribute, AttributeModifier modifier, EquipmentSlotType slot) {
        this.stack.func_185129_a(attribute, modifier, slot);
        return this;
    }

    public ItemBuilder representation(Entity representation) {
        this.stack.func_234695_a_(representation);
        return this;
    }

    public ItemBuilder popTime(int popTime) {
        this.stack.func_190915_d(popTime);
        return this;
    }

    public ItemBuilder repairCost(int repairCost) {
        this.stack.func_82841_c(repairCost);
        return this;
    }

    public ItemBuilder nbt(Consumer<CompoundNBT> nbt) {
        nbt.accept(this.stack.func_196082_o());
        return this;
    }

    public ItemBuilder nbt(CompoundNBT nbt) {
        this.stack.func_77982_d(nbt);
        return this;
    }

    public ItemStack buildAsStack() {
        return this.getStackInternal();
    }

    public ParsedItemStack buildAsParsedStack() {
        return ParsedItemStack.of(this.buildAsStack());
    }
}

