/*
 * Decompiled with CFR 0.152.
 */
package de.waterdu.atlantis.util.item;

import de.waterdu.atlantis.util.java.ExceptionUtils;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CommandBlockBlock;
import net.minecraft.block.JigsawBlock;
import net.minecraft.block.StructureBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.registries.ForgeRegistries;

public class BlockUtils {
    private BlockUtils() {
        ExceptionUtils.throwCannotInstantiateClassException();
    }

    public static Optional<Block> getBlock(String block) {
        return BlockUtils.getBlock(block, true);
    }

    public static Optional<Block> getBlock(String block, boolean airIsNull) {
        return BlockUtils.getBlock(ResourceLocation.func_208304_a((String)block), airIsNull);
    }

    public static Optional<Block> getBlock(ResourceLocation location) {
        return BlockUtils.getBlock(location, true);
    }

    public static Optional<Block> getBlock(ResourceLocation location, boolean airIsNull) {
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(location);
        if (block == null || airIsNull && block == Blocks.field_150350_a) {
            return Optional.empty();
        }
        return Optional.of(block);
    }

    public static boolean setBlock(PlayerEntity player, BlockPos pos, BlockState state, boolean ifAir) {
        return BlockUtils.setBlock(player, pos, state, ifAir, false);
    }

    public static boolean setBlock(PlayerEntity player, BlockPos pos, BlockState state, boolean ifAir, boolean ignoreChecks) {
        if (player instanceof ServerPlayerEntity) {
            ServerPlayerEntity serverPlayer = (ServerPlayerEntity)player;
            ServerWorld level = serverPlayer.func_71121_q();
            if (ifAir && !state.func_196958_f()) {
                return false;
            }
            if (ignoreChecks || BlockUtils.canPlaceBlock(player, pos)) {
                if (ForgeEventFactory.onBlockPlace((Entity)player, (BlockSnapshot)BlockSnapshot.create((RegistryKey)serverPlayer.func_71121_q().func_234923_W_(), (IWorld)serverPlayer.func_71121_q(), (BlockPos)pos), (Direction)Direction.UP)) {
                    return false;
                }
                level.func_180501_a(pos, state, 2);
                return true;
            }
        }
        return false;
    }

    public static boolean canPlaceBlock(PlayerEntity player, BlockPos pos) {
        if (player instanceof ServerPlayerEntity) {
            ServerPlayerEntity serverPlayer = (ServerPlayerEntity)player;
            return player.func_223729_a((World)serverPlayer.func_71121_q(), pos, serverPlayer.field_71134_c.func_73081_b());
        }
        return false;
    }

    public static boolean canRemoveBlock(PlayerEntity player, BlockPos pos) {
        ServerWorld level;
        BlockState state;
        Block block;
        if (player instanceof ServerPlayerEntity && (block = (state = (level = ((ServerPlayerEntity)player).func_71121_q()).func_180495_p(pos)).func_177230_c()).canHarvestBlock(state, (IBlockReader)level, pos, player)) {
            BlockEvent.BreakEvent event = new BlockEvent.BreakEvent((World)level, pos, state, player);
            return !MinecraftForge.EVENT_BUS.post((Event)event);
        }
        return false;
    }

    public static boolean removeBlock(PlayerEntity player, BlockPos pos) {
        return BlockUtils.removeBlock(player, pos, true);
    }

    public static boolean removeBlock(PlayerEntity player, BlockPos pos, boolean attemptDrop) {
        ServerPlayerEntity serverPlayer;
        ServerWorld level;
        BlockState state;
        Block block;
        if (player instanceof ServerPlayerEntity && (block = (state = (level = (serverPlayer = (ServerPlayerEntity)player).func_71121_q()).func_180495_p(pos)).func_177230_c()).canHarvestBlock(state, (IBlockReader)level, pos, player)) {
            int exp = ForgeHooks.onBlockBreakEvent((World)level, (GameType)serverPlayer.field_71134_c.func_73081_b(), (ServerPlayerEntity)serverPlayer, (BlockPos)pos);
            if (exp == -1) {
                return false;
            }
            TileEntity tileentity = level.func_175625_s(pos);
            if ((block instanceof CommandBlockBlock || block instanceof StructureBlock || block instanceof JigsawBlock) && !player.func_195070_dx()) {
                level.func_184138_a(pos, state, state, 3);
                return false;
            }
            if (player.func_184614_ca().onBlockStartBreak(pos, player)) {
                return false;
            }
            if (player.func_223729_a((World)level, pos, serverPlayer.field_71134_c.func_73081_b())) {
                return false;
            }
            if (player.func_184812_l_()) {
                BlockUtils.removeBlock0((World)level, player, pos, false);
                BlockUtils.animateBlockBreak((World)level, pos, state);
            } else {
                ItemStack itemstack = player.func_184614_ca();
                ItemStack itemstack1 = itemstack.func_77946_l();
                boolean flag1 = state.canHarvestBlock((IBlockReader)level, pos, player);
                itemstack.func_179548_a((World)level, state, pos, player);
                if (itemstack.func_190926_b() && !itemstack1.func_190926_b()) {
                    ForgeEventFactory.onPlayerDestroyItem((PlayerEntity)player, (ItemStack)itemstack1, (Hand)Hand.MAIN_HAND);
                }
                boolean flag = BlockUtils.removeBlock0((World)level, player, pos, flag1);
                BlockUtils.animateBlockBreak((World)level, pos, state);
                if (attemptDrop && flag && flag1) {
                    block.func_180657_a((World)level, player, pos, state, tileentity, itemstack1);
                }
                if (attemptDrop && flag && exp > 0) {
                    state.func_177230_c().func_180637_b(level, pos, exp);
                }
            }
            return true;
        }
        return false;
    }

    private static boolean removeBlock0(World world, PlayerEntity player, BlockPos pos, boolean canHarvest) {
        BlockState state = world.func_180495_p(pos);
        boolean removed = state.removedByPlayer(world, pos, player, canHarvest, world.func_204610_c(pos));
        if (removed) {
            state.func_177230_c().func_176206_d((IWorld)world, pos, state);
        }
        return removed;
    }

    public static void animateBlockBreak(World world, BlockPos pos, BlockState state) {
        world.func_217379_c(2001, pos, Block.func_196246_j((BlockState)state));
    }
}

