/*
 * Decompiled with CFR 0.152.
 */
package de.waterdu.atlantis.util.entity;

import com.google.common.collect.Maps;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import de.waterdu.atlantis.comm.MojangAPI;
import de.waterdu.atlantis.comm.Skin;
import de.waterdu.atlantis.comm.SkinQuery;
import de.waterdu.atlantis.file.AtlantisConfig;
import de.waterdu.atlantis.file.AtlantisConfigProxy;
import de.waterdu.atlantis.file.AtlantisData;
import de.waterdu.atlantis.file.datatypes.PlayerData;
import de.waterdu.atlantis.playerdata.UUIDNameCache;
import de.waterdu.atlantis.ui.api.AtlantisUI;
import de.waterdu.atlantis.ui.api.Page;
import de.waterdu.atlantis.ui.internal.Buttons;
import de.waterdu.atlantis.util.entity.EntityUtils;
import de.waterdu.atlantis.util.entity.PermissionUtils;
import de.waterdu.atlantis.util.java.interfaces.ResettableLazy;
import de.waterdu.atlantis.util.level.LevelPosition;
import de.waterdu.atlantis.util.level.LevelUtils;
import de.waterdu.atlantis.util.network.NetworkUtils;
import de.waterdu.atlantis.util.server.ServerUtils;
import de.waterdu.atlantis.util.text.MessageUtils;
import java.lang.reflect.Type;
import java.net.SocketAddress;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.Util;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.Lazy;

public class PlayerReference {
    private static final Map<UUID, Optional<PlayerReference>> REFERENCES = Maps.newConcurrentMap();
    private final Optional<PlayerReference> optional = Optional.of(this);
    private final Lazy<Optional<UUID>> uuid = () -> Optional.of(uuid);
    private final ResettableLazy<Optional<String>> name = () -> Optional.of(UUIDNameCache.get(uuid));
    private final ResettableLazy<Optional<ServerPlayerEntity>> entity = () -> ServerUtils.getPlayer(uuid);
    private final Map<Class<?>, PlayerData> data = Maps.newHashMap();

    private PlayerReference(UUID uuid) {
    }

    public static <T> Optional<PlayerReference> getSafely(T player) {
        UUID uuid;
        if (player instanceof UUID) {
            uuid = (UUID)player;
        } else if (player instanceof String) {
            uuid = UUIDNameCache.get((String)player);
        } else if (player instanceof PlayerEntity) {
            uuid = ((PlayerEntity)player).func_110124_au();
        } else {
            if (player instanceof PlayerReference) {
                return ((PlayerReference)player).optional();
            }
            if (player instanceof PlayerData) {
                uuid = ((PlayerData)player).getUUID();
            } else {
                return Optional.empty();
            }
        }
        if (Util.field_240973_b_.equals(uuid)) {
            return Optional.empty();
        }
        return REFERENCES.computeIfAbsent(uuid, key -> new PlayerReference((UUID)key).optional());
    }

    public static <T> PlayerReference get(T player) {
        return PlayerReference.getSafely(player).orElseThrow(() -> new IllegalArgumentException("Cannot get player reference from " + player.toString()));
    }

    public Optional<PlayerReference> optional() {
        return this.optional;
    }

    public <T> boolean is(T playerLike) {
        if (playerLike instanceof Optional) {
            return ((Optional)playerLike).map(this::is).orElse(false);
        }
        if (playerLike instanceof PlayerReference) {
            return this.equals(playerLike);
        }
        if (playerLike instanceof UUID) {
            return this.uuid().equals(playerLike);
        }
        if (playerLike instanceof String) {
            return this.name().equals(playerLike);
        }
        if (playerLike instanceof PlayerEntity) {
            return this.uuid().equals(((PlayerEntity)playerLike).func_110124_au());
        }
        if (playerLike instanceof PlayerData) {
            return this.uuid().equals(((PlayerData)playerLike).getUUID());
        }
        return false;
    }

    public UUID uuid() {
        return ((Optional)this.uuid.get()).orElse(Util.field_240973_b_);
    }

    public String name() {
        return this.name.get().orElse("?");
    }

    public Optional<ServerPlayerEntity> entity() {
        return this.entity.get();
    }

    public ServerPlayerEntity entityDirect() {
        return this.entity().orElse(null);
    }

    public LevelPosition position() {
        return this.entity().map(LevelPosition::new).orElse(null);
    }

    public <T extends PlayerData> CompletableFuture<T> data(Class<T> type) {
        return this.data(AtlantisConfig.getModForClass(type), type);
    }

    public <T extends PlayerData> CompletableFuture<T> data(String modid, Class<T> type) {
        if (this.data.containsKey(type)) {
            return CompletableFuture.completedFuture(this.data.get(type));
        }
        return AtlantisConfigProxy.of(modid).getFor(type, this.uuid()).whenComplete((data, err) -> {
            if (data != null) {
                this.data.put(type, (PlayerData)data);
            }
        });
    }

    public <T extends PlayerData> T dataNow(Class<T> type) {
        return this.dataNow(AtlantisConfig.getModForClass(type), type);
    }

    public <T extends PlayerData> T dataNow(String modid, Class<T> type) {
        if (this.data.containsKey(type)) {
            return (T)this.data.get(type);
        }
        return (T)((PlayerData)this.data(modid, type).join());
    }

    public CompletableFuture<de.waterdu.atlantis.playerdata.PlayerData> atlantisData() {
        return AtlantisData.getPlayer(this);
    }

    public ItemStack skull() {
        return AtlantisData.getSkull(this.uuid());
    }

    public CompletableFuture<Skin> skin() {
        return MojangAPI.query(SkinQuery.from(this.uuid()));
    }

    public Optional<SocketAddress> address() {
        return NetworkUtils.address(this);
    }

    public Optional<String> ip() {
        return NetworkUtils.ip(this);
    }

    public void sound(SoundEvent sound) {
        this.sound(sound, SoundCategory.MASTER);
    }

    public void sound(SoundEvent sound, SoundCategory category) {
        this.sound(sound, category, 1.0f, 1.0f);
    }

    public void sound(SoundEvent sound, float volume, float pitch) {
        this.sound(sound, SoundCategory.MASTER, volume, pitch);
    }

    public void sound(SoundEvent sound, SoundCategory category, float volume, float pitch) {
        this.entity().ifPresent(entity -> EntityUtils.playSound((PlayerEntity)entity, sound, category, volume, pitch));
    }

    public <T> void send(T message) {
        MessageUtils.send(message, this);
    }

    public void open(Page page) {
        AtlantisUI.open(this, page);
    }

    public void open(Page page, int currentPage) {
        AtlantisUI.open(this, page, currentPage);
    }

    public void open(Page page, Buttons buttons) {
        AtlantisUI.open(this, page, buttons);
    }

    public void open(Page page, boolean waitForScreen) {
        AtlantisUI.open(this, page, waitForScreen);
    }

    public void open(Page page, Buttons buttons, int currentPage) {
        AtlantisUI.open(this, page, buttons, currentPage);
    }

    public void open(Page page, boolean waitForScreen, int currentPage) {
        AtlantisUI.open(this, page, waitForScreen, currentPage);
    }

    public void open(Page page, Buttons buttons, boolean waitForScreen) {
        AtlantisUI.open(this, page, buttons, waitForScreen);
    }

    public void open(Page page, Buttons buttons, boolean waitForScreen, int currentPage) {
        AtlantisUI.open(this, page, buttons, waitForScreen, currentPage);
    }

    public void close() {
        AtlantisUI.close(this);
    }

    public boolean permission(String permission) {
        return PermissionUtils.hasPermission(this, permission);
    }

    public ServerWorld level() {
        return this.entity().map(ServerPlayerEntity::func_71121_q).orElse(LevelUtils.overworld());
    }

    public PlayerInventory inventory() {
        return this.entity().map(entity -> entity.field_71071_by).orElse(null);
    }

    public void reset() {
        this.name.reset();
        this.entity.reset();
    }

    public int hashCode() {
        return this.uuid().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PlayerReference)) {
            return false;
        }
        return this.uuid().equals(((PlayerReference)obj).uuid());
    }

    public String toString() {
        return "PlayerReference{" + this.uuid() + "}";
    }

    public static class TypeAdapter
    implements JsonSerializer<PlayerReference>,
    JsonDeserializer<PlayerReference> {
        public PlayerReference deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return PlayerReference.get(UUID.fromString(json.getAsString()));
        }

        public JsonElement serialize(PlayerReference src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(src.uuid().toString());
        }
    }
}

